// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateRealtimeLogConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.RealtimeLogConfig
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateRealtimeLogConfigOperationDeserializer: HttpDeserializer.NonStreaming<CreateRealtimeLogConfigResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateRealtimeLogConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateRealtimeLogConfigError(context, call, payload)
        }
        val builder = CreateRealtimeLogConfigResponse.Builder()

        if (payload != null) {
            deserializeCreateRealtimeLogConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateRealtimeLogConfigError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRealtimeLogConfigs" -> TooManyRealtimeLogConfigsDeserializer().deserialize(context, wrappedCall, payload)
        "RealtimeLogConfigAlreadyExists" -> RealtimeLogConfigAlreadyExistsDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateRealtimeLogConfigOperationBody(builder: CreateRealtimeLogConfigResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // RealtimeLogConfig com.amazonaws.cloudfront#CreateRealtimeLogConfigResult$RealtimeLogConfig
            "RealtimeLogConfig" -> builder.realtimeLogConfig = deserializeRealtimeLogConfigDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
