// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.FieldLevelEncryption
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateFieldLevelEncryptionConfigOperationDeserializer: HttpDeserializer.NonStreaming<CreateFieldLevelEncryptionConfigResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateFieldLevelEncryptionConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateFieldLevelEncryptionConfigError(context, call, payload)
        }
        val builder = CreateFieldLevelEncryptionConfigResponse.Builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        if (payload != null) {
            builder.fieldLevelEncryption = deserializeFieldLevelEncryptionPayload(payload)
        }

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateFieldLevelEncryptionConfigError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "QueryArgProfileEmpty" -> QueryArgProfileEmptyDeserializer().deserialize(context, wrappedCall, payload)
        "FieldLevelEncryptionConfigAlreadyExists" -> FieldLevelEncryptionConfigAlreadyExistsDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyFieldLevelEncryptionContentTypeProfiles" -> TooManyFieldLevelEncryptionContentTypeProfilesDeserializer().deserialize(context, wrappedCall, payload)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchFieldLevelEncryptionProfile" -> NoSuchFieldLevelEncryptionProfileDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyFieldLevelEncryptionConfigs" -> TooManyFieldLevelEncryptionConfigsDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyFieldLevelEncryptionQueryArgProfiles" -> TooManyFieldLevelEncryptionQueryArgProfilesDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
