// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.CreateDistributionWithTagsResponse
import aws.sdk.kotlin.services.cloudfront.model.Distribution
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateDistributionWithTagsOperationDeserializer: HttpDeserializer.NonStreaming<CreateDistributionWithTagsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDistributionWithTagsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDistributionWithTagsError(context, call, payload)
        }
        val builder = CreateDistributionWithTagsResponse.Builder()

        builder.eTag = response.headers["ETag"]
        builder.location = response.headers["Location"]

        if (payload != null) {
            builder.distribution = deserializeDistributionPayload(payload)
        }

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDistributionWithTagsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyDistributionsAssociatedToOriginRequestPolicy" -> TooManyDistributionsAssociatedToOriginRequestPolicyDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchContinuousDeploymentPolicy" -> NoSuchContinuousDeploymentPolicyDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRelativePath" -> InvalidRelativePathDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyQueryStringParameters" -> TooManyQueryStringParametersDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidOriginAccessControl" -> InvalidOriginAccessControlDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyLambdaFunctionAssociations" -> TooManyLambdaFunctionAssociationsDeserializer().deserialize(context, wrappedCall, payload)
        "ContinuousDeploymentPolicyInUse" -> ContinuousDeploymentPolicyInUseDeserializer().deserialize(context, wrappedCall, payload)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagging" -> InvalidTaggingDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidWebACLId" -> InvalidWebAclIdDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTTLOrder" -> InvalidTtlOrderDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyDistributions" -> TooManyDistributionsDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyDistributionsWithFunctionAssociations" -> TooManyDistributionsWithFunctionAssociationsDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyHeadersInForwardedValues" -> TooManyHeadersInForwardedValuesDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig" -> TooManyDistributionsAssociatedToFieldLevelEncryptionConfigDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidOriginAccessIdentity" -> InvalidOriginAccessIdentityDeserializer().deserialize(context, wrappedCall, payload)
        "DistributionAlreadyExists" -> DistributionAlreadyExistsDeserializer().deserialize(context, wrappedCall, payload)
        "RealtimeLogConfigOwnerMismatch" -> RealtimeLogConfigOwnerMismatchDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyCacheBehaviors" -> TooManyCacheBehaviorsDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchOrigin" -> NoSuchOriginDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyDistributionsAssociatedToCachePolicy" -> TooManyDistributionsAssociatedToCachePolicyDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidViewerCertificate" -> InvalidViewerCertificateDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidFunctionAssociation" -> InvalidFunctionAssociationDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchResponseHeadersPolicy" -> NoSuchResponseHeadersPolicyDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDefaultRootObject" -> InvalidDefaultRootObjectDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchCachePolicy" -> NoSuchCachePolicyDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidProtocolSettings" -> InvalidProtocolSettingsDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidMinimumProtocolVersion" -> InvalidMinimumProtocolVersionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidLambdaFunctionAssociation" -> InvalidLambdaFunctionAssociationDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidResponseCode" -> InvalidResponseCodeDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchOriginRequestPolicy" -> NoSuchOriginRequestPolicyDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchFieldLevelEncryptionConfig" -> NoSuchFieldLevelEncryptionConfigDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidHeadersForS3Origin" -> InvalidHeadersForS3OriginDeserializer().deserialize(context, wrappedCall, payload)
        "TrustedSignerDoesNotExist" -> TrustedSignerDoesNotExistDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyCookieNamesInWhiteList" -> TooManyCookieNamesInWhiteListDeserializer().deserialize(context, wrappedCall, payload)
        "IllegalOriginAccessConfiguration" -> IllegalOriginAccessConfigurationDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyDistributionsAssociatedToKeyGroup" -> TooManyDistributionsAssociatedToKeyGroupDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyDistributionsAssociatedToOriginAccessControl" -> TooManyDistributionsAssociatedToOriginAccessControlDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyOrigins" -> TooManyOriginsDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyTrustedSigners" -> TooManyTrustedSignersDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDomainNameForOriginAccessControl" -> InvalidDomainNameForOriginAccessControlDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyDistributionsWithSingleFunctionARN" -> TooManyDistributionsWithSingleFunctionArnDeserializer().deserialize(context, wrappedCall, payload)
        "MissingBody" -> MissingBodyDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidGeoRestrictionParameter" -> InvalidGeoRestrictionParameterDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchRealtimeLogConfig" -> NoSuchRealtimeLogConfigDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidOriginReadTimeout" -> InvalidOriginReadTimeoutDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyCertificates" -> TooManyCertificatesDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidLocationCode" -> InvalidLocationCodeDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidQueryStringParameters" -> InvalidQueryStringParametersDeserializer().deserialize(context, wrappedCall, payload)
        "CNAMEAlreadyExists" -> CnameAlreadyExistsDeserializer().deserialize(context, wrappedCall, payload)
        "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior" -> IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyDistributionCNAMEs" -> TooManyDistributionCnamesDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidErrorCode" -> InvalidErrorCodeDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyKeyGroupsAssociatedToDistribution" -> TooManyKeyGroupsAssociatedToDistributionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyDistributionsWithLambdaAssociations" -> TooManyDistributionsWithLambdaAssociationsDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyOriginCustomHeaders" -> TooManyOriginCustomHeadersDeserializer().deserialize(context, wrappedCall, payload)
        "TrustedKeyGroupDoesNotExist" -> TrustedKeyGroupDoesNotExistDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidOriginKeepaliveTimeout" -> InvalidOriginKeepaliveTimeoutDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidForwardCookies" -> InvalidForwardCookiesDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidOrigin" -> InvalidOriginDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyDistributionsAssociatedToResponseHeadersPolicy" -> TooManyDistributionsAssociatedToResponseHeadersPolicyDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyOriginGroupsPerDistribution" -> TooManyOriginGroupsPerDistributionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequiredProtocol" -> InvalidRequiredProtocolDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyFunctionAssociations" -> TooManyFunctionAssociationsDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
