// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeCachePolicyConfigDocument(reader: XmlTagReader): CachePolicyConfig {
    val builder = CachePolicyConfig.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Comment com.amazonaws.cloudfront#CachePolicyConfig$Comment
            "Comment" -> builder.comment = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // Name com.amazonaws.cloudfront#CachePolicyConfig$Name
            "Name" -> builder.name = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // DefaultTTL com.amazonaws.cloudfront#CachePolicyConfig$DefaultTTL
            "DefaultTTL" -> builder.defaultTtl = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.cloudfront#long`)" }
            // MaxTTL com.amazonaws.cloudfront#CachePolicyConfig$MaxTTL
            "MaxTTL" -> builder.maxTtl = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.cloudfront#long`)" }
            // MinTTL com.amazonaws.cloudfront#CachePolicyConfig$MinTTL
            "MinTTL" -> builder.minTtl = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.cloudfront#long`)" }
            // ParametersInCacheKeyAndForwardedToOrigin com.amazonaws.cloudfront#CachePolicyConfig$ParametersInCacheKeyAndForwardedToOrigin
            "ParametersInCacheKeyAndForwardedToOrigin" -> builder.parametersInCacheKeyAndForwardedToOrigin = deserializeParametersInCacheKeyAndForwardedToOriginDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
