// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.paginators

import aws.sdk.kotlin.services.cloudfront.CloudFrontClient
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary
import aws.sdk.kotlin.services.cloudfront.model.DistributionSummary
import aws.sdk.kotlin.services.cloudfront.model.InvalidationSummary
import aws.sdk.kotlin.services.cloudfront.model.KeyValueStore
import aws.sdk.kotlin.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest
import aws.sdk.kotlin.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsRequest
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsResponse
import aws.sdk.kotlin.services.cloudfront.model.ListInvalidationsRequest
import aws.sdk.kotlin.services.cloudfront.model.ListInvalidationsResponse
import aws.sdk.kotlin.services.cloudfront.model.ListKeyValueStoresRequest
import aws.sdk.kotlin.services.cloudfront.model.ListKeyValueStoresResponse
import aws.sdk.kotlin.services.cloudfront.model.ListStreamingDistributionsRequest
import aws.sdk.kotlin.services.cloudfront.model.ListStreamingDistributionsResponse
import aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCloudFrontOriginAccessIdentitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCloudFrontOriginAccessIdentitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCloudFrontOriginAccessIdentitiesResponse]
 */
public fun CloudFrontClient.listCloudFrontOriginAccessIdentitiesPaginated(initialRequest: ListCloudFrontOriginAccessIdentitiesRequest = ListCloudFrontOriginAccessIdentitiesRequest { }): Flow<ListCloudFrontOriginAccessIdentitiesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listCloudFrontOriginAccessIdentitiesPaginated.listCloudFrontOriginAccessIdentities(req)
            cursor = result.cloudFrontOriginAccessIdentityList?.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCloudFrontOriginAccessIdentitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCloudFrontOriginAccessIdentitiesResponse]
 */
public fun CloudFrontClient.listCloudFrontOriginAccessIdentitiesPaginated(block: ListCloudFrontOriginAccessIdentitiesRequest.Builder.() -> Unit): Flow<ListCloudFrontOriginAccessIdentitiesResponse> =
    listCloudFrontOriginAccessIdentitiesPaginated(ListCloudFrontOriginAccessIdentitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCloudFrontOriginAccessIdentitiesPaginated]
 * to access the nested member [CloudFrontOriginAccessIdentitySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CloudFrontOriginAccessIdentitySummary]
 */
@JvmName("listCloudFrontOriginAccessIdentitiesResponseCloudFrontOriginAccessIdentitySummary")
public fun Flow<ListCloudFrontOriginAccessIdentitiesResponse>.items(): Flow<CloudFrontOriginAccessIdentitySummary> =
    transform() { response ->
        response.cloudFrontOriginAccessIdentityList?.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDistributionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDistributionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDistributionsResponse]
 */
public fun CloudFrontClient.listDistributionsPaginated(initialRequest: ListDistributionsRequest = ListDistributionsRequest { }): Flow<ListDistributionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listDistributionsPaginated.listDistributions(req)
            cursor = result.distributionList?.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDistributionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDistributionsResponse]
 */
public fun CloudFrontClient.listDistributionsPaginated(block: ListDistributionsRequest.Builder.() -> Unit): Flow<ListDistributionsResponse> =
    listDistributionsPaginated(ListDistributionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDistributionsPaginated]
 * to access the nested member [DistributionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DistributionSummary]
 */
@JvmName("listDistributionsResponseDistributionSummary")
public fun Flow<ListDistributionsResponse>.items(): Flow<DistributionSummary> =
    transform() { response ->
        response.distributionList?.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInvalidationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInvalidationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvalidationsResponse]
 */
public fun CloudFrontClient.listInvalidationsPaginated(initialRequest: ListInvalidationsRequest): Flow<ListInvalidationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listInvalidationsPaginated.listInvalidations(req)
            cursor = result.invalidationList?.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListInvalidationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvalidationsResponse]
 */
public fun CloudFrontClient.listInvalidationsPaginated(block: ListInvalidationsRequest.Builder.() -> Unit): Flow<ListInvalidationsResponse> =
    listInvalidationsPaginated(ListInvalidationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInvalidationsPaginated]
 * to access the nested member [InvalidationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InvalidationSummary]
 */
@JvmName("listInvalidationsResponseInvalidationSummary")
public fun Flow<ListInvalidationsResponse>.items(): Flow<InvalidationSummary> =
    transform() { response ->
        response.invalidationList?.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListKeyValueStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKeyValueStoresRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeyValueStoresResponse]
 */
public fun CloudFrontClient.listKeyValueStoresPaginated(initialRequest: ListKeyValueStoresRequest = ListKeyValueStoresRequest { }): Flow<ListKeyValueStoresResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listKeyValueStoresPaginated.listKeyValueStores(req)
            cursor = result.keyValueStoreList?.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKeyValueStoresResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeyValueStoresResponse]
 */
public fun CloudFrontClient.listKeyValueStoresPaginated(block: ListKeyValueStoresRequest.Builder.() -> Unit): Flow<ListKeyValueStoresResponse> =
    listKeyValueStoresPaginated(ListKeyValueStoresRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listKeyValueStoresPaginated]
 * to access the nested member [KeyValueStore]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [KeyValueStore]
 */
@JvmName("listKeyValueStoresResponseKeyValueStore")
public fun Flow<ListKeyValueStoresResponse>.items(): Flow<KeyValueStore> =
    transform() { response ->
        response.keyValueStoreList?.items?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStreamingDistributionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStreamingDistributionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamingDistributionsResponse]
 */
public fun CloudFrontClient.listStreamingDistributionsPaginated(initialRequest: ListStreamingDistributionsRequest = ListStreamingDistributionsRequest { }): Flow<ListStreamingDistributionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.marker
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listStreamingDistributionsPaginated.listStreamingDistributions(req)
            cursor = result.streamingDistributionList?.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStreamingDistributionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamingDistributionsResponse]
 */
public fun CloudFrontClient.listStreamingDistributionsPaginated(block: ListStreamingDistributionsRequest.Builder.() -> Unit): Flow<ListStreamingDistributionsResponse> =
    listStreamingDistributionsPaginated(ListStreamingDistributionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStreamingDistributionsPaginated]
 * to access the nested member [StreamingDistributionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StreamingDistributionSummary]
 */
@JvmName("listStreamingDistributionsResponseStreamingDistributionSummary")
public fun Flow<ListStreamingDistributionsResponse>.items(): Flow<StreamingDistributionSummary> =
    transform() { response ->
        response.streamingDistributionList?.items?.forEach {
            emit(it)
        }
    }
