// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex type that controls whether access logs are written for this streaming distribution.
 */
public class StreamingLoggingConfig private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to enable logging when you create a streaming distribution or if you want to disable logging for an existing streaming distribution, specify `false` for `Enabled`, and specify `empty Bucket` and `Prefix` elements. If you specify `false` for `Enabled` but you specify values for `Bucket` and `Prefix`, the values are automatically deleted.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example, `myprefix/`. If you want to enable logging, but you don't want to specify a prefix, you still must include an empty `Prefix` element in the `Logging` element.
     */
    public val prefix: kotlin.String = requireNotNull(builder.prefix) { "A non-null value must be provided for prefix" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.StreamingLoggingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamingLoggingConfig(")
        append("bucket=$bucket,")
        append("enabled=$enabled,")
        append("prefix=$prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (prefix.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamingLoggingConfig

        if (bucket != other.bucket) return false
        if (enabled != other.enabled) return false
        if (prefix != other.prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.StreamingLoggingConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 bucket to store the access logs in, for example, `myawslogbucket.s3.amazonaws.com`.
         */
        public var bucket: kotlin.String? = null
        /**
         * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to enable logging when you create a streaming distribution or if you want to disable logging for an existing streaming distribution, specify `false` for `Enabled`, and specify `empty Bucket` and `Prefix` elements. If you specify `false` for `Enabled` but you specify values for `Bucket` and `Prefix`, the values are automatically deleted.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * An optional string that you want CloudFront to prefix to the access log filenames for this streaming distribution, for example, `myprefix/`. If you want to enable logging, but you don't want to specify a prefix, you still must include an empty `Prefix` element in the `Logging` element.
         */
        public var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.StreamingLoggingConfig) : this() {
            this.bucket = x.bucket
            this.enabled = x.enabled
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.StreamingLoggingConfig = StreamingLoggingConfig(this)

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            if (enabled == null) enabled = false
            if (prefix == null) prefix = ""
            return this
        }
    }
}
