// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex type that contains information about the Amazon S3 origin. If the origin is a custom origin or an S3 bucket that is configured as a website endpoint, use the `CustomOriginConfig` element instead.
 */
public class S3OriginConfig private constructor(builder: Builder) {
    /**
     * If you're using origin access control (OAC) instead of origin access identity, specify an empty `OriginAccessIdentity` element. For more information, see [Restricting access to an Amazon Web Services](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
     *
     * The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can *only* access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
     *
     * `origin-access-identity/cloudfront/ID-of-origin-access-identity`
     *
     * The ` <i>ID-of-origin-access-identity</i> ` is the value that CloudFront returned in the `ID` element when you created the origin access identity.
     *
     * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty `OriginAccessIdentity` element.
     *
     * To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty `OriginAccessIdentity` element.
     *
     * To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
     *
     * For more information about the origin access identity, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val originAccessIdentity: kotlin.String = requireNotNull(builder.originAccessIdentity) { "A non-null value must be provided for originAccessIdentity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3OriginConfig(")
        append("originAccessIdentity=$originAccessIdentity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = originAccessIdentity.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3OriginConfig

        if (originAccessIdentity != other.originAccessIdentity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If you're using origin access control (OAC) instead of origin access identity, specify an empty `OriginAccessIdentity` element. For more information, see [Restricting access to an Amazon Web Services](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
         *
         * The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can *only* access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
         *
         * `origin-access-identity/cloudfront/ID-of-origin-access-identity`
         *
         * The ` <i>ID-of-origin-access-identity</i> ` is the value that CloudFront returned in the `ID` element when you created the origin access identity.
         *
         * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty `OriginAccessIdentity` element.
         *
         * To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty `OriginAccessIdentity` element.
         *
         * To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
         *
         * For more information about the origin access identity, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var originAccessIdentity: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig) : this() {
            this.originAccessIdentity = x.originAccessIdentity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig = S3OriginConfig(this)

        internal fun correctErrors(): Builder {
            if (originAccessIdentity == null) originAccessIdentity = ""
            return this
        }
    }
}
