// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Determines whether CloudFront includes the `Strict-Transport-Security` HTTP response header and the header's value.
 *
 * For more information about the `Strict-Transport-Security` HTTP response header, see [Strict-Transport-Security](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
 */
public class ResponseHeadersPolicyStrictTransportSecurity private constructor(builder: Builder) {
    /**
     * A number that CloudFront uses as the value for the `max-age` directive in the `Strict-Transport-Security` HTTP response header.
     */
    public val accessControlMaxAgeSec: kotlin.Int = requireNotNull(builder.accessControlMaxAgeSec) { "A non-null value must be provided for accessControlMaxAgeSec" }
    /**
     * A Boolean that determines whether CloudFront includes the `includeSubDomains` directive in the `Strict-Transport-Security` HTTP response header.
     */
    public val includeSubdomains: kotlin.Boolean? = builder.includeSubdomains
    /**
     * A Boolean that determines whether CloudFront overrides the `Strict-Transport-Security` HTTP response header received from the origin with the one specified in this response headers policy.
     */
    public val override: kotlin.Boolean = requireNotNull(builder.override) { "A non-null value must be provided for override" }
    /**
     * A Boolean that determines whether CloudFront includes the `preload` directive in the `Strict-Transport-Security` HTTP response header.
     */
    public val preload: kotlin.Boolean? = builder.preload

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseHeadersPolicyStrictTransportSecurity(")
        append("accessControlMaxAgeSec=$accessControlMaxAgeSec,")
        append("includeSubdomains=$includeSubdomains,")
        append("override=$override,")
        append("preload=$preload")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlMaxAgeSec
        result = 31 * result + (includeSubdomains?.hashCode() ?: 0)
        result = 31 * result + (override.hashCode())
        result = 31 * result + (preload?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseHeadersPolicyStrictTransportSecurity

        if (accessControlMaxAgeSec != other.accessControlMaxAgeSec) return false
        if (includeSubdomains != other.includeSubdomains) return false
        if (override != other.override) return false
        if (preload != other.preload) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A number that CloudFront uses as the value for the `max-age` directive in the `Strict-Transport-Security` HTTP response header.
         */
        public var accessControlMaxAgeSec: kotlin.Int? = null
        /**
         * A Boolean that determines whether CloudFront includes the `includeSubDomains` directive in the `Strict-Transport-Security` HTTP response header.
         */
        public var includeSubdomains: kotlin.Boolean? = null
        /**
         * A Boolean that determines whether CloudFront overrides the `Strict-Transport-Security` HTTP response header received from the origin with the one specified in this response headers policy.
         */
        public var override: kotlin.Boolean? = null
        /**
         * A Boolean that determines whether CloudFront includes the `preload` directive in the `Strict-Transport-Security` HTTP response header.
         */
        public var preload: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity) : this() {
            this.accessControlMaxAgeSec = x.accessControlMaxAgeSec
            this.includeSubdomains = x.includeSubdomains
            this.override = x.override
            this.preload = x.preload
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity = ResponseHeadersPolicyStrictTransportSecurity(this)

        internal fun correctErrors(): Builder {
            if (accessControlMaxAgeSec == null) accessControlMaxAgeSec = 0
            if (override == null) override = false
            return this
        }
    }
}
