// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A configuration for a set of security-related HTTP response headers. CloudFront adds these headers to HTTP responses that it sends for requests that match a cache behavior associated with this response headers policy.
 */
public class ResponseHeadersPolicySecurityHeadersConfig private constructor(builder: Builder) {
    /**
     * The policy directives and their values that CloudFront includes as values for the `Content-Security-Policy` HTTP response header.
     *
     * For more information about the `Content-Security-Policy` HTTP response header, see [Content-Security-Policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
     */
    public val contentSecurityPolicy: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy? = builder.contentSecurityPolicy
    /**
     * Determines whether CloudFront includes the `X-Content-Type-Options` HTTP response header with its value set to `nosniff`.
     *
     * For more information about the `X-Content-Type-Options` HTTP response header, see [X-Content-Type-Options](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options) in the MDN Web Docs.
     */
    public val contentTypeOptions: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyContentTypeOptions? = builder.contentTypeOptions
    /**
     * Determines whether CloudFront includes the `X-Frame-Options` HTTP response header and the header's value.
     *
     * For more information about the `X-Frame-Options` HTTP response header, see [X-Frame-Options](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
     */
    public val frameOptions: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyFrameOptions? = builder.frameOptions
    /**
     * Determines whether CloudFront includes the `Referrer-Policy` HTTP response header and the header's value.
     *
     * For more information about the `Referrer-Policy` HTTP response header, see [Referrer-Policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
     */
    public val referrerPolicy: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyReferrerPolicy? = builder.referrerPolicy
    /**
     * Determines whether CloudFront includes the `Strict-Transport-Security` HTTP response header and the header's value.
     *
     * For more information about the `Strict-Transport-Security` HTTP response header, see [Security headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#understanding-response-headers-policies-security) in the *Amazon CloudFront Developer Guide* and [Strict-Transport-Security](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
     */
    public val strictTransportSecurity: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity? = builder.strictTransportSecurity
    /**
     * Determines whether CloudFront includes the `X-XSS-Protection` HTTP response header and the header's value.
     *
     * For more information about the `X-XSS-Protection` HTTP response header, see [X-XSS-Protection](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
     */
    public val xssProtection: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyXssProtection? = builder.xssProtection

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseHeadersPolicySecurityHeadersConfig(")
        append("contentSecurityPolicy=$contentSecurityPolicy,")
        append("contentTypeOptions=$contentTypeOptions,")
        append("frameOptions=$frameOptions,")
        append("referrerPolicy=$referrerPolicy,")
        append("strictTransportSecurity=$strictTransportSecurity,")
        append("xssProtection=$xssProtection")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentSecurityPolicy?.hashCode() ?: 0
        result = 31 * result + (contentTypeOptions?.hashCode() ?: 0)
        result = 31 * result + (frameOptions?.hashCode() ?: 0)
        result = 31 * result + (referrerPolicy?.hashCode() ?: 0)
        result = 31 * result + (strictTransportSecurity?.hashCode() ?: 0)
        result = 31 * result + (xssProtection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseHeadersPolicySecurityHeadersConfig

        if (contentSecurityPolicy != other.contentSecurityPolicy) return false
        if (contentTypeOptions != other.contentTypeOptions) return false
        if (frameOptions != other.frameOptions) return false
        if (referrerPolicy != other.referrerPolicy) return false
        if (strictTransportSecurity != other.strictTransportSecurity) return false
        if (xssProtection != other.xssProtection) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The policy directives and their values that CloudFront includes as values for the `Content-Security-Policy` HTTP response header.
         *
         * For more information about the `Content-Security-Policy` HTTP response header, see [Content-Security-Policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy) in the MDN Web Docs.
         */
        public var contentSecurityPolicy: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy? = null
        /**
         * Determines whether CloudFront includes the `X-Content-Type-Options` HTTP response header with its value set to `nosniff`.
         *
         * For more information about the `X-Content-Type-Options` HTTP response header, see [X-Content-Type-Options](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Content-Type-Options) in the MDN Web Docs.
         */
        public var contentTypeOptions: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyContentTypeOptions? = null
        /**
         * Determines whether CloudFront includes the `X-Frame-Options` HTTP response header and the header's value.
         *
         * For more information about the `X-Frame-Options` HTTP response header, see [X-Frame-Options](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Frame-Options) in the MDN Web Docs.
         */
        public var frameOptions: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyFrameOptions? = null
        /**
         * Determines whether CloudFront includes the `Referrer-Policy` HTTP response header and the header's value.
         *
         * For more information about the `Referrer-Policy` HTTP response header, see [Referrer-Policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referrer-Policy) in the MDN Web Docs.
         */
        public var referrerPolicy: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyReferrerPolicy? = null
        /**
         * Determines whether CloudFront includes the `Strict-Transport-Security` HTTP response header and the header's value.
         *
         * For more information about the `Strict-Transport-Security` HTTP response header, see [Security headers](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#understanding-response-headers-policies-security) in the *Amazon CloudFront Developer Guide* and [Strict-Transport-Security](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Strict-Transport-Security) in the MDN Web Docs.
         */
        public var strictTransportSecurity: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity? = null
        /**
         * Determines whether CloudFront includes the `X-XSS-Protection` HTTP response header and the header's value.
         *
         * For more information about the `X-XSS-Protection` HTTP response header, see [X-XSS-Protection](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-XSS-Protection) in the MDN Web Docs.
         */
        public var xssProtection: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyXssProtection? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig) : this() {
            this.contentSecurityPolicy = x.contentSecurityPolicy
            this.contentTypeOptions = x.contentTypeOptions
            this.frameOptions = x.frameOptions
            this.referrerPolicy = x.referrerPolicy
            this.strictTransportSecurity = x.strictTransportSecurity
            this.xssProtection = x.xssProtection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicySecurityHeadersConfig = ResponseHeadersPolicySecurityHeadersConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy] inside the given [block]
         */
        public fun contentSecurityPolicy(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy.Builder.() -> kotlin.Unit) {
            this.contentSecurityPolicy = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyContentTypeOptions] inside the given [block]
         */
        public fun contentTypeOptions(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyContentTypeOptions.Builder.() -> kotlin.Unit) {
            this.contentTypeOptions = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyContentTypeOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyFrameOptions] inside the given [block]
         */
        public fun frameOptions(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyFrameOptions.Builder.() -> kotlin.Unit) {
            this.frameOptions = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyFrameOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyReferrerPolicy] inside the given [block]
         */
        public fun referrerPolicy(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyReferrerPolicy.Builder.() -> kotlin.Unit) {
            this.referrerPolicy = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyReferrerPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity] inside the given [block]
         */
        public fun strictTransportSecurity(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity.Builder.() -> kotlin.Unit) {
            this.strictTransportSecurity = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyXssProtection] inside the given [block]
         */
        public fun xssProtection(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyXssProtection.Builder.() -> kotlin.Unit) {
            this.xssProtection = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyXssProtection.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
