// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
 */
public class PublicKey private constructor(builder: Builder) {
    /**
     * The date and time when the public key was uploaded.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The identifier of the public key.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Configuration information about a public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
     */
    public val publicKeyConfig: aws.sdk.kotlin.services.cloudfront.model.PublicKeyConfig? = builder.publicKeyConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.PublicKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PublicKey(")
        append("createdTime=$createdTime,")
        append("id=$id,")
        append("publicKeyConfig=$publicKeyConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime.hashCode()
        result = 31 * result + (id.hashCode())
        result = 31 * result + (publicKeyConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PublicKey

        if (createdTime != other.createdTime) return false
        if (id != other.id) return false
        if (publicKeyConfig != other.publicKeyConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.PublicKey = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time when the public key was uploaded.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the public key.
         */
        public var id: kotlin.String? = null
        /**
         * Configuration information about a public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
         */
        public var publicKeyConfig: aws.sdk.kotlin.services.cloudfront.model.PublicKeyConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.PublicKey) : this() {
            this.createdTime = x.createdTime
            this.id = x.id
            this.publicKeyConfig = x.publicKeyConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.PublicKey = PublicKey(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.PublicKeyConfig] inside the given [block]
         */
        public fun publicKeyConfig(block: aws.sdk.kotlin.services.cloudfront.model.PublicKeyConfig.Builder.() -> kotlin.Unit) {
            this.publicKeyConfig = aws.sdk.kotlin.services.cloudfront.model.PublicKeyConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            return this
        }
    }
}
