// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in requests that CloudFront sends to the origin.
 */
public class OriginRequestPolicyCookiesConfig private constructor(builder: Builder) {
    /**
     * Determines whether cookies in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
     * + `none` – No cookies in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to `none`, any cookies that are listed in a `CachePolicy`*are* included in origin requests.
     * + `whitelist` – Only the cookies in viewer requests that are listed in the `CookieNames` type are included in requests that CloudFront sends to the origin.
     * + `all` – All cookies in viewer requests are included in requests that CloudFront sends to the origin.
     * + `allExcept` – All cookies in viewer requests are included in requests that CloudFront sends to the origin, ***except*** for those listed in the `CookieNames` type, which are not included.
     */
    public val cookieBehavior: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookieBehavior = requireNotNull(builder.cookieBehavior) { "A non-null value must be provided for cookieBehavior" }
    /**
     * Contains a list of cookie names.
     */
    public val cookies: aws.sdk.kotlin.services.cloudfront.model.CookieNames? = builder.cookies

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookiesConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OriginRequestPolicyCookiesConfig(")
        append("cookieBehavior=$cookieBehavior,")
        append("cookies=$cookies")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cookieBehavior.hashCode()
        result = 31 * result + (cookies?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OriginRequestPolicyCookiesConfig

        if (cookieBehavior != other.cookieBehavior) return false
        if (cookies != other.cookies) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookiesConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Determines whether cookies in viewer requests are included in requests that CloudFront sends to the origin. Valid values are:
         * + `none` – No cookies in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to `none`, any cookies that are listed in a `CachePolicy`*are* included in origin requests.
         * + `whitelist` – Only the cookies in viewer requests that are listed in the `CookieNames` type are included in requests that CloudFront sends to the origin.
         * + `all` – All cookies in viewer requests are included in requests that CloudFront sends to the origin.
         * + `allExcept` – All cookies in viewer requests are included in requests that CloudFront sends to the origin, ***except*** for those listed in the `CookieNames` type, which are not included.
         */
        public var cookieBehavior: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookieBehavior? = null
        /**
         * Contains a list of cookie names.
         */
        public var cookies: aws.sdk.kotlin.services.cloudfront.model.CookieNames? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookiesConfig) : this() {
            this.cookieBehavior = x.cookieBehavior
            this.cookies = x.cookies
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyCookiesConfig = OriginRequestPolicyCookiesConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CookieNames] inside the given [block]
         */
        public fun cookies(block: aws.sdk.kotlin.services.cloudfront.model.CookieNames.Builder.() -> kotlin.Unit) {
            this.cookies = aws.sdk.kotlin.services.cloudfront.model.CookieNames.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (cookieBehavior == null) cookieBehavior = OriginRequestPolicyCookieBehavior.SdkUnknown("no value provided")
            return this
        }
    }
}
