// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A CloudFront origin access control.
 */
public class OriginAccessControlSummary private constructor(builder: Builder) {
    /**
     * A description of the origin access control.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The unique identifier of the origin access control.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * A unique name that identifies the origin access control.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The type of origin that this origin access control is for.
     */
    public val originAccessControlOriginType: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlOriginTypes = requireNotNull(builder.originAccessControlOriginType) { "A non-null value must be provided for originAccessControlOriginType" }
    /**
     * A value that specifies which requests CloudFront signs (adds authentication information to). This field can have one of the following values:
     * + `never` – CloudFront doesn't sign any origin requests.
     * + `always` – CloudFront signs all origin requests, overwriting the `Authorization` header from the viewer request if necessary.
     * + `no-override` – If the viewer request doesn't contain the `Authorization` header, CloudFront signs the origin request. If the viewer request contains the `Authorization` header, CloudFront doesn't sign the origin request, but instead passes along the `Authorization` header that it received in the viewer request.
     */
    public val signingBehavior: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSigningBehaviors = requireNotNull(builder.signingBehavior) { "A non-null value must be provided for signingBehavior" }
    /**
     * The signing protocol of the origin access control. The signing protocol determines how CloudFront signs (authenticates) requests. The only valid value is `sigv4`.
     */
    public val signingProtocol: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSigningProtocols = requireNotNull(builder.signingProtocol) { "A non-null value must be provided for signingProtocol" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OriginAccessControlSummary(")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("originAccessControlOriginType=$originAccessControlOriginType,")
        append("signingBehavior=$signingBehavior,")
        append("signingProtocol=$signingProtocol")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description.hashCode()
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (originAccessControlOriginType.hashCode())
        result = 31 * result + (signingBehavior.hashCode())
        result = 31 * result + (signingProtocol.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OriginAccessControlSummary

        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (originAccessControlOriginType != other.originAccessControlOriginType) return false
        if (signingBehavior != other.signingBehavior) return false
        if (signingProtocol != other.signingProtocol) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A description of the origin access control.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier of the origin access control.
         */
        public var id: kotlin.String? = null
        /**
         * A unique name that identifies the origin access control.
         */
        public var name: kotlin.String? = null
        /**
         * The type of origin that this origin access control is for.
         */
        public var originAccessControlOriginType: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlOriginTypes? = null
        /**
         * A value that specifies which requests CloudFront signs (adds authentication information to). This field can have one of the following values:
         * + `never` – CloudFront doesn't sign any origin requests.
         * + `always` – CloudFront signs all origin requests, overwriting the `Authorization` header from the viewer request if necessary.
         * + `no-override` – If the viewer request doesn't contain the `Authorization` header, CloudFront signs the origin request. If the viewer request contains the `Authorization` header, CloudFront doesn't sign the origin request, but instead passes along the `Authorization` header that it received in the viewer request.
         */
        public var signingBehavior: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSigningBehaviors? = null
        /**
         * The signing protocol of the origin access control. The signing protocol determines how CloudFront signs (authenticates) requests. The only valid value is `sigv4`.
         */
        public var signingProtocol: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSigningProtocols? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSummary) : this() {
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.originAccessControlOriginType = x.originAccessControlOriginType
            this.signingBehavior = x.signingBehavior
            this.signingProtocol = x.signingProtocol
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSummary = OriginAccessControlSummary(this)

        internal fun correctErrors(): Builder {
            if (description == null) description = ""
            if (id == null) id = ""
            if (name == null) name = ""
            if (originAccessControlOriginType == null) originAccessControlOriginType = OriginAccessControlOriginTypes.SdkUnknown("no value provided")
            if (signingBehavior == null) signingBehavior = OriginAccessControlSigningBehaviors.SdkUnknown("no value provided")
            if (signingProtocol == null) signingProtocol = OriginAccessControlSigningProtocols.SdkUnknown("no value provided")
            return this
        }
    }
}
