// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A CloudFront origin access control configuration.
 */
public class OriginAccessControlConfig private constructor(builder: Builder) {
    /**
     * A description of the origin access control.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A name to identify the origin access control. You can specify up to 64 characters.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The type of origin that this origin access control is for.
     */
    public val originAccessControlOriginType: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlOriginTypes = requireNotNull(builder.originAccessControlOriginType) { "A non-null value must be provided for originAccessControlOriginType" }
    /**
     * Specifies which requests CloudFront signs (adds authentication information to). Specify `always` for the most common use case. For more information, see [origin access control advanced settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings) in the *Amazon CloudFront Developer Guide*.
     *
     * This field can have one of the following values:
     * + `always` – CloudFront signs all origin requests, overwriting the `Authorization` header from the viewer request if one exists.
     * + `never` – CloudFront doesn't sign any origin requests. This value turns off origin access control for all origins in all distributions that use this origin access control.
     * + `no-override` – If the viewer request doesn't contain the `Authorization` header, then CloudFront signs the origin request. If the viewer request contains the `Authorization` header, then CloudFront doesn't sign the origin request and instead passes along the `Authorization` header from the viewer request. **WARNING: To pass along the `Authorization` header from the viewer request, you *must* add the `Authorization` header to a [cache policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html) for all cache behaviors that use origins associated with this origin access control.**
     */
    public val signingBehavior: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSigningBehaviors = requireNotNull(builder.signingBehavior) { "A non-null value must be provided for signingBehavior" }
    /**
     * The signing protocol of the origin access control, which determines how CloudFront signs (authenticates) requests. The only valid value is `sigv4`.
     */
    public val signingProtocol: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSigningProtocols = requireNotNull(builder.signingProtocol) { "A non-null value must be provided for signingProtocol" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OriginAccessControlConfig(")
        append("description=$description,")
        append("name=$name,")
        append("originAccessControlOriginType=$originAccessControlOriginType,")
        append("signingBehavior=$signingBehavior,")
        append("signingProtocol=$signingProtocol")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (name.hashCode())
        result = 31 * result + (originAccessControlOriginType.hashCode())
        result = 31 * result + (signingBehavior.hashCode())
        result = 31 * result + (signingProtocol.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OriginAccessControlConfig

        if (description != other.description) return false
        if (name != other.name) return false
        if (originAccessControlOriginType != other.originAccessControlOriginType) return false
        if (signingBehavior != other.signingBehavior) return false
        if (signingProtocol != other.signingProtocol) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A description of the origin access control.
         */
        public var description: kotlin.String? = null
        /**
         * A name to identify the origin access control. You can specify up to 64 characters.
         */
        public var name: kotlin.String? = null
        /**
         * The type of origin that this origin access control is for.
         */
        public var originAccessControlOriginType: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlOriginTypes? = null
        /**
         * Specifies which requests CloudFront signs (adds authentication information to). Specify `always` for the most common use case. For more information, see [origin access control advanced settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html#oac-advanced-settings) in the *Amazon CloudFront Developer Guide*.
         *
         * This field can have one of the following values:
         * + `always` – CloudFront signs all origin requests, overwriting the `Authorization` header from the viewer request if one exists.
         * + `never` – CloudFront doesn't sign any origin requests. This value turns off origin access control for all origins in all distributions that use this origin access control.
         * + `no-override` – If the viewer request doesn't contain the `Authorization` header, then CloudFront signs the origin request. If the viewer request contains the `Authorization` header, then CloudFront doesn't sign the origin request and instead passes along the `Authorization` header from the viewer request. **WARNING: To pass along the `Authorization` header from the viewer request, you *must* add the `Authorization` header to a [cache policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html) for all cache behaviors that use origins associated with this origin access control.**
         */
        public var signingBehavior: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSigningBehaviors? = null
        /**
         * The signing protocol of the origin access control, which determines how CloudFront signs (authenticates) requests. The only valid value is `sigv4`.
         */
        public var signingProtocol: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlSigningProtocols? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlConfig) : this() {
            this.description = x.description
            this.name = x.name
            this.originAccessControlOriginType = x.originAccessControlOriginType
            this.signingBehavior = x.signingBehavior
            this.signingProtocol = x.signingProtocol
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlConfig = OriginAccessControlConfig(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (originAccessControlOriginType == null) originAccessControlOriginType = OriginAccessControlOriginTypes.SdkUnknown("no value provided")
            if (signingBehavior == null) signingBehavior = OriginAccessControlSigningBehaviors.SdkUnknown("no value provided")
            if (signingProtocol == null) signingProtocol = OriginAccessControlSigningProtocols.SdkUnknown("no value provided")
            return this
        }
    }
}
