// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An origin.
 *
 * An origin is the location where content is stored, and from which CloudFront gets content to serve to viewers. To specify an origin:
 * + Use `S3OriginConfig` to specify an Amazon S3 bucket that is not configured with static website hosting.
 * + Use `CustomOriginConfig` to specify all other kinds of origins, including:
 *    + An Amazon S3 bucket that is configured with static website hosting
 *    + An Elastic Load Balancing load balancer
 *    + An Elemental MediaPackage endpoint
 *    + An Elemental MediaStore container
 *    + Any other HTTP server, running on an Amazon EC2 instance or any other kind of host
 *
 * For the current maximum number of origins that you can specify per distribution, see [General Quotas on Web Distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions) in the *Amazon CloudFront Developer Guide* (quotas were formerly referred to as limits).
 */
public class Origin private constructor(builder: Builder) {
    /**
     * The number of times that CloudFront attempts to connect to the origin. The minimum number is 1, the maximum is 3, and the default (if you don't specify otherwise) is 3.
     *
     * For a custom origin (including an Amazon S3 bucket that's configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).
     *
     * For more information, see [Origin Connection Attempts](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts) in the *Amazon CloudFront Developer Guide*.
     */
    public val connectionAttempts: kotlin.Int? = builder.connectionAttempts
    /**
     * The number of seconds that CloudFront waits when trying to establish a connection to the origin. The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don't specify otherwise) is 10 seconds.
     *
     * For more information, see [Origin Connection Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout) in the *Amazon CloudFront Developer Guide*.
     */
    public val connectionTimeout: kotlin.Int? = builder.connectionTimeout
    /**
     * A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
     *
     * For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val customHeaders: aws.sdk.kotlin.services.cloudfront.model.CustomHeaders? = builder.customHeaders
    /**
     * Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the `S3OriginConfig` type instead.
     */
    public val customOriginConfig: aws.sdk.kotlin.services.cloudfront.model.CustomOriginConfig? = builder.customOriginConfig
    /**
     * The domain name for the origin.
     *
     * For more information, see [Origin Domain Name](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName) in the *Amazon CloudFront Developer Guide*.
     */
    public val domainName: kotlin.String = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * A unique identifier for the origin. This value must be unique within the distribution.
     *
     * Use this value to specify the `TargetOriginId` in a `CacheBehavior` or `DefaultCacheBehavior`.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The unique identifier of an origin access control for this origin.
     *
     * For more information, see [Restricting access to an Amazon S3 origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val originAccessControlId: kotlin.String? = builder.originAccessControlId
    /**
     * An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
     *
     * For more information, see [Origin Path](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath) in the *Amazon CloudFront Developer Guide*.
     */
    public val originPath: kotlin.String? = builder.originPath
    /**
     * CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
     *
     * For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val originShield: aws.sdk.kotlin.services.cloudfront.model.OriginShield? = builder.originShield
    /**
     * Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting. To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the `CustomOriginConfig` type instead.
     */
    public val s3OriginConfig: aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig? = builder.s3OriginConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.Origin = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Origin(")
        append("connectionAttempts=$connectionAttempts,")
        append("connectionTimeout=$connectionTimeout,")
        append("customHeaders=$customHeaders,")
        append("customOriginConfig=$customOriginConfig,")
        append("domainName=$domainName,")
        append("id=$id,")
        append("originAccessControlId=$originAccessControlId,")
        append("originPath=$originPath,")
        append("originShield=$originShield,")
        append("s3OriginConfig=$s3OriginConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionAttempts ?: 0
        result = 31 * result + (connectionTimeout ?: 0)
        result = 31 * result + (customHeaders?.hashCode() ?: 0)
        result = 31 * result + (customOriginConfig?.hashCode() ?: 0)
        result = 31 * result + (domainName.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (originAccessControlId?.hashCode() ?: 0)
        result = 31 * result + (originPath?.hashCode() ?: 0)
        result = 31 * result + (originShield?.hashCode() ?: 0)
        result = 31 * result + (s3OriginConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Origin

        if (connectionAttempts != other.connectionAttempts) return false
        if (connectionTimeout != other.connectionTimeout) return false
        if (customHeaders != other.customHeaders) return false
        if (customOriginConfig != other.customOriginConfig) return false
        if (domainName != other.domainName) return false
        if (id != other.id) return false
        if (originAccessControlId != other.originAccessControlId) return false
        if (originPath != other.originPath) return false
        if (originShield != other.originShield) return false
        if (s3OriginConfig != other.s3OriginConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.Origin = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of times that CloudFront attempts to connect to the origin. The minimum number is 1, the maximum is 3, and the default (if you don't specify otherwise) is 3.
         *
         * For a custom origin (including an Amazon S3 bucket that's configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an [Origin Response Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).
         *
         * For more information, see [Origin Connection Attempts](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts) in the *Amazon CloudFront Developer Guide*.
         */
        public var connectionAttempts: kotlin.Int? = null
        /**
         * The number of seconds that CloudFront waits when trying to establish a connection to the origin. The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don't specify otherwise) is 10 seconds.
         *
         * For more information, see [Origin Connection Timeout](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout) in the *Amazon CloudFront Developer Guide*.
         */
        public var connectionTimeout: kotlin.Int? = null
        /**
         * A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
         *
         * For more information, see [Adding Custom Headers to Origin Requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var customHeaders: aws.sdk.kotlin.services.cloudfront.model.CustomHeaders? = null
        /**
         * Use this type to specify an origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the `S3OriginConfig` type instead.
         */
        public var customOriginConfig: aws.sdk.kotlin.services.cloudfront.model.CustomOriginConfig? = null
        /**
         * The domain name for the origin.
         *
         * For more information, see [Origin Domain Name](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName) in the *Amazon CloudFront Developer Guide*.
         */
        public var domainName: kotlin.String? = null
        /**
         * A unique identifier for the origin. This value must be unique within the distribution.
         *
         * Use this value to specify the `TargetOriginId` in a `CacheBehavior` or `DefaultCacheBehavior`.
         */
        public var id: kotlin.String? = null
        /**
         * The unique identifier of an origin access control for this origin.
         *
         * For more information, see [Restricting access to an Amazon S3 origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var originAccessControlId: kotlin.String? = null
        /**
         * An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         *
         * For more information, see [Origin Path](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath) in the *Amazon CloudFront Developer Guide*.
         */
        public var originPath: kotlin.String? = null
        /**
         * CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
         *
         * For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var originShield: aws.sdk.kotlin.services.cloudfront.model.OriginShield? = null
        /**
         * Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting. To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the `CustomOriginConfig` type instead.
         */
        public var s3OriginConfig: aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.Origin) : this() {
            this.connectionAttempts = x.connectionAttempts
            this.connectionTimeout = x.connectionTimeout
            this.customHeaders = x.customHeaders
            this.customOriginConfig = x.customOriginConfig
            this.domainName = x.domainName
            this.id = x.id
            this.originAccessControlId = x.originAccessControlId
            this.originPath = x.originPath
            this.originShield = x.originShield
            this.s3OriginConfig = x.s3OriginConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.Origin = Origin(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CustomHeaders] inside the given [block]
         */
        public fun customHeaders(block: aws.sdk.kotlin.services.cloudfront.model.CustomHeaders.Builder.() -> kotlin.Unit) {
            this.customHeaders = aws.sdk.kotlin.services.cloudfront.model.CustomHeaders.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CustomOriginConfig] inside the given [block]
         */
        public fun customOriginConfig(block: aws.sdk.kotlin.services.cloudfront.model.CustomOriginConfig.Builder.() -> kotlin.Unit) {
            this.customOriginConfig = aws.sdk.kotlin.services.cloudfront.model.CustomOriginConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginShield] inside the given [block]
         */
        public fun originShield(block: aws.sdk.kotlin.services.cloudfront.model.OriginShield.Builder.() -> kotlin.Unit) {
            this.originShield = aws.sdk.kotlin.services.cloudfront.model.OriginShield.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig] inside the given [block]
         */
        public fun s3OriginConfig(block: aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig.Builder.() -> kotlin.Unit) {
            this.s3OriginConfig = aws.sdk.kotlin.services.cloudfront.model.S3OriginConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (domainName == null) domainName = ""
            if (id == null) id = ""
            return this
        }
    }
}
