// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A key group configuration.
 *
 * A key group contains a list of public keys that you can use with [CloudFront signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
 */
public class KeyGroupConfig private constructor(builder: Builder) {
    /**
     * A comment to describe the key group. The comment cannot be longer than 128 characters.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * A list of the identifiers of the public keys in the key group.
     */
    public val items: List<String> = requireNotNull(builder.items) { "A non-null value must be provided for items" }
    /**
     * A name to identify the key group.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.KeyGroupConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KeyGroupConfig(")
        append("comment=$comment,")
        append("items=$items,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (items.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KeyGroupConfig

        if (comment != other.comment) return false
        if (items != other.items) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.KeyGroupConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A comment to describe the key group. The comment cannot be longer than 128 characters.
         */
        public var comment: kotlin.String? = null
        /**
         * A list of the identifiers of the public keys in the key group.
         */
        public var items: List<String>? = null
        /**
         * A name to identify the key group.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.KeyGroupConfig) : this() {
            this.comment = x.comment
            this.items = x.items
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.KeyGroupConfig = KeyGroupConfig(this)

        internal fun correctErrors(): Builder {
            if (items == null) items = emptyList()
            if (name == null) name = ""
            return this
        }
    }
}
