// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An invalidation batch.
 */
public class InvalidationBatch private constructor(builder: Builder) {
    /**
     * A value that you specify to uniquely identify an invalidation request. CloudFront uses the value to prevent you from accidentally resubmitting an identical request. Whenever you create a new invalidation request, you must specify a new value for `CallerReference` and change other values in the request as applicable. One way to ensure that the value of `CallerReference` is unique is to use a `timestamp`, for example, `20120301090000`.
     *
     * If you make a second invalidation request with the same value for `CallerReference`, and if the rest of the request is the same, CloudFront doesn't create a new invalidation request. Instead, CloudFront returns information about the invalidation request that you previously created with the same `CallerReference`.
     *
     * If `CallerReference` is a value you already sent in a previous invalidation batch request but the content of any `Path` is different from the original request, CloudFront returns an `InvalidationBatchAlreadyExists` error.
     */
    public val callerReference: kotlin.String = requireNotNull(builder.callerReference) { "A non-null value must be provided for callerReference" }
    /**
     * A complex type that contains information about the objects that you want to invalidate. For more information, see [Specifying the Objects to Invalidate](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects) in the *Amazon CloudFront Developer Guide*.
     */
    public val paths: aws.sdk.kotlin.services.cloudfront.model.Paths? = builder.paths

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.InvalidationBatch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvalidationBatch(")
        append("callerReference=$callerReference,")
        append("paths=$paths")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference.hashCode()
        result = 31 * result + (paths?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvalidationBatch

        if (callerReference != other.callerReference) return false
        if (paths != other.paths) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.InvalidationBatch = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A value that you specify to uniquely identify an invalidation request. CloudFront uses the value to prevent you from accidentally resubmitting an identical request. Whenever you create a new invalidation request, you must specify a new value for `CallerReference` and change other values in the request as applicable. One way to ensure that the value of `CallerReference` is unique is to use a `timestamp`, for example, `20120301090000`.
         *
         * If you make a second invalidation request with the same value for `CallerReference`, and if the rest of the request is the same, CloudFront doesn't create a new invalidation request. Instead, CloudFront returns information about the invalidation request that you previously created with the same `CallerReference`.
         *
         * If `CallerReference` is a value you already sent in a previous invalidation batch request but the content of any `Path` is different from the original request, CloudFront returns an `InvalidationBatchAlreadyExists` error.
         */
        public var callerReference: kotlin.String? = null
        /**
         * A complex type that contains information about the objects that you want to invalidate. For more information, see [Specifying the Objects to Invalidate](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html#invalidation-specifying-objects) in the *Amazon CloudFront Developer Guide*.
         */
        public var paths: aws.sdk.kotlin.services.cloudfront.model.Paths? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.InvalidationBatch) : this() {
            this.callerReference = x.callerReference
            this.paths = x.paths
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.InvalidationBatch = InvalidationBatch(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Paths] inside the given [block]
         */
        public fun paths(block: aws.sdk.kotlin.services.cloudfront.model.Paths.Builder.() -> kotlin.Unit) {
            this.paths = aws.sdk.kotlin.services.cloudfront.model.Paths.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (callerReference == null) callerReference = ""
            return this
        }
    }
}
