// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A distribution list.
 */
public class DistributionList private constructor(builder: Builder) {
    /**
     * A flag that indicates whether more distributions remain to be listed. If your results were truncated, you can make a follow-up pagination request using the `Marker` request parameter to retrieve more distributions in the list.
     */
    public val isTruncated: kotlin.Boolean = requireNotNull(builder.isTruncated) { "A non-null value must be provided for isTruncated" }
    /**
     * A complex type that contains one `DistributionSummary` element for each distribution that was created by the current Amazon Web Services account.
     */
    public val items: List<DistributionSummary>? = builder.items
    /**
     * The value you provided for the `Marker` request parameter.
     */
    public val marker: kotlin.String = requireNotNull(builder.marker) { "A non-null value must be provided for marker" }
    /**
     * The value you provided for the `MaxItems` request parameter.
     */
    public val maxItems: kotlin.Int = requireNotNull(builder.maxItems) { "A non-null value must be provided for maxItems" }
    /**
     * If `IsTruncated` is `true`, this element is present and contains the value you can use for the `Marker` request parameter to continue listing your distributions where they left off.
     */
    public val nextMarker: kotlin.String? = builder.nextMarker
    /**
     * The number of distributions that were created by the current Amazon Web Services account.
     */
    public val quantity: kotlin.Int = requireNotNull(builder.quantity) { "A non-null value must be provided for quantity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.DistributionList = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DistributionList(")
        append("isTruncated=$isTruncated,")
        append("items=$items,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated.hashCode()
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (marker.hashCode())
        result = 31 * result + (maxItems)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DistributionList

        if (isTruncated != other.isTruncated) return false
        if (items != other.items) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.DistributionList = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A flag that indicates whether more distributions remain to be listed. If your results were truncated, you can make a follow-up pagination request using the `Marker` request parameter to retrieve more distributions in the list.
         */
        public var isTruncated: kotlin.Boolean? = null
        /**
         * A complex type that contains one `DistributionSummary` element for each distribution that was created by the current Amazon Web Services account.
         */
        public var items: List<DistributionSummary>? = null
        /**
         * The value you provided for the `Marker` request parameter.
         */
        public var marker: kotlin.String? = null
        /**
         * The value you provided for the `MaxItems` request parameter.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * If `IsTruncated` is `true`, this element is present and contains the value you can use for the `Marker` request parameter to continue listing your distributions where they left off.
         */
        public var nextMarker: kotlin.String? = null
        /**
         * The number of distributions that were created by the current Amazon Web Services account.
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.DistributionList) : this() {
            this.isTruncated = x.isTruncated
            this.items = x.items
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.DistributionList = DistributionList(this)

        internal fun correctErrors(): Builder {
            if (isTruncated == null) isTruncated = false
            if (marker == null) marker = ""
            if (maxItems == null) maxItems = 0
            if (quantity == null) quantity = 0
            return this
        }
    }
}
