// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Lists the origin access identities for CloudFront.Send a `GET` request to the `/<i>CloudFront API version</i>/origin-access-identity/cloudfront` resource. The response includes a `CloudFrontOriginAccessIdentityList` element with zero or more `CloudFrontOriginAccessIdentitySummary` child elements. By default, your entire list of origin access identities is returned in one single page. If the list is long, you can paginate it using the `MaxItems` and `Marker` parameters.
 */
public class CloudFrontOriginAccessIdentityList private constructor(builder: Builder) {
    /**
     * A flag that indicates whether more origin access identities remain to be listed. If your results were truncated, you can make a follow-up pagination request using the `Marker` request parameter to retrieve more items in the list.
     */
    public val isTruncated: kotlin.Boolean = requireNotNull(builder.isTruncated) { "A non-null value must be provided for isTruncated" }
    /**
     * A complex type that contains one `CloudFrontOriginAccessIdentitySummary` element for each origin access identity that was created by the current Amazon Web Services account.
     */
    public val items: List<CloudFrontOriginAccessIdentitySummary>? = builder.items
    /**
     * Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the `Marker` to the value of the `NextMarker` from the current page's response (which is also the ID of the last identity on that page).
     */
    public val marker: kotlin.String = requireNotNull(builder.marker) { "A non-null value must be provided for marker" }
    /**
     * The maximum number of origin access identities you want in the response body.
     */
    public val maxItems: kotlin.Int = requireNotNull(builder.maxItems) { "A non-null value must be provided for maxItems" }
    /**
     * If `IsTruncated` is `true`, this element is present and contains the value you can use for the `Marker` request parameter to continue listing your origin access identities where they left off.
     */
    public val nextMarker: kotlin.String? = builder.nextMarker
    /**
     * The number of CloudFront origin access identities that were created by the current Amazon Web Services account.
     */
    public val quantity: kotlin.Int = requireNotNull(builder.quantity) { "A non-null value must be provided for quantity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityList = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudFrontOriginAccessIdentityList(")
        append("isTruncated=$isTruncated,")
        append("items=$items,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isTruncated.hashCode()
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (marker.hashCode())
        result = 31 * result + (maxItems)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudFrontOriginAccessIdentityList

        if (isTruncated != other.isTruncated) return false
        if (items != other.items) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityList = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A flag that indicates whether more origin access identities remain to be listed. If your results were truncated, you can make a follow-up pagination request using the `Marker` request parameter to retrieve more items in the list.
         */
        public var isTruncated: kotlin.Boolean? = null
        /**
         * A complex type that contains one `CloudFrontOriginAccessIdentitySummary` element for each origin access identity that was created by the current Amazon Web Services account.
         */
        public var items: List<CloudFrontOriginAccessIdentitySummary>? = null
        /**
         * Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the `Marker` to the value of the `NextMarker` from the current page's response (which is also the ID of the last identity on that page).
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of origin access identities you want in the response body.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * If `IsTruncated` is `true`, this element is present and contains the value you can use for the `Marker` request parameter to continue listing your origin access identities where they left off.
         */
        public var nextMarker: kotlin.String? = null
        /**
         * The number of CloudFront origin access identities that were created by the current Amazon Web Services account.
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityList) : this() {
            this.isTruncated = x.isTruncated
            this.items = x.items
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityList = CloudFrontOriginAccessIdentityList(this)

        internal fun correctErrors(): Builder {
            if (isTruncated == null) isTruncated = false
            if (marker == null) marker = ""
            if (maxItems == null) maxItems = 0
            if (quantity == null) quantity = 0
            return this
        }
    }
}
