// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A cache policy configuration.
 *
 * This configuration determines the following:
 * + The values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
 * + The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.
 *
 * The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find a valid object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use `OriginRequestPolicy`.
 */
public class CachePolicyConfig private constructor(builder: Builder) {
    /**
     * A comment to describe the cache policy. The comment cannot be longer than 128 characters.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value as the object's time to live (TTL) only when the origin does *not* send `Cache-Control` or `Expires` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
     *
     * The default value for this field is 86400 seconds (one day). If the value of `MinTTL` is more than 86400 seconds, then the default value for this field is the same as the value of `MinTTL`.
     */
    public val defaultTtl: kotlin.Long? = builder.defaultTtl
    /**
     * The maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value only when the origin sends `Cache-Control` or `Expires` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
     *
     * The default value for this field is 31536000 seconds (one year). If the value of `MinTTL` or `DefaultTTL` is more than 31536000 seconds, then the default value for this field is the same as the value of `DefaultTTL`.
     */
    public val maxTtl: kotlin.Long? = builder.maxTtl
    /**
     * The minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val minTtl: kotlin.Long = requireNotNull(builder.minTtl) { "A non-null value must be provided for minTtl" }
    /**
     * A unique name to identify the cache policy.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The HTTP headers, cookies, and URL query strings to include in the cache key. The values included in the cache key are also included in requests that CloudFront sends to the origin.
     */
    public val parametersInCacheKeyAndForwardedToOrigin: aws.sdk.kotlin.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin? = builder.parametersInCacheKeyAndForwardedToOrigin

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CachePolicyConfig(")
        append("comment=$comment,")
        append("defaultTtl=$defaultTtl,")
        append("maxTtl=$maxTtl,")
        append("minTtl=$minTtl,")
        append("name=$name,")
        append("parametersInCacheKeyAndForwardedToOrigin=$parametersInCacheKeyAndForwardedToOrigin")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (defaultTtl?.hashCode() ?: 0)
        result = 31 * result + (maxTtl?.hashCode() ?: 0)
        result = 31 * result + (minTtl.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (parametersInCacheKeyAndForwardedToOrigin?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CachePolicyConfig

        if (comment != other.comment) return false
        if (defaultTtl != other.defaultTtl) return false
        if (maxTtl != other.maxTtl) return false
        if (minTtl != other.minTtl) return false
        if (name != other.name) return false
        if (parametersInCacheKeyAndForwardedToOrigin != other.parametersInCacheKeyAndForwardedToOrigin) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A comment to describe the cache policy. The comment cannot be longer than 128 characters.
         */
        public var comment: kotlin.String? = null
        /**
         * The default amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value as the object's time to live (TTL) only when the origin does *not* send `Cache-Control` or `Expires` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         *
         * The default value for this field is 86400 seconds (one day). If the value of `MinTTL` is more than 86400 seconds, then the default value for this field is the same as the value of `MinTTL`.
         */
        public var defaultTtl: kotlin.Long? = null
        /**
         * The maximum amount of time, in seconds, that objects stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. CloudFront uses this value only when the origin sends `Cache-Control` or `Expires` headers with the object. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         *
         * The default value for this field is 31536000 seconds (one year). If the value of `MinTTL` or `DefaultTTL` is more than 31536000 seconds, then the default value for this field is the same as the value of `DefaultTTL`.
         */
        public var maxTtl: kotlin.Long? = null
        /**
         * The minimum amount of time, in seconds, that you want objects to stay in the CloudFront cache before CloudFront sends another request to the origin to see if the object has been updated. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var minTtl: kotlin.Long? = null
        /**
         * A unique name to identify the cache policy.
         */
        public var name: kotlin.String? = null
        /**
         * The HTTP headers, cookies, and URL query strings to include in the cache key. The values included in the cache key are also included in requests that CloudFront sends to the origin.
         */
        public var parametersInCacheKeyAndForwardedToOrigin: aws.sdk.kotlin.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig) : this() {
            this.comment = x.comment
            this.defaultTtl = x.defaultTtl
            this.maxTtl = x.maxTtl
            this.minTtl = x.minTtl
            this.name = x.name
            this.parametersInCacheKeyAndForwardedToOrigin = x.parametersInCacheKeyAndForwardedToOrigin
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig = CachePolicyConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin] inside the given [block]
         */
        public fun parametersInCacheKeyAndForwardedToOrigin(block: aws.sdk.kotlin.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin.Builder.() -> kotlin.Unit) {
            this.parametersInCacheKeyAndForwardedToOrigin = aws.sdk.kotlin.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (minTtl == null) minTtl = 0L
            if (name == null) name = ""
            return this
        }
    }
}
