// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A cache policy.
 *
 * When it's attached to a cache behavior, the cache policy determines the following:
 * + The values that CloudFront includes in the cache key. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
 * + The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.
 *
 * The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find a valid object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use `OriginRequestPolicy`.
 */
public class CachePolicy private constructor(builder: Builder) {
    /**
     * The cache policy configuration.
     */
    public val cachePolicyConfig: aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig? = builder.cachePolicyConfig
    /**
     * The unique identifier for the cache policy.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date and time when the cache policy was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CachePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CachePolicy(")
        append("cachePolicyConfig=$cachePolicyConfig,")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cachePolicyConfig?.hashCode() ?: 0
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CachePolicy

        if (cachePolicyConfig != other.cachePolicyConfig) return false
        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CachePolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The cache policy configuration.
         */
        public var cachePolicyConfig: aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig? = null
        /**
         * The unique identifier for the cache policy.
         */
        public var id: kotlin.String? = null
        /**
         * The date and time when the cache policy was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CachePolicy) : this() {
            this.cachePolicyConfig = x.cachePolicyConfig
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CachePolicy = CachePolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig] inside the given [block]
         */
        public fun cachePolicyConfig(block: aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig.Builder.() -> kotlin.Unit) {
            this.cachePolicyConfig = aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
