// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions. The status is returned in the CloudFront response; you can't configure it yourself.
 *
 * For more information about ICP recordals, see [ Signup, Accounts, and Credentials](https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html) in *Getting Started with Amazon Web Services services in China*.
 */
public class AliasIcpRecordal private constructor(builder: Builder) {
    /**
     * A domain name associated with a distribution.
     */
    public val cname: kotlin.String? = builder.cname
    /**
     * The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to APPROVED for all CNAMEs (aliases) in regions outside of China.
     *
     * The status values returned are the following:
     * + **APPROVED** indicates that the associated CNAME has a valid ICP recordal number. Multiple CNAMEs can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.
     * + **SUSPENDED** indicates that the associated CNAME does not have a valid ICP recordal number.
     * + **PENDING** indicates that CloudFront can't determine the ICP recordal status of the CNAME associated with the distribution because there was an error in trying to determine the status. You can try again to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
     */
    public val icpRecordalStatus: aws.sdk.kotlin.services.cloudfront.model.IcpRecordalStatus? = builder.icpRecordalStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.AliasIcpRecordal = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AliasIcpRecordal(")
        append("cname=$cname,")
        append("icpRecordalStatus=$icpRecordalStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cname?.hashCode() ?: 0
        result = 31 * result + (icpRecordalStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AliasIcpRecordal

        if (cname != other.cname) return false
        if (icpRecordalStatus != other.icpRecordalStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.AliasIcpRecordal = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A domain name associated with a distribution.
         */
        public var cname: kotlin.String? = null
        /**
         * The Internet Content Provider (ICP) recordal status for a CNAME. The ICPRecordalStatus is set to APPROVED for all CNAMEs (aliases) in regions outside of China.
         *
         * The status values returned are the following:
         * + **APPROVED** indicates that the associated CNAME has a valid ICP recordal number. Multiple CNAMEs can be associated with a distribution, and CNAMEs can correspond to different ICP recordals. To be marked as APPROVED, that is, valid to use with China region, a CNAME must have one ICP recordal number associated with it.
         * + **SUSPENDED** indicates that the associated CNAME does not have a valid ICP recordal number.
         * + **PENDING** indicates that CloudFront can't determine the ICP recordal status of the CNAME associated with the distribution because there was an error in trying to determine the status. You can try again to see if the error is resolved in which case CloudFront returns an APPROVED or SUSPENDED status.
         */
        public var icpRecordalStatus: aws.sdk.kotlin.services.cloudfront.model.IcpRecordalStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.AliasIcpRecordal) : this() {
            this.cname = x.cname
            this.icpRecordalStatus = x.icpRecordalStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.AliasIcpRecordal = AliasIcpRecordal(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
