// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.cloudfront.auth.CloudFrontAuthSchemeProvider
import aws.sdk.kotlin.services.cloudfront.auth.DefaultCloudFrontAuthSchemeProvider
import aws.sdk.kotlin.services.cloudfront.endpoints.CloudFrontEndpointParameters
import aws.sdk.kotlin.services.cloudfront.endpoints.CloudFrontEndpointProvider
import aws.sdk.kotlin.services.cloudfront.endpoints.DefaultCloudFrontEndpointProvider
import aws.sdk.kotlin.services.cloudfront.model.AssociateAliasRequest
import aws.sdk.kotlin.services.cloudfront.model.AssociateAliasResponse
import aws.sdk.kotlin.services.cloudfront.model.CopyDistributionRequest
import aws.sdk.kotlin.services.cloudfront.model.CopyDistributionResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateCachePolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateCachePolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateContinuousDeploymentPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateContinuousDeploymentPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateDistributionRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateDistributionResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateDistributionWithTagsRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateDistributionWithTagsResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateFunctionRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateFunctionResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateInvalidationRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateInvalidationResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateKeyGroupRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateKeyGroupResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateKeyValueStoreRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateKeyValueStoreResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateMonitoringSubscriptionRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateMonitoringSubscriptionResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateOriginAccessControlRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateOriginAccessControlResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateOriginRequestPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateOriginRequestPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.CreatePublicKeyRequest
import aws.sdk.kotlin.services.cloudfront.model.CreatePublicKeyResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateRealtimeLogConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateRealtimeLogConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateResponseHeadersPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateResponseHeadersPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateStreamingDistributionRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateStreamingDistributionResponse
import aws.sdk.kotlin.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest
import aws.sdk.kotlin.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteCachePolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteCachePolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteContinuousDeploymentPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteContinuousDeploymentPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteDistributionRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteDistributionResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteFieldLevelEncryptionProfileResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteFunctionRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteFunctionResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteKeyGroupRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteKeyGroupResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteKeyValueStoreRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteKeyValueStoreResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteMonitoringSubscriptionRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteMonitoringSubscriptionResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteOriginAccessControlRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteOriginAccessControlResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteOriginRequestPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteOriginRequestPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.DeletePublicKeyRequest
import aws.sdk.kotlin.services.cloudfront.model.DeletePublicKeyResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteRealtimeLogConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteRealtimeLogConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteResponseHeadersPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteResponseHeadersPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.DeleteStreamingDistributionRequest
import aws.sdk.kotlin.services.cloudfront.model.DeleteStreamingDistributionResponse
import aws.sdk.kotlin.services.cloudfront.model.DescribeFunctionRequest
import aws.sdk.kotlin.services.cloudfront.model.DescribeFunctionResponse
import aws.sdk.kotlin.services.cloudfront.model.DescribeKeyValueStoreRequest
import aws.sdk.kotlin.services.cloudfront.model.DescribeKeyValueStoreResponse
import aws.sdk.kotlin.services.cloudfront.model.GetCachePolicyConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetCachePolicyConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetCachePolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.GetCachePolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest
import aws.sdk.kotlin.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse
import aws.sdk.kotlin.services.cloudfront.model.GetContinuousDeploymentPolicyConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetContinuousDeploymentPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.GetContinuousDeploymentPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.GetDistributionConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetDistributionConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetDistributionRequest
import aws.sdk.kotlin.services.cloudfront.model.GetDistributionResponse
import aws.sdk.kotlin.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest
import aws.sdk.kotlin.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse
import aws.sdk.kotlin.services.cloudfront.model.GetFieldLevelEncryptionRequest
import aws.sdk.kotlin.services.cloudfront.model.GetFieldLevelEncryptionResponse
import aws.sdk.kotlin.services.cloudfront.model.GetFunctionRequest
import aws.sdk.kotlin.services.cloudfront.model.GetFunctionResponse
import aws.sdk.kotlin.services.cloudfront.model.GetInvalidationRequest
import aws.sdk.kotlin.services.cloudfront.model.GetInvalidationResponse
import aws.sdk.kotlin.services.cloudfront.model.GetKeyGroupConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetKeyGroupConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetKeyGroupRequest
import aws.sdk.kotlin.services.cloudfront.model.GetKeyGroupResponse
import aws.sdk.kotlin.services.cloudfront.model.GetMonitoringSubscriptionRequest
import aws.sdk.kotlin.services.cloudfront.model.GetMonitoringSubscriptionResponse
import aws.sdk.kotlin.services.cloudfront.model.GetOriginAccessControlConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetOriginAccessControlConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetOriginAccessControlRequest
import aws.sdk.kotlin.services.cloudfront.model.GetOriginAccessControlResponse
import aws.sdk.kotlin.services.cloudfront.model.GetOriginRequestPolicyConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetOriginRequestPolicyConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetOriginRequestPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.GetOriginRequestPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.GetPublicKeyConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetPublicKeyConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetPublicKeyRequest
import aws.sdk.kotlin.services.cloudfront.model.GetPublicKeyResponse
import aws.sdk.kotlin.services.cloudfront.model.GetRealtimeLogConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetRealtimeLogConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetResponseHeadersPolicyConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetResponseHeadersPolicyConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetResponseHeadersPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.GetResponseHeadersPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.GetStreamingDistributionConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.GetStreamingDistributionConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.GetStreamingDistributionRequest
import aws.sdk.kotlin.services.cloudfront.model.GetStreamingDistributionResponse
import aws.sdk.kotlin.services.cloudfront.model.ListCachePoliciesRequest
import aws.sdk.kotlin.services.cloudfront.model.ListCachePoliciesResponse
import aws.sdk.kotlin.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest
import aws.sdk.kotlin.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse
import aws.sdk.kotlin.services.cloudfront.model.ListConflictingAliasesRequest
import aws.sdk.kotlin.services.cloudfront.model.ListConflictingAliasesResponse
import aws.sdk.kotlin.services.cloudfront.model.ListContinuousDeploymentPoliciesRequest
import aws.sdk.kotlin.services.cloudfront.model.ListContinuousDeploymentPoliciesResponse
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByKeyGroupRequest
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByKeyGroupResponse
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdResponse
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByWebAclIdRequest
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByWebAclIdResponse
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsRequest
import aws.sdk.kotlin.services.cloudfront.model.ListDistributionsResponse
import aws.sdk.kotlin.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest
import aws.sdk.kotlin.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse
import aws.sdk.kotlin.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest
import aws.sdk.kotlin.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse
import aws.sdk.kotlin.services.cloudfront.model.ListFunctionsRequest
import aws.sdk.kotlin.services.cloudfront.model.ListFunctionsResponse
import aws.sdk.kotlin.services.cloudfront.model.ListInvalidationsRequest
import aws.sdk.kotlin.services.cloudfront.model.ListInvalidationsResponse
import aws.sdk.kotlin.services.cloudfront.model.ListKeyGroupsRequest
import aws.sdk.kotlin.services.cloudfront.model.ListKeyGroupsResponse
import aws.sdk.kotlin.services.cloudfront.model.ListKeyValueStoresRequest
import aws.sdk.kotlin.services.cloudfront.model.ListKeyValueStoresResponse
import aws.sdk.kotlin.services.cloudfront.model.ListOriginAccessControlsRequest
import aws.sdk.kotlin.services.cloudfront.model.ListOriginAccessControlsResponse
import aws.sdk.kotlin.services.cloudfront.model.ListOriginRequestPoliciesRequest
import aws.sdk.kotlin.services.cloudfront.model.ListOriginRequestPoliciesResponse
import aws.sdk.kotlin.services.cloudfront.model.ListPublicKeysRequest
import aws.sdk.kotlin.services.cloudfront.model.ListPublicKeysResponse
import aws.sdk.kotlin.services.cloudfront.model.ListRealtimeLogConfigsRequest
import aws.sdk.kotlin.services.cloudfront.model.ListRealtimeLogConfigsResponse
import aws.sdk.kotlin.services.cloudfront.model.ListResponseHeadersPoliciesRequest
import aws.sdk.kotlin.services.cloudfront.model.ListResponseHeadersPoliciesResponse
import aws.sdk.kotlin.services.cloudfront.model.ListStreamingDistributionsRequest
import aws.sdk.kotlin.services.cloudfront.model.ListStreamingDistributionsResponse
import aws.sdk.kotlin.services.cloudfront.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.cloudfront.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.cloudfront.model.PublishFunctionRequest
import aws.sdk.kotlin.services.cloudfront.model.PublishFunctionResponse
import aws.sdk.kotlin.services.cloudfront.model.TagResourceRequest
import aws.sdk.kotlin.services.cloudfront.model.TagResourceResponse
import aws.sdk.kotlin.services.cloudfront.model.TestFunctionRequest
import aws.sdk.kotlin.services.cloudfront.model.TestFunctionResponse
import aws.sdk.kotlin.services.cloudfront.model.UntagResourceRequest
import aws.sdk.kotlin.services.cloudfront.model.UntagResourceResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateCachePolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateCachePolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateContinuousDeploymentPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateContinuousDeploymentPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateDistributionRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateDistributionResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateDistributionWithStagingConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateDistributionWithStagingConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateFunctionRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateFunctionResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateKeyGroupRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateKeyGroupResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateKeyValueStoreRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateKeyValueStoreResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateOriginAccessControlRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateOriginAccessControlResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateOriginRequestPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateOriginRequestPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdatePublicKeyRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdatePublicKeyResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateRealtimeLogConfigRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateRealtimeLogConfigResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateResponseHeadersPolicyRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateResponseHeadersPolicyResponse
import aws.sdk.kotlin.services.cloudfront.model.UpdateStreamingDistributionRequest
import aws.sdk.kotlin.services.cloudfront.model.UpdateStreamingDistributionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "CloudFront"
public const val SdkVersion: String = "1.3.13"
public const val ServiceApiVersion: String = "2020-05-31"

/**
 * # Amazon CloudFront
 * This is the *Amazon CloudFront API Reference*. This guide is for developers who need detailed information about CloudFront API actions, data types, and errors. For detailed information about CloudFront features, see the [Amazon CloudFront Developer Guide](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Introduction.html).
 */
public interface CloudFrontClient : SdkClient {
    /**
     * CloudFrontClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CloudFrontClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CloudFront",
                "CLOUDFRONT",
                "cloudfront",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CloudFrontClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CloudFrontClient = DefaultCloudFrontClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CloudFrontEndpointProvider = builder.endpointProvider ?: DefaultCloudFrontEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CloudFrontAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCloudFrontAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CloudFront"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CloudFrontEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CloudFrontAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution.
     *
     * With this operation you can move an alias that's already in use on a CloudFront distribution to a different distribution in one step. This prevents the downtime that could occur if you first remove the alias from one distribution and then separately add the alias to another distribution.
     *
     * To use this operation to associate an alias with a distribution, you provide the alias and the ID of the target distribution for the alias. For more information, including how to set up the target distribution, prerequisites that you must complete, and other restrictions, see [Moving an alternate domain name to a different distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun associateAlias(input: AssociateAliasRequest): AssociateAliasResponse

    /**
     * Creates a staging distribution using the configuration of the provided primary distribution. A staging distribution is a copy of an existing distribution (called the primary distribution) that you can use in a continuous deployment workflow.
     *
     * After you create a staging distribution, you can use `UpdateDistribution` to modify the staging distribution's configuration. Then you can use `CreateContinuousDeploymentPolicy` to incrementally move traffic to the staging distribution.
     *
     * This API operation requires the following IAM permissions:
     * + [GetDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html)
     * + [CreateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html)
     * + [CopyDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CopyDistribution.html)
     */
    public suspend fun copyDistribution(input: CopyDistributionRequest): CopyDistributionResponse

    /**
     * Creates a cache policy.
     *
     * After you create a cache policy, you can attach it to one or more cache behaviors. When it's attached to a cache behavior, the cache policy determines the following:
     * + The values that CloudFront includes in the *cache key*. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
     * + The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.
     *
     * The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find an object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use `OriginRequestPolicy`.
     *
     * For more information about cache policies, see [Controlling the cache key](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun createCachePolicy(input: CreateCachePolicyRequest): CreateCachePolicyResponse

    /**
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more information about how to use origin access identities, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun createCloudFrontOriginAccessIdentity(input: CreateCloudFrontOriginAccessIdentityRequest): CreateCloudFrontOriginAccessIdentityResponse

    /**
     * Creates a continuous deployment policy that distributes traffic for a custom domain name to two different CloudFront distributions.
     *
     * To use a continuous deployment policy, first use `CopyDistribution` to create a staging distribution, then use `UpdateDistribution` to modify the staging distribution's configuration.
     *
     * After you create and update a staging distribution, you can use a continuous deployment policy to incrementally move traffic to the staging distribution. This workflow enables you to test changes to a distribution's configuration before moving all of your domain's production traffic to the new configuration.
     */
    public suspend fun createContinuousDeploymentPolicy(input: CreateContinuousDeploymentPolicyRequest): CreateContinuousDeploymentPolicyResponse

    /**
     * Creates a CloudFront distribution.
     */
    public suspend fun createDistribution(input: CreateDistributionRequest): CreateDistributionResponse

    /**
     * Create a new distribution with tags. This API operation requires the following IAM permissions:
     * + [CreateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html)
     * + [TagResource](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_TagResource.html)
     */
    public suspend fun createDistributionWithTags(input: CreateDistributionWithTagsRequest): CreateDistributionWithTagsResponse

    /**
     * Create a new field-level encryption configuration.
     */
    public suspend fun createFieldLevelEncryptionConfig(input: CreateFieldLevelEncryptionConfigRequest): CreateFieldLevelEncryptionConfigResponse

    /**
     * Create a field-level encryption profile.
     */
    public suspend fun createFieldLevelEncryptionProfile(input: CreateFieldLevelEncryptionProfileRequest): CreateFieldLevelEncryptionProfileResponse

    /**
     * Creates a CloudFront function.
     *
     * To create a function, you provide the function code and some configuration information about the function. The response contains an Amazon Resource Name (ARN) that uniquely identifies the function.
     *
     * When you create a function, it's in the `DEVELOPMENT` stage. In this stage, you can test the function with `TestFunction`, and update it with `UpdateFunction`.
     *
     * When you're ready to use your function with a CloudFront distribution, use `PublishFunction` to copy the function from the `DEVELOPMENT` stage to `LIVE`. When it's live, you can attach the function to a distribution's cache behavior, using the function's ARN.
     */
    public suspend fun createFunction(input: CreateFunctionRequest): CreateFunctionResponse

    /**
     * Create a new invalidation. For more information, see [Invalidating files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun createInvalidation(input: CreateInvalidationRequest): CreateInvalidationResponse

    /**
     * Creates a key group that you can use with [CloudFront signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
     *
     * To create a key group, you must specify at least one public key for the key group. After you create a key group, you can reference it from one or more cache behaviors. When you reference a key group in a cache behavior, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun createKeyGroup(input: CreateKeyGroupRequest): CreateKeyGroupResponse

    /**
     * Specifies the key value store resource to add to your account. In your account, the key value store names must be unique. You can also import key value store data in JSON format from an S3 bucket by providing a valid `ImportSource` that you own.
     */
    public suspend fun createKeyValueStore(input: CreateKeyValueStoreRequest): CreateKeyValueStoreResponse

    /**
     * Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an additional cost.
     *
     * For more information, see [Viewing additional CloudFront distribution metrics](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun createMonitoringSubscription(input: CreateMonitoringSubscriptionRequest): CreateMonitoringSubscriptionResponse

    /**
     * Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
     *
     * This makes it possible to block public access to the origin, allowing viewers (users) to access the origin's content only through CloudFront.
     *
     * For more information about using a CloudFront origin access control, see [Restricting access to an Amazon Web Services origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun createOriginAccessControl(input: CreateOriginAccessControlRequest): CreateOriginAccessControlResponse

    /**
     * Creates an origin request policy.
     *
     * After you create an origin request policy, you can attach it to one or more cache behaviors. When it's attached to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
     * + The request body and the URL path (without the domain name) from the viewer request.
     * + The headers that CloudFront automatically includes in every origin request, including `Host`, `User-Agent`, and `X-Amz-Cf-Id`.
     * + All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.
     *
     * CloudFront sends a request when it can't find a valid object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use `CachePolicy`.
     *
     * For more information about origin request policies, see [Controlling origin requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun createOriginRequestPolicy(input: CreateOriginRequestPolicyRequest): CreateOriginRequestPolicyResponse

    /**
     * Uploads a public key to CloudFront that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
     */
    public suspend fun createPublicKey(input: CreatePublicKeyRequest): CreatePublicKeyResponse

    /**
     * Creates a real-time log configuration.
     *
     * After you create a real-time log configuration, you can attach it to one or more cache behaviors to send real-time log data to the specified Amazon Kinesis data stream.
     *
     * For more information about real-time log configurations, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun createRealtimeLogConfig(input: CreateRealtimeLogConfigRequest): CreateRealtimeLogConfigResponse

    /**
     * Creates a response headers policy.
     *
     * A response headers policy contains information about a set of HTTP headers. To create a response headers policy, you provide some metadata about the policy and a set of configurations that specify the headers.
     *
     * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a CloudFront distribution. When it's attached to a cache behavior, the response headers policy affects the HTTP headers that CloudFront includes in HTTP responses to requests that match the cache behavior. CloudFront adds or removes response headers according to the configuration of the response headers policy.
     *
     * For more information, see [Adding or removing HTTP headers in CloudFront responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/modifying-response-headers.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun createResponseHeadersPolicy(input: CreateResponseHeadersPolicyRequest): CreateResponseHeadersPolicyResponse

    /**
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, [read the announcement](http://forums.aws.amazon.com/ann.jspa?annID=7356) on the Amazon CloudFront discussion forum.
     */
    public suspend fun createStreamingDistribution(input: CreateStreamingDistributionRequest): CreateStreamingDistributionResponse

    /**
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, [read the announcement](http://forums.aws.amazon.com/ann.jspa?annID=7356) on the Amazon CloudFront discussion forum.
     */
    public suspend fun createStreamingDistributionWithTags(input: CreateStreamingDistributionWithTagsRequest): CreateStreamingDistributionWithTagsResponse

    /**
     * Deletes a cache policy.
     *
     * You cannot delete a cache policy if it's attached to a cache behavior. First update your distributions to remove the cache policy from all cache behaviors, then delete the cache policy.
     *
     * To delete a cache policy, you must provide the policy's identifier and version. To get these values, you can use `ListCachePolicies` or `GetCachePolicy`.
     */
    public suspend fun deleteCachePolicy(input: DeleteCachePolicyRequest): DeleteCachePolicyResponse

    /**
     * Delete an origin access identity.
     */
    public suspend fun deleteCloudFrontOriginAccessIdentity(input: DeleteCloudFrontOriginAccessIdentityRequest): DeleteCloudFrontOriginAccessIdentityResponse

    /**
     * Deletes a continuous deployment policy.
     *
     * You cannot delete a continuous deployment policy that's attached to a primary distribution. First update your distribution to remove the continuous deployment policy, then you can delete the policy.
     */
    public suspend fun deleteContinuousDeploymentPolicy(input: DeleteContinuousDeploymentPolicyRequest): DeleteContinuousDeploymentPolicyResponse

    /**
     * Delete a distribution.
     */
    public suspend fun deleteDistribution(input: DeleteDistributionRequest): DeleteDistributionResponse

    /**
     * Remove a field-level encryption configuration.
     */
    public suspend fun deleteFieldLevelEncryptionConfig(input: DeleteFieldLevelEncryptionConfigRequest): DeleteFieldLevelEncryptionConfigResponse

    /**
     * Remove a field-level encryption profile.
     */
    public suspend fun deleteFieldLevelEncryptionProfile(input: DeleteFieldLevelEncryptionProfileRequest): DeleteFieldLevelEncryptionProfileResponse

    /**
     * Deletes a CloudFront function.
     *
     * You cannot delete a function if it's associated with a cache behavior. First, update your distributions to remove the function association from all cache behaviors, then delete the function.
     *
     * To delete a function, you must provide the function's name and version (`ETag` value). To get these values, you can use `ListFunctions` and `DescribeFunction`.
     */
    public suspend fun deleteFunction(input: DeleteFunctionRequest): DeleteFunctionResponse

    /**
     * Deletes a key group.
     *
     * You cannot delete a key group that is referenced in a cache behavior. First update your distributions to remove the key group from all cache behaviors, then delete the key group.
     *
     * To delete a key group, you must provide the key group's identifier and version. To get these values, use `ListKeyGroups` followed by `GetKeyGroup` or `GetKeyGroupConfig`.
     */
    public suspend fun deleteKeyGroup(input: DeleteKeyGroupRequest): DeleteKeyGroupResponse

    /**
     * Specifies the key value store to delete.
     */
    public suspend fun deleteKeyValueStore(input: DeleteKeyValueStoreRequest): DeleteKeyValueStoreResponse

    /**
     * Disables additional CloudWatch metrics for the specified CloudFront distribution.
     */
    public suspend fun deleteMonitoringSubscription(input: DeleteMonitoringSubscriptionRequest): DeleteMonitoringSubscriptionResponse

    /**
     * Deletes a CloudFront origin access control.
     *
     * You cannot delete an origin access control if it's in use. First, update all distributions to remove the origin access control from all origins, then delete the origin access control.
     */
    public suspend fun deleteOriginAccessControl(input: DeleteOriginAccessControlRequest): DeleteOriginAccessControlResponse

    /**
     * Deletes an origin request policy.
     *
     * You cannot delete an origin request policy if it's attached to any cache behaviors. First update your distributions to remove the origin request policy from all cache behaviors, then delete the origin request policy.
     *
     * To delete an origin request policy, you must provide the policy's identifier and version. To get the identifier, you can use `ListOriginRequestPolicies` or `GetOriginRequestPolicy`.
     */
    public suspend fun deleteOriginRequestPolicy(input: DeleteOriginRequestPolicyRequest): DeleteOriginRequestPolicyResponse

    /**
     * Remove a public key you previously added to CloudFront.
     */
    public suspend fun deletePublicKey(input: DeletePublicKeyRequest): DeletePublicKeyResponse

    /**
     * Deletes a real-time log configuration.
     *
     * You cannot delete a real-time log configuration if it's attached to a cache behavior. First update your distributions to remove the real-time log configuration from all cache behaviors, then delete the real-time log configuration.
     *
     * To delete a real-time log configuration, you can provide the configuration's name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to delete.
     */
    public suspend fun deleteRealtimeLogConfig(input: DeleteRealtimeLogConfigRequest = DeleteRealtimeLogConfigRequest { }): DeleteRealtimeLogConfigResponse

    /**
     * Deletes a response headers policy.
     *
     * You cannot delete a response headers policy if it's attached to a cache behavior. First update your distributions to remove the response headers policy from all cache behaviors, then delete the response headers policy.
     *
     * To delete a response headers policy, you must provide the policy's identifier and version. To get these values, you can use `ListResponseHeadersPolicies` or `GetResponseHeadersPolicy`.
     */
    public suspend fun deleteResponseHeadersPolicy(input: DeleteResponseHeadersPolicyRequest): DeleteResponseHeadersPolicyResponse

    /**
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following steps.
     *
     * **To delete an RTMP distribution using the CloudFront API**:
     * + Disable the RTMP distribution.
     * + Submit a `GET Streaming Distribution Config` request to get the current configuration and the `Etag` header for the distribution.
     * + Update the XML document that was returned in the response to your `GET Streaming Distribution Config` request to change the value of `Enabled` to `false`.
     * + Submit a `PUT Streaming Distribution Config` request to update the configuration for your distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the HTTP `If-Match` header to the value of the `ETag` header that CloudFront returned when you submitted the `GET Streaming Distribution Config` request in Step 2.
     * + Review the response to the `PUT Streaming Distribution Config` request to confirm that the distribution was successfully disabled.
     * + Submit a `GET Streaming Distribution Config` request to confirm that your changes have propagated. When propagation is complete, the value of `Status` is `Deployed`.
     * + Submit a `DELETE Streaming Distribution` request. Set the value of the HTTP `If-Match` header to the value of the `ETag` header that CloudFront returned when you submitted the `GET Streaming Distribution Config` request in Step 2.
     * + Review the response to your `DELETE Streaming Distribution` request to confirm that the distribution was successfully deleted.
     *
     * For information about deleting a distribution using the CloudFront console, see [Deleting a Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun deleteStreamingDistribution(input: DeleteStreamingDistributionRequest): DeleteStreamingDistributionResponse

    /**
     * Gets configuration information and metadata about a CloudFront function, but not the function's code. To get a function's code, use `GetFunction`.
     *
     * To get configuration information and metadata about a function, you must provide the function's name and stage. To get these values, you can use `ListFunctions`.
     */
    public suspend fun describeFunction(input: DescribeFunctionRequest): DescribeFunctionResponse

    /**
     * Specifies the key value store and its configuration.
     */
    public suspend fun describeKeyValueStore(input: DescribeKeyValueStoreRequest): DescribeKeyValueStoreResponse

    /**
     * Gets a cache policy, including the following metadata:
     * + The policy's identifier.
     * + The date and time when the policy was last modified.
     *
     * To get a cache policy, you must provide the policy's identifier. If the cache policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the cache policy is not attached to a cache behavior, you can get the identifier using `ListCachePolicies`.
     */
    public suspend fun getCachePolicy(input: GetCachePolicyRequest): GetCachePolicyResponse

    /**
     * Gets a cache policy configuration.
     *
     * To get a cache policy configuration, you must provide the policy's identifier. If the cache policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the cache policy is not attached to a cache behavior, you can get the identifier using `ListCachePolicies`.
     */
    public suspend fun getCachePolicyConfig(input: GetCachePolicyConfigRequest): GetCachePolicyConfigResponse

    /**
     * Get the information about an origin access identity.
     */
    public suspend fun getCloudFrontOriginAccessIdentity(input: GetCloudFrontOriginAccessIdentityRequest): GetCloudFrontOriginAccessIdentityResponse

    /**
     * Get the configuration information about an origin access identity.
     */
    public suspend fun getCloudFrontOriginAccessIdentityConfig(input: GetCloudFrontOriginAccessIdentityConfigRequest): GetCloudFrontOriginAccessIdentityConfigResponse

    /**
     * Gets a continuous deployment policy, including metadata (the policy's identifier and the date and time when the policy was last modified).
     */
    public suspend fun getContinuousDeploymentPolicy(input: GetContinuousDeploymentPolicyRequest): GetContinuousDeploymentPolicyResponse

    /**
     * Gets configuration information about a continuous deployment policy.
     */
    public suspend fun getContinuousDeploymentPolicyConfig(input: GetContinuousDeploymentPolicyConfigRequest): GetContinuousDeploymentPolicyConfigResponse

    /**
     * Get the information about a distribution.
     */
    public suspend fun getDistribution(input: GetDistributionRequest): GetDistributionResponse

    /**
     * Get the configuration information about a distribution.
     */
    public suspend fun getDistributionConfig(input: GetDistributionConfigRequest): GetDistributionConfigResponse

    /**
     * Get the field-level encryption configuration information.
     */
    public suspend fun getFieldLevelEncryption(input: GetFieldLevelEncryptionRequest): GetFieldLevelEncryptionResponse

    /**
     * Get the field-level encryption configuration information.
     */
    public suspend fun getFieldLevelEncryptionConfig(input: GetFieldLevelEncryptionConfigRequest): GetFieldLevelEncryptionConfigResponse

    /**
     * Get the field-level encryption profile information.
     */
    public suspend fun getFieldLevelEncryptionProfile(input: GetFieldLevelEncryptionProfileRequest): GetFieldLevelEncryptionProfileResponse

    /**
     * Get the field-level encryption profile configuration information.
     */
    public suspend fun getFieldLevelEncryptionProfileConfig(input: GetFieldLevelEncryptionProfileConfigRequest): GetFieldLevelEncryptionProfileConfigResponse

    /**
     * Gets the code of a CloudFront function. To get configuration information and metadata about a function, use `DescribeFunction`.
     *
     * To get a function's code, you must provide the function's name and stage. To get these values, you can use `ListFunctions`.
     */
    public suspend fun getFunction(input: GetFunctionRequest): GetFunctionResponse

    /**
     * Get the information about an invalidation.
     */
    public suspend fun getInvalidation(input: GetInvalidationRequest): GetInvalidationResponse

    /**
     * Gets a key group, including the date and time when the key group was last modified.
     *
     * To get a key group, you must provide the key group's identifier. If the key group is referenced in a distribution's cache behavior, you can get the key group's identifier using `ListDistributions` or `GetDistribution`. If the key group is not referenced in a cache behavior, you can get the identifier using `ListKeyGroups`.
     */
    public suspend fun getKeyGroup(input: GetKeyGroupRequest): GetKeyGroupResponse

    /**
     * Gets a key group configuration.
     *
     * To get a key group configuration, you must provide the key group's identifier. If the key group is referenced in a distribution's cache behavior, you can get the key group's identifier using `ListDistributions` or `GetDistribution`. If the key group is not referenced in a cache behavior, you can get the identifier using `ListKeyGroups`.
     */
    public suspend fun getKeyGroupConfig(input: GetKeyGroupConfigRequest): GetKeyGroupConfigResponse

    /**
     * Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront distribution.
     */
    public suspend fun getMonitoringSubscription(input: GetMonitoringSubscriptionRequest): GetMonitoringSubscriptionResponse

    /**
     * Gets a CloudFront origin access control, including its unique identifier.
     */
    public suspend fun getOriginAccessControl(input: GetOriginAccessControlRequest): GetOriginAccessControlResponse

    /**
     * Gets a CloudFront origin access control configuration.
     */
    public suspend fun getOriginAccessControlConfig(input: GetOriginAccessControlConfigRequest): GetOriginAccessControlConfigResponse

    /**
     * Gets an origin request policy, including the following metadata:
     * + The policy's identifier.
     * + The date and time when the policy was last modified.
     *
     * To get an origin request policy, you must provide the policy's identifier. If the origin request policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the origin request policy is not attached to a cache behavior, you can get the identifier using `ListOriginRequestPolicies`.
     */
    public suspend fun getOriginRequestPolicy(input: GetOriginRequestPolicyRequest): GetOriginRequestPolicyResponse

    /**
     * Gets an origin request policy configuration.
     *
     * To get an origin request policy configuration, you must provide the policy's identifier. If the origin request policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the origin request policy is not attached to a cache behavior, you can get the identifier using `ListOriginRequestPolicies`.
     */
    public suspend fun getOriginRequestPolicyConfig(input: GetOriginRequestPolicyConfigRequest): GetOriginRequestPolicyConfigResponse

    /**
     * Gets a public key.
     */
    public suspend fun getPublicKey(input: GetPublicKeyRequest): GetPublicKeyResponse

    /**
     * Gets a public key configuration.
     */
    public suspend fun getPublicKeyConfig(input: GetPublicKeyConfigRequest): GetPublicKeyConfigResponse

    /**
     * Gets a real-time log configuration.
     *
     * To get a real-time log configuration, you can provide the configuration's name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to get.
     */
    public suspend fun getRealtimeLogConfig(input: GetRealtimeLogConfigRequest = GetRealtimeLogConfigRequest { }): GetRealtimeLogConfigResponse

    /**
     * Gets a response headers policy, including metadata (the policy's identifier and the date and time when the policy was last modified).
     *
     * To get a response headers policy, you must provide the policy's identifier. If the response headers policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the response headers policy is not attached to a cache behavior, you can get the identifier using `ListResponseHeadersPolicies`.
     */
    public suspend fun getResponseHeadersPolicy(input: GetResponseHeadersPolicyRequest): GetResponseHeadersPolicyResponse

    /**
     * Gets a response headers policy configuration.
     *
     * To get a response headers policy configuration, you must provide the policy's identifier. If the response headers policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the response headers policy is not attached to a cache behavior, you can get the identifier using `ListResponseHeadersPolicies`.
     */
    public suspend fun getResponseHeadersPolicyConfig(input: GetResponseHeadersPolicyConfigRequest): GetResponseHeadersPolicyConfigResponse

    /**
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     */
    public suspend fun getStreamingDistribution(input: GetStreamingDistributionRequest): GetStreamingDistributionResponse

    /**
     * Get the configuration information about a streaming distribution.
     */
    public suspend fun getStreamingDistributionConfig(input: GetStreamingDistributionConfigRequest): GetStreamingDistributionConfigResponse

    /**
     * Gets a list of cache policies.
     *
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listCachePolicies(input: ListCachePoliciesRequest = ListCachePoliciesRequest { }): ListCachePoliciesResponse

    /**
     * Lists origin access identities.
     */
    public suspend fun listCloudFrontOriginAccessIdentities(input: ListCloudFrontOriginAccessIdentitiesRequest = ListCloudFrontOriginAccessIdentitiesRequest { }): ListCloudFrontOriginAccessIdentitiesResponse

    /**
     * Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias. In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the distributions and accounts that you own, but helps to protect the information of ones that you don't own.
     *
     * Use this operation to find aliases that are in use in CloudFront that conflict or overlap with the provided alias. For example, if you provide `www.example.com` as input, the returned list can include `www.example.com` and the overlapping wildcard alternate domain name (`*.example.com`), if they exist. If you provide `*.example.com` as input, the returned list can include `*.example.com` and any alternate domain names covered by that wildcard (for example, `www.example.com`, `test.example.com`, `dev.example.com`, and so on), if they exist.
     *
     * To list conflicting aliases, you provide the alias to search and the ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias. For more information, including how to set up the distribution and certificate, see [Moving an alternate domain name to a different distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move) in the *Amazon CloudFront Developer Guide*.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listConflictingAliases(input: ListConflictingAliasesRequest): ListConflictingAliasesResponse

    /**
     * Gets a list of the continuous deployment policies in your Amazon Web Services account.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listContinuousDeploymentPolicies(input: ListContinuousDeploymentPoliciesRequest = ListContinuousDeploymentPoliciesRequest { }): ListContinuousDeploymentPoliciesResponse

    /**
     * List CloudFront distributions.
     */
    public suspend fun listDistributions(input: ListDistributionsRequest = ListDistributionsRequest { }): ListDistributionsResponse

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified cache policy.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listDistributionsByCachePolicyId(input: ListDistributionsByCachePolicyIdRequest): ListDistributionsByCachePolicyIdResponse

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key group.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listDistributionsByKeyGroup(input: ListDistributionsByKeyGroupRequest): ListDistributionsByKeyGroupResponse

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified origin request policy.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listDistributionsByOriginRequestPolicyId(input: ListDistributionsByOriginRequestPolicyIdRequest): ListDistributionsByOriginRequestPolicyIdResponse

    /**
     * Gets a list of distributions that have a cache behavior that's associated with the specified real-time log configuration.
     *
     * You can specify the real-time log configuration by its name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to list distributions for.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listDistributionsByRealtimeLogConfig(input: ListDistributionsByRealtimeLogConfigRequest = ListDistributionsByRealtimeLogConfigRequest { }): ListDistributionsByRealtimeLogConfigResponse

    /**
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified response headers policy.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listDistributionsByResponseHeadersPolicyId(input: ListDistributionsByResponseHeadersPolicyIdRequest): ListDistributionsByResponseHeadersPolicyIdResponse

    /**
     * List the distributions that are associated with a specified WAF web ACL.
     */
    public suspend fun listDistributionsByWebAclId(input: ListDistributionsByWebAclIdRequest): ListDistributionsByWebAclIdResponse

    /**
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     */
    public suspend fun listFieldLevelEncryptionConfigs(input: ListFieldLevelEncryptionConfigsRequest = ListFieldLevelEncryptionConfigsRequest { }): ListFieldLevelEncryptionConfigsResponse

    /**
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     */
    public suspend fun listFieldLevelEncryptionProfiles(input: ListFieldLevelEncryptionProfilesRequest = ListFieldLevelEncryptionProfilesRequest { }): ListFieldLevelEncryptionProfilesResponse

    /**
     * Gets a list of all CloudFront functions in your Amazon Web Services account.
     *
     * You can optionally apply a filter to return only the functions that are in the specified stage, either `DEVELOPMENT` or `LIVE`.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listFunctions(input: ListFunctionsRequest = ListFunctionsRequest { }): ListFunctionsResponse

    /**
     * Lists invalidation batches.
     */
    public suspend fun listInvalidations(input: ListInvalidationsRequest): ListInvalidationsResponse

    /**
     * Gets a list of key groups.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listKeyGroups(input: ListKeyGroupsRequest = ListKeyGroupsRequest { }): ListKeyGroupsResponse

    /**
     * Specifies the key value stores to list.
     */
    public suspend fun listKeyValueStores(input: ListKeyValueStoresRequest = ListKeyValueStoresRequest { }): ListKeyValueStoresResponse

    /**
     * Gets the list of CloudFront origin access controls in this Amazon Web Services account.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send another request that specifies the `NextMarker` value from the current response as the `Marker` value in the next request.
     */
    public suspend fun listOriginAccessControls(input: ListOriginAccessControlsRequest = ListOriginAccessControlsRequest { }): ListOriginAccessControlsResponse

    /**
     * Gets a list of origin request policies.
     *
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listOriginRequestPolicies(input: ListOriginRequestPoliciesRequest = ListOriginRequestPoliciesRequest { }): ListOriginRequestPoliciesResponse

    /**
     * List all public keys that have been added to CloudFront for this account.
     */
    public suspend fun listPublicKeys(input: ListPublicKeysRequest = ListPublicKeysRequest { }): ListPublicKeysResponse

    /**
     * Gets a list of real-time log configurations.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listRealtimeLogConfigs(input: ListRealtimeLogConfigsRequest = ListRealtimeLogConfigsRequest { }): ListRealtimeLogConfigsResponse

    /**
     * Gets a list of response headers policies.
     *
     * You can optionally apply a filter to get only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.
     *
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
     */
    public suspend fun listResponseHeadersPolicies(input: ListResponseHeadersPoliciesRequest = ListResponseHeadersPoliciesRequest { }): ListResponseHeadersPoliciesResponse

    /**
     * List streaming distributions.
     */
    public suspend fun listStreamingDistributions(input: ListStreamingDistributionsRequest = ListStreamingDistributionsRequest { }): ListStreamingDistributionsResponse

    /**
     * List tags for a CloudFront resource. For more information, see [Tagging a distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/tagging.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Publishes a CloudFront function by copying the function code from the `DEVELOPMENT` stage to `LIVE`. This automatically updates all cache behaviors that are using this function to use the newly published copy in the `LIVE` stage.
     *
     * When a function is published to the `LIVE` stage, you can attach the function to a distribution's cache behavior, using the function's Amazon Resource Name (ARN).
     *
     * To publish a function, you must provide the function's name and version (`ETag` value). To get these values, you can use `ListFunctions` and `DescribeFunction`.
     */
    public suspend fun publishFunction(input: PublishFunctionRequest): PublishFunctionResponse

    /**
     * Add tags to a CloudFront resource. For more information, see [Tagging a distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/tagging.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tests a CloudFront function.
     *
     * To test a function, you provide an *event object* that represents an HTTP request or response that your CloudFront distribution could receive in production. CloudFront runs the function, passing it the event object that you provided, and returns the function's result (the modified event object) in the response. The response also contains function logs and error messages, if any exist. For more information about testing functions, see [Testing functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function) in the *Amazon CloudFront Developer Guide*.
     *
     * To test a function, you provide the function's name and version (`ETag` value) along with the event object. To get the function's name and version, you can use `ListFunctions` and `DescribeFunction`.
     */
    public suspend fun testFunction(input: TestFunctionRequest): TestFunctionResponse

    /**
     * Remove tags from a CloudFront resource. For more information, see [Tagging a distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/tagging.html) in the *Amazon CloudFront Developer Guide*.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a cache policy configuration.
     *
     * When you update a cache policy configuration, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update a cache policy configuration:
     * + Use `GetCachePolicyConfig` to get the current configuration.
     * + Locally modify the fields in the cache policy configuration that you want to update.
     * + Call `UpdateCachePolicy` by providing the entire cache policy configuration, including the fields that you modified and those that you didn't.
     */
    public suspend fun updateCachePolicy(input: UpdateCachePolicyRequest): UpdateCachePolicyResponse

    /**
     * Update an origin access identity.
     */
    public suspend fun updateCloudFrontOriginAccessIdentity(input: UpdateCloudFrontOriginAccessIdentityRequest): UpdateCloudFrontOriginAccessIdentityResponse

    /**
     * Updates a continuous deployment policy. You can update a continuous deployment policy to enable or disable it, to change the percentage of traffic that it sends to the staging distribution, or to change the staging distribution that it sends traffic to.
     *
     * When you update a continuous deployment policy configuration, all the fields are updated with the values that are provided in the request. You cannot update some fields independent of others. To update a continuous deployment policy configuration:
     * + Use `GetContinuousDeploymentPolicyConfig` to get the current configuration.
     * + Locally modify the fields in the continuous deployment policy configuration that you want to update.
     * + Use `UpdateContinuousDeploymentPolicy`, providing the entire continuous deployment policy configuration, including the fields that you modified and those that you didn't.
     */
    public suspend fun updateContinuousDeploymentPolicy(input: UpdateContinuousDeploymentPolicyRequest): UpdateContinuousDeploymentPolicyResponse

    /**
     * Updates the configuration for a CloudFront distribution.
     *
     * The update process includes getting the current distribution configuration, updating it to make your changes, and then submitting an `UpdateDistribution` request to make the updates.
     *
     * **To update a web distribution using the CloudFront API**
     * + Use `GetDistributionConfig` to get the current configuration, including the version identifier (`ETag`).
     * + Update the distribution configuration that was returned in the response. Note the following important requirements and restrictions:
     *    + You must rename the `ETag` field to `IfMatch`, leaving the value unchanged. (Set the value of `IfMatch` to the value of `ETag`, then remove the `ETag` field.)
     *    + You can't change the value of `CallerReference`.
     * + Submit an `UpdateDistribution` request, providing the distribution configuration. The new configuration replaces the existing configuration. The values that you specify in an `UpdateDistribution` request are not merged into your existing configuration. Make sure to include all fields: the ones that you modified and also the ones that you didn't.
     */
    public suspend fun updateDistribution(input: UpdateDistributionRequest): UpdateDistributionResponse

    /**
     * Copies the staging distribution's configuration to its corresponding primary distribution. The primary distribution retains its `Aliases` (also known as alternate domain names or CNAMEs) and `ContinuousDeploymentPolicyId` value, but otherwise its configuration is overwritten to match the staging distribution.
     *
     * You can use this operation in a continuous deployment workflow after you have tested configuration changes on the staging distribution. After using a continuous deployment policy to move a portion of your domain name's traffic to the staging distribution and verifying that it works as intended, you can use this operation to copy the staging distribution's configuration to the primary distribution. This action will disable the continuous deployment policy and move your domain's traffic back to the primary distribution.
     *
     * This API operation requires the following IAM permissions:
     * + [GetDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html)
     * + [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html)
     */
    public suspend fun updateDistributionWithStagingConfig(input: UpdateDistributionWithStagingConfigRequest): UpdateDistributionWithStagingConfigResponse

    /**
     * Update a field-level encryption configuration.
     */
    public suspend fun updateFieldLevelEncryptionConfig(input: UpdateFieldLevelEncryptionConfigRequest): UpdateFieldLevelEncryptionConfigResponse

    /**
     * Update a field-level encryption profile.
     */
    public suspend fun updateFieldLevelEncryptionProfile(input: UpdateFieldLevelEncryptionProfileRequest): UpdateFieldLevelEncryptionProfileResponse

    /**
     * Updates a CloudFront function.
     *
     * You can update a function's code or the comment that describes the function. You cannot update a function's name.
     *
     * To update a function, you provide the function's name and version (`ETag` value) along with the updated function code. To get the name and version, you can use `ListFunctions` and `DescribeFunction`.
     */
    public suspend fun updateFunction(input: UpdateFunctionRequest): UpdateFunctionResponse

    /**
     * Updates a key group.
     *
     * When you update a key group, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update a key group:
     * + Get the current key group with `GetKeyGroup` or `GetKeyGroupConfig`.
     * + Locally modify the fields in the key group that you want to update. For example, add or remove public key IDs.
     * + Call `UpdateKeyGroup` with the entire key group object, including the fields that you modified and those that you didn't.
     */
    public suspend fun updateKeyGroup(input: UpdateKeyGroupRequest): UpdateKeyGroupResponse

    /**
     * Specifies the key value store to update.
     */
    public suspend fun updateKeyValueStore(input: UpdateKeyValueStoreRequest): UpdateKeyValueStoreResponse

    /**
     * Updates a CloudFront origin access control.
     */
    public suspend fun updateOriginAccessControl(input: UpdateOriginAccessControlRequest): UpdateOriginAccessControlResponse

    /**
     * Updates an origin request policy configuration.
     *
     * When you update an origin request policy configuration, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update an origin request policy configuration:
     * + Use `GetOriginRequestPolicyConfig` to get the current configuration.
     * + Locally modify the fields in the origin request policy configuration that you want to update.
     * + Call `UpdateOriginRequestPolicy` by providing the entire origin request policy configuration, including the fields that you modified and those that you didn't.
     */
    public suspend fun updateOriginRequestPolicy(input: UpdateOriginRequestPolicyRequest): UpdateOriginRequestPolicyResponse

    /**
     * Update public key information. Note that the only value you can change is the comment.
     */
    public suspend fun updatePublicKey(input: UpdatePublicKeyRequest): UpdatePublicKeyResponse

    /**
     * Updates a real-time log configuration.
     *
     * When you update a real-time log configuration, all the parameters are updated with the values provided in the request. You cannot update some parameters independent of others. To update a real-time log configuration:
     * + Call `GetRealtimeLogConfig` to get the current real-time log configuration.
     * + Locally modify the parameters in the real-time log configuration that you want to update.
     * + Call this API (`UpdateRealtimeLogConfig`) by providing the entire real-time log configuration, including the parameters that you modified and those that you didn't.
     *
     * You cannot update a real-time log configuration's `Name` or `ARN`.
     */
    public suspend fun updateRealtimeLogConfig(input: UpdateRealtimeLogConfigRequest = UpdateRealtimeLogConfigRequest { }): UpdateRealtimeLogConfigResponse

    /**
     * Updates a response headers policy.
     *
     * When you update a response headers policy, the entire policy is replaced. You cannot update some policy fields independent of others. To update a response headers policy configuration:
     * + Use `GetResponseHeadersPolicyConfig` to get the current policy's configuration.
     * + Modify the fields in the response headers policy configuration that you want to update.
     * + Call `UpdateResponseHeadersPolicy`, providing the entire response headers policy configuration, including the fields that you modified and those that you didn't.
     */
    public suspend fun updateResponseHeadersPolicy(input: UpdateResponseHeadersPolicyRequest): UpdateResponseHeadersPolicyResponse

    /**
     * Update a streaming distribution.
     */
    public suspend fun updateStreamingDistribution(input: UpdateStreamingDistributionRequest): UpdateStreamingDistributionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CloudFrontClient.withConfig(block: CloudFrontClient.Config.Builder.() -> Unit): CloudFrontClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCloudFrontClient(newConfig)
}

/**
 * Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution.
 *
 * With this operation you can move an alias that's already in use on a CloudFront distribution to a different distribution in one step. This prevents the downtime that could occur if you first remove the alias from one distribution and then separately add the alias to another distribution.
 *
 * To use this operation to associate an alias with a distribution, you provide the alias and the ID of the target distribution for the alias. For more information, including how to set up the target distribution, prerequisites that you must complete, and other restrictions, see [Moving an alternate domain name to a different distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.associateAlias(crossinline block: AssociateAliasRequest.Builder.() -> Unit): AssociateAliasResponse = associateAlias(AssociateAliasRequest.Builder().apply(block).build())

/**
 * Creates a staging distribution using the configuration of the provided primary distribution. A staging distribution is a copy of an existing distribution (called the primary distribution) that you can use in a continuous deployment workflow.
 *
 * After you create a staging distribution, you can use `UpdateDistribution` to modify the staging distribution's configuration. Then you can use `CreateContinuousDeploymentPolicy` to incrementally move traffic to the staging distribution.
 *
 * This API operation requires the following IAM permissions:
 * + [GetDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html)
 * + [CreateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html)
 * + [CopyDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CopyDistribution.html)
 */
public suspend inline fun CloudFrontClient.copyDistribution(crossinline block: CopyDistributionRequest.Builder.() -> Unit): CopyDistributionResponse = copyDistribution(CopyDistributionRequest.Builder().apply(block).build())

/**
 * Creates a cache policy.
 *
 * After you create a cache policy, you can attach it to one or more cache behaviors. When it's attached to a cache behavior, the cache policy determines the following:
 * + The values that CloudFront includes in the *cache key*. These values can include HTTP headers, cookies, and URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
 * + The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront cache.
 *
 * The headers, cookies, and query strings that are included in the cache key are also included in requests that CloudFront sends to the origin. CloudFront sends a request when it can't find an object in its cache that matches the request's cache key. If you want to send values to the origin but *not* include them in the cache key, use `OriginRequestPolicy`.
 *
 * For more information about cache policies, see [Controlling the cache key](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.createCachePolicy(crossinline block: CreateCachePolicyRequest.Builder.() -> Unit): CreateCachePolicyResponse = createCachePolicy(CreateCachePolicyRequest.Builder().apply(block).build())

/**
 * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more information about how to use origin access identities, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.createCloudFrontOriginAccessIdentity(crossinline block: CreateCloudFrontOriginAccessIdentityRequest.Builder.() -> Unit): CreateCloudFrontOriginAccessIdentityResponse = createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest.Builder().apply(block).build())

/**
 * Creates a continuous deployment policy that distributes traffic for a custom domain name to two different CloudFront distributions.
 *
 * To use a continuous deployment policy, first use `CopyDistribution` to create a staging distribution, then use `UpdateDistribution` to modify the staging distribution's configuration.
 *
 * After you create and update a staging distribution, you can use a continuous deployment policy to incrementally move traffic to the staging distribution. This workflow enables you to test changes to a distribution's configuration before moving all of your domain's production traffic to the new configuration.
 */
public suspend inline fun CloudFrontClient.createContinuousDeploymentPolicy(crossinline block: CreateContinuousDeploymentPolicyRequest.Builder.() -> Unit): CreateContinuousDeploymentPolicyResponse = createContinuousDeploymentPolicy(CreateContinuousDeploymentPolicyRequest.Builder().apply(block).build())

/**
 * Creates a CloudFront distribution.
 */
public suspend inline fun CloudFrontClient.createDistribution(crossinline block: CreateDistributionRequest.Builder.() -> Unit): CreateDistributionResponse = createDistribution(CreateDistributionRequest.Builder().apply(block).build())

/**
 * Create a new distribution with tags. This API operation requires the following IAM permissions:
 * + [CreateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html)
 * + [TagResource](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_TagResource.html)
 */
public suspend inline fun CloudFrontClient.createDistributionWithTags(crossinline block: CreateDistributionWithTagsRequest.Builder.() -> Unit): CreateDistributionWithTagsResponse = createDistributionWithTags(CreateDistributionWithTagsRequest.Builder().apply(block).build())

/**
 * Create a new field-level encryption configuration.
 */
public suspend inline fun CloudFrontClient.createFieldLevelEncryptionConfig(crossinline block: CreateFieldLevelEncryptionConfigRequest.Builder.() -> Unit): CreateFieldLevelEncryptionConfigResponse = createFieldLevelEncryptionConfig(CreateFieldLevelEncryptionConfigRequest.Builder().apply(block).build())

/**
 * Create a field-level encryption profile.
 */
public suspend inline fun CloudFrontClient.createFieldLevelEncryptionProfile(crossinline block: CreateFieldLevelEncryptionProfileRequest.Builder.() -> Unit): CreateFieldLevelEncryptionProfileResponse = createFieldLevelEncryptionProfile(CreateFieldLevelEncryptionProfileRequest.Builder().apply(block).build())

/**
 * Creates a CloudFront function.
 *
 * To create a function, you provide the function code and some configuration information about the function. The response contains an Amazon Resource Name (ARN) that uniquely identifies the function.
 *
 * When you create a function, it's in the `DEVELOPMENT` stage. In this stage, you can test the function with `TestFunction`, and update it with `UpdateFunction`.
 *
 * When you're ready to use your function with a CloudFront distribution, use `PublishFunction` to copy the function from the `DEVELOPMENT` stage to `LIVE`. When it's live, you can attach the function to a distribution's cache behavior, using the function's ARN.
 */
public suspend inline fun CloudFrontClient.createFunction(crossinline block: CreateFunctionRequest.Builder.() -> Unit): CreateFunctionResponse = createFunction(CreateFunctionRequest.Builder().apply(block).build())

/**
 * Create a new invalidation. For more information, see [Invalidating files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.createInvalidation(crossinline block: CreateInvalidationRequest.Builder.() -> Unit): CreateInvalidationResponse = createInvalidation(CreateInvalidationRequest.Builder().apply(block).build())

/**
 * Creates a key group that you can use with [CloudFront signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
 *
 * To create a key group, you must specify at least one public key for the key group. After you create a key group, you can reference it from one or more cache behaviors. When you reference a key group in a cache behavior, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.createKeyGroup(crossinline block: CreateKeyGroupRequest.Builder.() -> Unit): CreateKeyGroupResponse = createKeyGroup(CreateKeyGroupRequest.Builder().apply(block).build())

/**
 * Specifies the key value store resource to add to your account. In your account, the key value store names must be unique. You can also import key value store data in JSON format from an S3 bucket by providing a valid `ImportSource` that you own.
 */
public suspend inline fun CloudFrontClient.createKeyValueStore(crossinline block: CreateKeyValueStoreRequest.Builder.() -> Unit): CreateKeyValueStoreResponse = createKeyValueStore(CreateKeyValueStoreRequest.Builder().apply(block).build())

/**
 * Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an additional cost.
 *
 * For more information, see [Viewing additional CloudFront distribution metrics](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.createMonitoringSubscription(crossinline block: CreateMonitoringSubscriptionRequest.Builder.() -> Unit): CreateMonitoringSubscriptionResponse = createMonitoringSubscription(CreateMonitoringSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
 *
 * This makes it possible to block public access to the origin, allowing viewers (users) to access the origin's content only through CloudFront.
 *
 * For more information about using a CloudFront origin access control, see [Restricting access to an Amazon Web Services origin](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.createOriginAccessControl(crossinline block: CreateOriginAccessControlRequest.Builder.() -> Unit): CreateOriginAccessControlResponse = createOriginAccessControl(CreateOriginAccessControlRequest.Builder().apply(block).build())

/**
 * Creates an origin request policy.
 *
 * After you create an origin request policy, you can attach it to one or more cache behaviors. When it's attached to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it sends to the origin. Each request that CloudFront sends to the origin includes the following:
 * + The request body and the URL path (without the domain name) from the viewer request.
 * + The headers that CloudFront automatically includes in every origin request, including `Host`, `User-Agent`, and `X-Amz-Cf-Id`.
 * + All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request policy. These can include items from the viewer request and, in the case of headers, additional ones that are added by CloudFront.
 *
 * CloudFront sends a request when it can't find a valid object in its cache that matches the request. If you want to send values to the origin and also include them in the cache key, use `CachePolicy`.
 *
 * For more information about origin request policies, see [Controlling origin requests](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.createOriginRequestPolicy(crossinline block: CreateOriginRequestPolicyRequest.Builder.() -> Unit): CreateOriginRequestPolicyResponse = createOriginRequestPolicy(CreateOriginRequestPolicyRequest.Builder().apply(block).build())

/**
 * Uploads a public key to CloudFront that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
 */
public suspend inline fun CloudFrontClient.createPublicKey(crossinline block: CreatePublicKeyRequest.Builder.() -> Unit): CreatePublicKeyResponse = createPublicKey(CreatePublicKeyRequest.Builder().apply(block).build())

/**
 * Creates a real-time log configuration.
 *
 * After you create a real-time log configuration, you can attach it to one or more cache behaviors to send real-time log data to the specified Amazon Kinesis data stream.
 *
 * For more information about real-time log configurations, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.createRealtimeLogConfig(crossinline block: CreateRealtimeLogConfigRequest.Builder.() -> Unit): CreateRealtimeLogConfigResponse = createRealtimeLogConfig(CreateRealtimeLogConfigRequest.Builder().apply(block).build())

/**
 * Creates a response headers policy.
 *
 * A response headers policy contains information about a set of HTTP headers. To create a response headers policy, you provide some metadata about the policy and a set of configurations that specify the headers.
 *
 * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a CloudFront distribution. When it's attached to a cache behavior, the response headers policy affects the HTTP headers that CloudFront includes in HTTP responses to requests that match the cache behavior. CloudFront adds or removes response headers according to the configuration of the response headers policy.
 *
 * For more information, see [Adding or removing HTTP headers in CloudFront responses](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/modifying-response-headers.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.createResponseHeadersPolicy(crossinline block: CreateResponseHeadersPolicyRequest.Builder.() -> Unit): CreateResponseHeadersPolicyResponse = createResponseHeadersPolicy(CreateResponseHeadersPolicyRequest.Builder().apply(block).build())

/**
 * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, [read the announcement](http://forums.aws.amazon.com/ann.jspa?annID=7356) on the Amazon CloudFront discussion forum.
 */
public suspend inline fun CloudFrontClient.createStreamingDistribution(crossinline block: CreateStreamingDistributionRequest.Builder.() -> Unit): CreateStreamingDistributionResponse = createStreamingDistribution(CreateStreamingDistributionRequest.Builder().apply(block).build())

/**
 * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, [read the announcement](http://forums.aws.amazon.com/ann.jspa?annID=7356) on the Amazon CloudFront discussion forum.
 */
public suspend inline fun CloudFrontClient.createStreamingDistributionWithTags(crossinline block: CreateStreamingDistributionWithTagsRequest.Builder.() -> Unit): CreateStreamingDistributionWithTagsResponse = createStreamingDistributionWithTags(CreateStreamingDistributionWithTagsRequest.Builder().apply(block).build())

/**
 * Deletes a cache policy.
 *
 * You cannot delete a cache policy if it's attached to a cache behavior. First update your distributions to remove the cache policy from all cache behaviors, then delete the cache policy.
 *
 * To delete a cache policy, you must provide the policy's identifier and version. To get these values, you can use `ListCachePolicies` or `GetCachePolicy`.
 */
public suspend inline fun CloudFrontClient.deleteCachePolicy(crossinline block: DeleteCachePolicyRequest.Builder.() -> Unit): DeleteCachePolicyResponse = deleteCachePolicy(DeleteCachePolicyRequest.Builder().apply(block).build())

/**
 * Delete an origin access identity.
 */
public suspend inline fun CloudFrontClient.deleteCloudFrontOriginAccessIdentity(crossinline block: DeleteCloudFrontOriginAccessIdentityRequest.Builder.() -> Unit): DeleteCloudFrontOriginAccessIdentityResponse = deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest.Builder().apply(block).build())

/**
 * Deletes a continuous deployment policy.
 *
 * You cannot delete a continuous deployment policy that's attached to a primary distribution. First update your distribution to remove the continuous deployment policy, then you can delete the policy.
 */
public suspend inline fun CloudFrontClient.deleteContinuousDeploymentPolicy(crossinline block: DeleteContinuousDeploymentPolicyRequest.Builder.() -> Unit): DeleteContinuousDeploymentPolicyResponse = deleteContinuousDeploymentPolicy(DeleteContinuousDeploymentPolicyRequest.Builder().apply(block).build())

/**
 * Delete a distribution.
 */
public suspend inline fun CloudFrontClient.deleteDistribution(crossinline block: DeleteDistributionRequest.Builder.() -> Unit): DeleteDistributionResponse = deleteDistribution(DeleteDistributionRequest.Builder().apply(block).build())

/**
 * Remove a field-level encryption configuration.
 */
public suspend inline fun CloudFrontClient.deleteFieldLevelEncryptionConfig(crossinline block: DeleteFieldLevelEncryptionConfigRequest.Builder.() -> Unit): DeleteFieldLevelEncryptionConfigResponse = deleteFieldLevelEncryptionConfig(DeleteFieldLevelEncryptionConfigRequest.Builder().apply(block).build())

/**
 * Remove a field-level encryption profile.
 */
public suspend inline fun CloudFrontClient.deleteFieldLevelEncryptionProfile(crossinline block: DeleteFieldLevelEncryptionProfileRequest.Builder.() -> Unit): DeleteFieldLevelEncryptionProfileResponse = deleteFieldLevelEncryptionProfile(DeleteFieldLevelEncryptionProfileRequest.Builder().apply(block).build())

/**
 * Deletes a CloudFront function.
 *
 * You cannot delete a function if it's associated with a cache behavior. First, update your distributions to remove the function association from all cache behaviors, then delete the function.
 *
 * To delete a function, you must provide the function's name and version (`ETag` value). To get these values, you can use `ListFunctions` and `DescribeFunction`.
 */
public suspend inline fun CloudFrontClient.deleteFunction(crossinline block: DeleteFunctionRequest.Builder.() -> Unit): DeleteFunctionResponse = deleteFunction(DeleteFunctionRequest.Builder().apply(block).build())

/**
 * Deletes a key group.
 *
 * You cannot delete a key group that is referenced in a cache behavior. First update your distributions to remove the key group from all cache behaviors, then delete the key group.
 *
 * To delete a key group, you must provide the key group's identifier and version. To get these values, use `ListKeyGroups` followed by `GetKeyGroup` or `GetKeyGroupConfig`.
 */
public suspend inline fun CloudFrontClient.deleteKeyGroup(crossinline block: DeleteKeyGroupRequest.Builder.() -> Unit): DeleteKeyGroupResponse = deleteKeyGroup(DeleteKeyGroupRequest.Builder().apply(block).build())

/**
 * Specifies the key value store to delete.
 */
public suspend inline fun CloudFrontClient.deleteKeyValueStore(crossinline block: DeleteKeyValueStoreRequest.Builder.() -> Unit): DeleteKeyValueStoreResponse = deleteKeyValueStore(DeleteKeyValueStoreRequest.Builder().apply(block).build())

/**
 * Disables additional CloudWatch metrics for the specified CloudFront distribution.
 */
public suspend inline fun CloudFrontClient.deleteMonitoringSubscription(crossinline block: DeleteMonitoringSubscriptionRequest.Builder.() -> Unit): DeleteMonitoringSubscriptionResponse = deleteMonitoringSubscription(DeleteMonitoringSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes a CloudFront origin access control.
 *
 * You cannot delete an origin access control if it's in use. First, update all distributions to remove the origin access control from all origins, then delete the origin access control.
 */
public suspend inline fun CloudFrontClient.deleteOriginAccessControl(crossinline block: DeleteOriginAccessControlRequest.Builder.() -> Unit): DeleteOriginAccessControlResponse = deleteOriginAccessControl(DeleteOriginAccessControlRequest.Builder().apply(block).build())

/**
 * Deletes an origin request policy.
 *
 * You cannot delete an origin request policy if it's attached to any cache behaviors. First update your distributions to remove the origin request policy from all cache behaviors, then delete the origin request policy.
 *
 * To delete an origin request policy, you must provide the policy's identifier and version. To get the identifier, you can use `ListOriginRequestPolicies` or `GetOriginRequestPolicy`.
 */
public suspend inline fun CloudFrontClient.deleteOriginRequestPolicy(crossinline block: DeleteOriginRequestPolicyRequest.Builder.() -> Unit): DeleteOriginRequestPolicyResponse = deleteOriginRequestPolicy(DeleteOriginRequestPolicyRequest.Builder().apply(block).build())

/**
 * Remove a public key you previously added to CloudFront.
 */
public suspend inline fun CloudFrontClient.deletePublicKey(crossinline block: DeletePublicKeyRequest.Builder.() -> Unit): DeletePublicKeyResponse = deletePublicKey(DeletePublicKeyRequest.Builder().apply(block).build())

/**
 * Deletes a real-time log configuration.
 *
 * You cannot delete a real-time log configuration if it's attached to a cache behavior. First update your distributions to remove the real-time log configuration from all cache behaviors, then delete the real-time log configuration.
 *
 * To delete a real-time log configuration, you can provide the configuration's name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to delete.
 */
public suspend inline fun CloudFrontClient.deleteRealtimeLogConfig(crossinline block: DeleteRealtimeLogConfigRequest.Builder.() -> Unit): DeleteRealtimeLogConfigResponse = deleteRealtimeLogConfig(DeleteRealtimeLogConfigRequest.Builder().apply(block).build())

/**
 * Deletes a response headers policy.
 *
 * You cannot delete a response headers policy if it's attached to a cache behavior. First update your distributions to remove the response headers policy from all cache behaviors, then delete the response headers policy.
 *
 * To delete a response headers policy, you must provide the policy's identifier and version. To get these values, you can use `ListResponseHeadersPolicies` or `GetResponseHeadersPolicy`.
 */
public suspend inline fun CloudFrontClient.deleteResponseHeadersPolicy(crossinline block: DeleteResponseHeadersPolicyRequest.Builder.() -> Unit): DeleteResponseHeadersPolicyResponse = deleteResponseHeadersPolicy(DeleteResponseHeadersPolicyRequest.Builder().apply(block).build())

/**
 * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following steps.
 *
 * **To delete an RTMP distribution using the CloudFront API**:
 * + Disable the RTMP distribution.
 * + Submit a `GET Streaming Distribution Config` request to get the current configuration and the `Etag` header for the distribution.
 * + Update the XML document that was returned in the response to your `GET Streaming Distribution Config` request to change the value of `Enabled` to `false`.
 * + Submit a `PUT Streaming Distribution Config` request to update the configuration for your distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the HTTP `If-Match` header to the value of the `ETag` header that CloudFront returned when you submitted the `GET Streaming Distribution Config` request in Step 2.
 * + Review the response to the `PUT Streaming Distribution Config` request to confirm that the distribution was successfully disabled.
 * + Submit a `GET Streaming Distribution Config` request to confirm that your changes have propagated. When propagation is complete, the value of `Status` is `Deployed`.
 * + Submit a `DELETE Streaming Distribution` request. Set the value of the HTTP `If-Match` header to the value of the `ETag` header that CloudFront returned when you submitted the `GET Streaming Distribution Config` request in Step 2.
 * + Review the response to your `DELETE Streaming Distribution` request to confirm that the distribution was successfully deleted.
 *
 * For information about deleting a distribution using the CloudFront console, see [Deleting a Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.deleteStreamingDistribution(crossinline block: DeleteStreamingDistributionRequest.Builder.() -> Unit): DeleteStreamingDistributionResponse = deleteStreamingDistribution(DeleteStreamingDistributionRequest.Builder().apply(block).build())

/**
 * Gets configuration information and metadata about a CloudFront function, but not the function's code. To get a function's code, use `GetFunction`.
 *
 * To get configuration information and metadata about a function, you must provide the function's name and stage. To get these values, you can use `ListFunctions`.
 */
public suspend inline fun CloudFrontClient.describeFunction(crossinline block: DescribeFunctionRequest.Builder.() -> Unit): DescribeFunctionResponse = describeFunction(DescribeFunctionRequest.Builder().apply(block).build())

/**
 * Specifies the key value store and its configuration.
 */
public suspend inline fun CloudFrontClient.describeKeyValueStore(crossinline block: DescribeKeyValueStoreRequest.Builder.() -> Unit): DescribeKeyValueStoreResponse = describeKeyValueStore(DescribeKeyValueStoreRequest.Builder().apply(block).build())

/**
 * Gets a cache policy, including the following metadata:
 * + The policy's identifier.
 * + The date and time when the policy was last modified.
 *
 * To get a cache policy, you must provide the policy's identifier. If the cache policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the cache policy is not attached to a cache behavior, you can get the identifier using `ListCachePolicies`.
 */
public suspend inline fun CloudFrontClient.getCachePolicy(crossinline block: GetCachePolicyRequest.Builder.() -> Unit): GetCachePolicyResponse = getCachePolicy(GetCachePolicyRequest.Builder().apply(block).build())

/**
 * Gets a cache policy configuration.
 *
 * To get a cache policy configuration, you must provide the policy's identifier. If the cache policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the cache policy is not attached to a cache behavior, you can get the identifier using `ListCachePolicies`.
 */
public suspend inline fun CloudFrontClient.getCachePolicyConfig(crossinline block: GetCachePolicyConfigRequest.Builder.() -> Unit): GetCachePolicyConfigResponse = getCachePolicyConfig(GetCachePolicyConfigRequest.Builder().apply(block).build())

/**
 * Get the information about an origin access identity.
 */
public suspend inline fun CloudFrontClient.getCloudFrontOriginAccessIdentity(crossinline block: GetCloudFrontOriginAccessIdentityRequest.Builder.() -> Unit): GetCloudFrontOriginAccessIdentityResponse = getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest.Builder().apply(block).build())

/**
 * Get the configuration information about an origin access identity.
 */
public suspend inline fun CloudFrontClient.getCloudFrontOriginAccessIdentityConfig(crossinline block: GetCloudFrontOriginAccessIdentityConfigRequest.Builder.() -> Unit): GetCloudFrontOriginAccessIdentityConfigResponse = getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest.Builder().apply(block).build())

/**
 * Gets a continuous deployment policy, including metadata (the policy's identifier and the date and time when the policy was last modified).
 */
public suspend inline fun CloudFrontClient.getContinuousDeploymentPolicy(crossinline block: GetContinuousDeploymentPolicyRequest.Builder.() -> Unit): GetContinuousDeploymentPolicyResponse = getContinuousDeploymentPolicy(GetContinuousDeploymentPolicyRequest.Builder().apply(block).build())

/**
 * Gets configuration information about a continuous deployment policy.
 */
public suspend inline fun CloudFrontClient.getContinuousDeploymentPolicyConfig(crossinline block: GetContinuousDeploymentPolicyConfigRequest.Builder.() -> Unit): GetContinuousDeploymentPolicyConfigResponse = getContinuousDeploymentPolicyConfig(GetContinuousDeploymentPolicyConfigRequest.Builder().apply(block).build())

/**
 * Get the information about a distribution.
 */
public suspend inline fun CloudFrontClient.getDistribution(crossinline block: GetDistributionRequest.Builder.() -> Unit): GetDistributionResponse = getDistribution(GetDistributionRequest.Builder().apply(block).build())

/**
 * Get the configuration information about a distribution.
 */
public suspend inline fun CloudFrontClient.getDistributionConfig(crossinline block: GetDistributionConfigRequest.Builder.() -> Unit): GetDistributionConfigResponse = getDistributionConfig(GetDistributionConfigRequest.Builder().apply(block).build())

/**
 * Get the field-level encryption configuration information.
 */
public suspend inline fun CloudFrontClient.getFieldLevelEncryption(crossinline block: GetFieldLevelEncryptionRequest.Builder.() -> Unit): GetFieldLevelEncryptionResponse = getFieldLevelEncryption(GetFieldLevelEncryptionRequest.Builder().apply(block).build())

/**
 * Get the field-level encryption configuration information.
 */
public suspend inline fun CloudFrontClient.getFieldLevelEncryptionConfig(crossinline block: GetFieldLevelEncryptionConfigRequest.Builder.() -> Unit): GetFieldLevelEncryptionConfigResponse = getFieldLevelEncryptionConfig(GetFieldLevelEncryptionConfigRequest.Builder().apply(block).build())

/**
 * Get the field-level encryption profile information.
 */
public suspend inline fun CloudFrontClient.getFieldLevelEncryptionProfile(crossinline block: GetFieldLevelEncryptionProfileRequest.Builder.() -> Unit): GetFieldLevelEncryptionProfileResponse = getFieldLevelEncryptionProfile(GetFieldLevelEncryptionProfileRequest.Builder().apply(block).build())

/**
 * Get the field-level encryption profile configuration information.
 */
public suspend inline fun CloudFrontClient.getFieldLevelEncryptionProfileConfig(crossinline block: GetFieldLevelEncryptionProfileConfigRequest.Builder.() -> Unit): GetFieldLevelEncryptionProfileConfigResponse = getFieldLevelEncryptionProfileConfig(GetFieldLevelEncryptionProfileConfigRequest.Builder().apply(block).build())

/**
 * Gets the code of a CloudFront function. To get configuration information and metadata about a function, use `DescribeFunction`.
 *
 * To get a function's code, you must provide the function's name and stage. To get these values, you can use `ListFunctions`.
 */
public suspend inline fun CloudFrontClient.getFunction(crossinline block: GetFunctionRequest.Builder.() -> Unit): GetFunctionResponse = getFunction(GetFunctionRequest.Builder().apply(block).build())

/**
 * Get the information about an invalidation.
 */
public suspend inline fun CloudFrontClient.getInvalidation(crossinline block: GetInvalidationRequest.Builder.() -> Unit): GetInvalidationResponse = getInvalidation(GetInvalidationRequest.Builder().apply(block).build())

/**
 * Gets a key group, including the date and time when the key group was last modified.
 *
 * To get a key group, you must provide the key group's identifier. If the key group is referenced in a distribution's cache behavior, you can get the key group's identifier using `ListDistributions` or `GetDistribution`. If the key group is not referenced in a cache behavior, you can get the identifier using `ListKeyGroups`.
 */
public suspend inline fun CloudFrontClient.getKeyGroup(crossinline block: GetKeyGroupRequest.Builder.() -> Unit): GetKeyGroupResponse = getKeyGroup(GetKeyGroupRequest.Builder().apply(block).build())

/**
 * Gets a key group configuration.
 *
 * To get a key group configuration, you must provide the key group's identifier. If the key group is referenced in a distribution's cache behavior, you can get the key group's identifier using `ListDistributions` or `GetDistribution`. If the key group is not referenced in a cache behavior, you can get the identifier using `ListKeyGroups`.
 */
public suspend inline fun CloudFrontClient.getKeyGroupConfig(crossinline block: GetKeyGroupConfigRequest.Builder.() -> Unit): GetKeyGroupConfigResponse = getKeyGroupConfig(GetKeyGroupConfigRequest.Builder().apply(block).build())

/**
 * Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront distribution.
 */
public suspend inline fun CloudFrontClient.getMonitoringSubscription(crossinline block: GetMonitoringSubscriptionRequest.Builder.() -> Unit): GetMonitoringSubscriptionResponse = getMonitoringSubscription(GetMonitoringSubscriptionRequest.Builder().apply(block).build())

/**
 * Gets a CloudFront origin access control, including its unique identifier.
 */
public suspend inline fun CloudFrontClient.getOriginAccessControl(crossinline block: GetOriginAccessControlRequest.Builder.() -> Unit): GetOriginAccessControlResponse = getOriginAccessControl(GetOriginAccessControlRequest.Builder().apply(block).build())

/**
 * Gets a CloudFront origin access control configuration.
 */
public suspend inline fun CloudFrontClient.getOriginAccessControlConfig(crossinline block: GetOriginAccessControlConfigRequest.Builder.() -> Unit): GetOriginAccessControlConfigResponse = getOriginAccessControlConfig(GetOriginAccessControlConfigRequest.Builder().apply(block).build())

/**
 * Gets an origin request policy, including the following metadata:
 * + The policy's identifier.
 * + The date and time when the policy was last modified.
 *
 * To get an origin request policy, you must provide the policy's identifier. If the origin request policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the origin request policy is not attached to a cache behavior, you can get the identifier using `ListOriginRequestPolicies`.
 */
public suspend inline fun CloudFrontClient.getOriginRequestPolicy(crossinline block: GetOriginRequestPolicyRequest.Builder.() -> Unit): GetOriginRequestPolicyResponse = getOriginRequestPolicy(GetOriginRequestPolicyRequest.Builder().apply(block).build())

/**
 * Gets an origin request policy configuration.
 *
 * To get an origin request policy configuration, you must provide the policy's identifier. If the origin request policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the origin request policy is not attached to a cache behavior, you can get the identifier using `ListOriginRequestPolicies`.
 */
public suspend inline fun CloudFrontClient.getOriginRequestPolicyConfig(crossinline block: GetOriginRequestPolicyConfigRequest.Builder.() -> Unit): GetOriginRequestPolicyConfigResponse = getOriginRequestPolicyConfig(GetOriginRequestPolicyConfigRequest.Builder().apply(block).build())

/**
 * Gets a public key.
 */
public suspend inline fun CloudFrontClient.getPublicKey(crossinline block: GetPublicKeyRequest.Builder.() -> Unit): GetPublicKeyResponse = getPublicKey(GetPublicKeyRequest.Builder().apply(block).build())

/**
 * Gets a public key configuration.
 */
public suspend inline fun CloudFrontClient.getPublicKeyConfig(crossinline block: GetPublicKeyConfigRequest.Builder.() -> Unit): GetPublicKeyConfigResponse = getPublicKeyConfig(GetPublicKeyConfigRequest.Builder().apply(block).build())

/**
 * Gets a real-time log configuration.
 *
 * To get a real-time log configuration, you can provide the configuration's name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to get.
 */
public suspend inline fun CloudFrontClient.getRealtimeLogConfig(crossinline block: GetRealtimeLogConfigRequest.Builder.() -> Unit): GetRealtimeLogConfigResponse = getRealtimeLogConfig(GetRealtimeLogConfigRequest.Builder().apply(block).build())

/**
 * Gets a response headers policy, including metadata (the policy's identifier and the date and time when the policy was last modified).
 *
 * To get a response headers policy, you must provide the policy's identifier. If the response headers policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the response headers policy is not attached to a cache behavior, you can get the identifier using `ListResponseHeadersPolicies`.
 */
public suspend inline fun CloudFrontClient.getResponseHeadersPolicy(crossinline block: GetResponseHeadersPolicyRequest.Builder.() -> Unit): GetResponseHeadersPolicyResponse = getResponseHeadersPolicy(GetResponseHeadersPolicyRequest.Builder().apply(block).build())

/**
 * Gets a response headers policy configuration.
 *
 * To get a response headers policy configuration, you must provide the policy's identifier. If the response headers policy is attached to a distribution's cache behavior, you can get the policy's identifier using `ListDistributions` or `GetDistribution`. If the response headers policy is not attached to a cache behavior, you can get the identifier using `ListResponseHeadersPolicies`.
 */
public suspend inline fun CloudFrontClient.getResponseHeadersPolicyConfig(crossinline block: GetResponseHeadersPolicyConfigRequest.Builder.() -> Unit): GetResponseHeadersPolicyConfigResponse = getResponseHeadersPolicyConfig(GetResponseHeadersPolicyConfigRequest.Builder().apply(block).build())

/**
 * Gets information about a specified RTMP distribution, including the distribution configuration.
 */
public suspend inline fun CloudFrontClient.getStreamingDistribution(crossinline block: GetStreamingDistributionRequest.Builder.() -> Unit): GetStreamingDistributionResponse = getStreamingDistribution(GetStreamingDistributionRequest.Builder().apply(block).build())

/**
 * Get the configuration information about a streaming distribution.
 */
public suspend inline fun CloudFrontClient.getStreamingDistributionConfig(crossinline block: GetStreamingDistributionConfigRequest.Builder.() -> Unit): GetStreamingDistributionConfigResponse = getStreamingDistributionConfig(GetStreamingDistributionConfigRequest.Builder().apply(block).build())

/**
 * Gets a list of cache policies.
 *
 * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listCachePolicies(crossinline block: ListCachePoliciesRequest.Builder.() -> Unit): ListCachePoliciesResponse = listCachePolicies(ListCachePoliciesRequest.Builder().apply(block).build())

/**
 * Lists origin access identities.
 */
public suspend inline fun CloudFrontClient.listCloudFrontOriginAccessIdentities(crossinline block: ListCloudFrontOriginAccessIdentitiesRequest.Builder.() -> Unit): ListCloudFrontOriginAccessIdentitiesResponse = listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest.Builder().apply(block).build())

/**
 * Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias. In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the distributions and accounts that you own, but helps to protect the information of ones that you don't own.
 *
 * Use this operation to find aliases that are in use in CloudFront that conflict or overlap with the provided alias. For example, if you provide `www.example.com` as input, the returned list can include `www.example.com` and the overlapping wildcard alternate domain name (`*.example.com`), if they exist. If you provide `*.example.com` as input, the returned list can include `*.example.com` and any alternate domain names covered by that wildcard (for example, `www.example.com`, `test.example.com`, `dev.example.com`, and so on), if they exist.
 *
 * To list conflicting aliases, you provide the alias to search and the ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided alias. For more information, including how to set up the distribution and certificate, see [Moving an alternate domain name to a different distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move) in the *Amazon CloudFront Developer Guide*.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listConflictingAliases(crossinline block: ListConflictingAliasesRequest.Builder.() -> Unit): ListConflictingAliasesResponse = listConflictingAliases(ListConflictingAliasesRequest.Builder().apply(block).build())

/**
 * Gets a list of the continuous deployment policies in your Amazon Web Services account.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listContinuousDeploymentPolicies(crossinline block: ListContinuousDeploymentPoliciesRequest.Builder.() -> Unit): ListContinuousDeploymentPoliciesResponse = listContinuousDeploymentPolicies(ListContinuousDeploymentPoliciesRequest.Builder().apply(block).build())

/**
 * List CloudFront distributions.
 */
public suspend inline fun CloudFrontClient.listDistributions(crossinline block: ListDistributionsRequest.Builder.() -> Unit): ListDistributionsResponse = listDistributions(ListDistributionsRequest.Builder().apply(block).build())

/**
 * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified cache policy.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listDistributionsByCachePolicyId(crossinline block: ListDistributionsByCachePolicyIdRequest.Builder.() -> Unit): ListDistributionsByCachePolicyIdResponse = listDistributionsByCachePolicyId(ListDistributionsByCachePolicyIdRequest.Builder().apply(block).build())

/**
 * Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key group.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listDistributionsByKeyGroup(crossinline block: ListDistributionsByKeyGroupRequest.Builder.() -> Unit): ListDistributionsByKeyGroupResponse = listDistributionsByKeyGroup(ListDistributionsByKeyGroupRequest.Builder().apply(block).build())

/**
 * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified origin request policy.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listDistributionsByOriginRequestPolicyId(crossinline block: ListDistributionsByOriginRequestPolicyIdRequest.Builder.() -> Unit): ListDistributionsByOriginRequestPolicyIdResponse = listDistributionsByOriginRequestPolicyId(ListDistributionsByOriginRequestPolicyIdRequest.Builder().apply(block).build())

/**
 * Gets a list of distributions that have a cache behavior that's associated with the specified real-time log configuration.
 *
 * You can specify the real-time log configuration by its name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to list distributions for.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listDistributionsByRealtimeLogConfig(crossinline block: ListDistributionsByRealtimeLogConfigRequest.Builder.() -> Unit): ListDistributionsByRealtimeLogConfigResponse = listDistributionsByRealtimeLogConfig(ListDistributionsByRealtimeLogConfigRequest.Builder().apply(block).build())

/**
 * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified response headers policy.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listDistributionsByResponseHeadersPolicyId(crossinline block: ListDistributionsByResponseHeadersPolicyIdRequest.Builder.() -> Unit): ListDistributionsByResponseHeadersPolicyIdResponse = listDistributionsByResponseHeadersPolicyId(ListDistributionsByResponseHeadersPolicyIdRequest.Builder().apply(block).build())

/**
 * List the distributions that are associated with a specified WAF web ACL.
 */
public suspend inline fun CloudFrontClient.listDistributionsByWebAclId(crossinline block: ListDistributionsByWebAclIdRequest.Builder.() -> Unit): ListDistributionsByWebAclIdResponse = listDistributionsByWebAclId(ListDistributionsByWebAclIdRequest.Builder().apply(block).build())

/**
 * List all field-level encryption configurations that have been created in CloudFront for this account.
 */
public suspend inline fun CloudFrontClient.listFieldLevelEncryptionConfigs(crossinline block: ListFieldLevelEncryptionConfigsRequest.Builder.() -> Unit): ListFieldLevelEncryptionConfigsResponse = listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest.Builder().apply(block).build())

/**
 * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
 */
public suspend inline fun CloudFrontClient.listFieldLevelEncryptionProfiles(crossinline block: ListFieldLevelEncryptionProfilesRequest.Builder.() -> Unit): ListFieldLevelEncryptionProfilesResponse = listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest.Builder().apply(block).build())

/**
 * Gets a list of all CloudFront functions in your Amazon Web Services account.
 *
 * You can optionally apply a filter to return only the functions that are in the specified stage, either `DEVELOPMENT` or `LIVE`.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listFunctions(crossinline block: ListFunctionsRequest.Builder.() -> Unit): ListFunctionsResponse = listFunctions(ListFunctionsRequest.Builder().apply(block).build())

/**
 * Lists invalidation batches.
 */
public suspend inline fun CloudFrontClient.listInvalidations(crossinline block: ListInvalidationsRequest.Builder.() -> Unit): ListInvalidationsResponse = listInvalidations(ListInvalidationsRequest.Builder().apply(block).build())

/**
 * Gets a list of key groups.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listKeyGroups(crossinline block: ListKeyGroupsRequest.Builder.() -> Unit): ListKeyGroupsResponse = listKeyGroups(ListKeyGroupsRequest.Builder().apply(block).build())

/**
 * Specifies the key value stores to list.
 */
public suspend inline fun CloudFrontClient.listKeyValueStores(crossinline block: ListKeyValueStoresRequest.Builder.() -> Unit): ListKeyValueStoresResponse = listKeyValueStores(ListKeyValueStoresRequest.Builder().apply(block).build())

/**
 * Gets the list of CloudFront origin access controls in this Amazon Web Services account.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send another request that specifies the `NextMarker` value from the current response as the `Marker` value in the next request.
 */
public suspend inline fun CloudFrontClient.listOriginAccessControls(crossinline block: ListOriginAccessControlsRequest.Builder.() -> Unit): ListOriginAccessControlsResponse = listOriginAccessControls(ListOriginAccessControlsRequest.Builder().apply(block).build())

/**
 * Gets a list of origin request policies.
 *
 * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listOriginRequestPolicies(crossinline block: ListOriginRequestPoliciesRequest.Builder.() -> Unit): ListOriginRequestPoliciesResponse = listOriginRequestPolicies(ListOriginRequestPoliciesRequest.Builder().apply(block).build())

/**
 * List all public keys that have been added to CloudFront for this account.
 */
public suspend inline fun CloudFrontClient.listPublicKeys(crossinline block: ListPublicKeysRequest.Builder.() -> Unit): ListPublicKeysResponse = listPublicKeys(ListPublicKeysRequest.Builder().apply(block).build())

/**
 * Gets a list of real-time log configurations.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listRealtimeLogConfigs(crossinline block: ListRealtimeLogConfigsRequest.Builder.() -> Unit): ListRealtimeLogConfigsResponse = listRealtimeLogConfigs(ListRealtimeLogConfigsRequest.Builder().apply(block).build())

/**
 * Gets a list of response headers policies.
 *
 * You can optionally apply a filter to get only the managed policies created by Amazon Web Services, or only the custom policies created in your Amazon Web Services account.
 *
 * You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the `NextMarker` value from the current response as the `Marker` value in the subsequent request.
 */
public suspend inline fun CloudFrontClient.listResponseHeadersPolicies(crossinline block: ListResponseHeadersPoliciesRequest.Builder.() -> Unit): ListResponseHeadersPoliciesResponse = listResponseHeadersPolicies(ListResponseHeadersPoliciesRequest.Builder().apply(block).build())

/**
 * List streaming distributions.
 */
public suspend inline fun CloudFrontClient.listStreamingDistributions(crossinline block: ListStreamingDistributionsRequest.Builder.() -> Unit): ListStreamingDistributionsResponse = listStreamingDistributions(ListStreamingDistributionsRequest.Builder().apply(block).build())

/**
 * List tags for a CloudFront resource. For more information, see [Tagging a distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/tagging.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Publishes a CloudFront function by copying the function code from the `DEVELOPMENT` stage to `LIVE`. This automatically updates all cache behaviors that are using this function to use the newly published copy in the `LIVE` stage.
 *
 * When a function is published to the `LIVE` stage, you can attach the function to a distribution's cache behavior, using the function's Amazon Resource Name (ARN).
 *
 * To publish a function, you must provide the function's name and version (`ETag` value). To get these values, you can use `ListFunctions` and `DescribeFunction`.
 */
public suspend inline fun CloudFrontClient.publishFunction(crossinline block: PublishFunctionRequest.Builder.() -> Unit): PublishFunctionResponse = publishFunction(PublishFunctionRequest.Builder().apply(block).build())

/**
 * Add tags to a CloudFront resource. For more information, see [Tagging a distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/tagging.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Tests a CloudFront function.
 *
 * To test a function, you provide an *event object* that represents an HTTP request or response that your CloudFront distribution could receive in production. CloudFront runs the function, passing it the event object that you provided, and returns the function's result (the modified event object) in the response. The response also contains function logs and error messages, if any exist. For more information about testing functions, see [Testing functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function) in the *Amazon CloudFront Developer Guide*.
 *
 * To test a function, you provide the function's name and version (`ETag` value) along with the event object. To get the function's name and version, you can use `ListFunctions` and `DescribeFunction`.
 */
public suspend inline fun CloudFrontClient.testFunction(crossinline block: TestFunctionRequest.Builder.() -> Unit): TestFunctionResponse = testFunction(TestFunctionRequest.Builder().apply(block).build())

/**
 * Remove tags from a CloudFront resource. For more information, see [Tagging a distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/tagging.html) in the *Amazon CloudFront Developer Guide*.
 */
public suspend inline fun CloudFrontClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a cache policy configuration.
 *
 * When you update a cache policy configuration, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update a cache policy configuration:
 * + Use `GetCachePolicyConfig` to get the current configuration.
 * + Locally modify the fields in the cache policy configuration that you want to update.
 * + Call `UpdateCachePolicy` by providing the entire cache policy configuration, including the fields that you modified and those that you didn't.
 */
public suspend inline fun CloudFrontClient.updateCachePolicy(crossinline block: UpdateCachePolicyRequest.Builder.() -> Unit): UpdateCachePolicyResponse = updateCachePolicy(UpdateCachePolicyRequest.Builder().apply(block).build())

/**
 * Update an origin access identity.
 */
public suspend inline fun CloudFrontClient.updateCloudFrontOriginAccessIdentity(crossinline block: UpdateCloudFrontOriginAccessIdentityRequest.Builder.() -> Unit): UpdateCloudFrontOriginAccessIdentityResponse = updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest.Builder().apply(block).build())

/**
 * Updates a continuous deployment policy. You can update a continuous deployment policy to enable or disable it, to change the percentage of traffic that it sends to the staging distribution, or to change the staging distribution that it sends traffic to.
 *
 * When you update a continuous deployment policy configuration, all the fields are updated with the values that are provided in the request. You cannot update some fields independent of others. To update a continuous deployment policy configuration:
 * + Use `GetContinuousDeploymentPolicyConfig` to get the current configuration.
 * + Locally modify the fields in the continuous deployment policy configuration that you want to update.
 * + Use `UpdateContinuousDeploymentPolicy`, providing the entire continuous deployment policy configuration, including the fields that you modified and those that you didn't.
 */
public suspend inline fun CloudFrontClient.updateContinuousDeploymentPolicy(crossinline block: UpdateContinuousDeploymentPolicyRequest.Builder.() -> Unit): UpdateContinuousDeploymentPolicyResponse = updateContinuousDeploymentPolicy(UpdateContinuousDeploymentPolicyRequest.Builder().apply(block).build())

/**
 * Updates the configuration for a CloudFront distribution.
 *
 * The update process includes getting the current distribution configuration, updating it to make your changes, and then submitting an `UpdateDistribution` request to make the updates.
 *
 * **To update a web distribution using the CloudFront API**
 * + Use `GetDistributionConfig` to get the current configuration, including the version identifier (`ETag`).
 * + Update the distribution configuration that was returned in the response. Note the following important requirements and restrictions:
 *    + You must rename the `ETag` field to `IfMatch`, leaving the value unchanged. (Set the value of `IfMatch` to the value of `ETag`, then remove the `ETag` field.)
 *    + You can't change the value of `CallerReference`.
 * + Submit an `UpdateDistribution` request, providing the distribution configuration. The new configuration replaces the existing configuration. The values that you specify in an `UpdateDistribution` request are not merged into your existing configuration. Make sure to include all fields: the ones that you modified and also the ones that you didn't.
 */
public suspend inline fun CloudFrontClient.updateDistribution(crossinline block: UpdateDistributionRequest.Builder.() -> Unit): UpdateDistributionResponse = updateDistribution(UpdateDistributionRequest.Builder().apply(block).build())

/**
 * Copies the staging distribution's configuration to its corresponding primary distribution. The primary distribution retains its `Aliases` (also known as alternate domain names or CNAMEs) and `ContinuousDeploymentPolicyId` value, but otherwise its configuration is overwritten to match the staging distribution.
 *
 * You can use this operation in a continuous deployment workflow after you have tested configuration changes on the staging distribution. After using a continuous deployment policy to move a portion of your domain name's traffic to the staging distribution and verifying that it works as intended, you can use this operation to copy the staging distribution's configuration to the primary distribution. This action will disable the continuous deployment policy and move your domain's traffic back to the primary distribution.
 *
 * This API operation requires the following IAM permissions:
 * + [GetDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html)
 * + [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html)
 */
public suspend inline fun CloudFrontClient.updateDistributionWithStagingConfig(crossinline block: UpdateDistributionWithStagingConfigRequest.Builder.() -> Unit): UpdateDistributionWithStagingConfigResponse = updateDistributionWithStagingConfig(UpdateDistributionWithStagingConfigRequest.Builder().apply(block).build())

/**
 * Update a field-level encryption configuration.
 */
public suspend inline fun CloudFrontClient.updateFieldLevelEncryptionConfig(crossinline block: UpdateFieldLevelEncryptionConfigRequest.Builder.() -> Unit): UpdateFieldLevelEncryptionConfigResponse = updateFieldLevelEncryptionConfig(UpdateFieldLevelEncryptionConfigRequest.Builder().apply(block).build())

/**
 * Update a field-level encryption profile.
 */
public suspend inline fun CloudFrontClient.updateFieldLevelEncryptionProfile(crossinline block: UpdateFieldLevelEncryptionProfileRequest.Builder.() -> Unit): UpdateFieldLevelEncryptionProfileResponse = updateFieldLevelEncryptionProfile(UpdateFieldLevelEncryptionProfileRequest.Builder().apply(block).build())

/**
 * Updates a CloudFront function.
 *
 * You can update a function's code or the comment that describes the function. You cannot update a function's name.
 *
 * To update a function, you provide the function's name and version (`ETag` value) along with the updated function code. To get the name and version, you can use `ListFunctions` and `DescribeFunction`.
 */
public suspend inline fun CloudFrontClient.updateFunction(crossinline block: UpdateFunctionRequest.Builder.() -> Unit): UpdateFunctionResponse = updateFunction(UpdateFunctionRequest.Builder().apply(block).build())

/**
 * Updates a key group.
 *
 * When you update a key group, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update a key group:
 * + Get the current key group with `GetKeyGroup` or `GetKeyGroupConfig`.
 * + Locally modify the fields in the key group that you want to update. For example, add or remove public key IDs.
 * + Call `UpdateKeyGroup` with the entire key group object, including the fields that you modified and those that you didn't.
 */
public suspend inline fun CloudFrontClient.updateKeyGroup(crossinline block: UpdateKeyGroupRequest.Builder.() -> Unit): UpdateKeyGroupResponse = updateKeyGroup(UpdateKeyGroupRequest.Builder().apply(block).build())

/**
 * Specifies the key value store to update.
 */
public suspend inline fun CloudFrontClient.updateKeyValueStore(crossinline block: UpdateKeyValueStoreRequest.Builder.() -> Unit): UpdateKeyValueStoreResponse = updateKeyValueStore(UpdateKeyValueStoreRequest.Builder().apply(block).build())

/**
 * Updates a CloudFront origin access control.
 */
public suspend inline fun CloudFrontClient.updateOriginAccessControl(crossinline block: UpdateOriginAccessControlRequest.Builder.() -> Unit): UpdateOriginAccessControlResponse = updateOriginAccessControl(UpdateOriginAccessControlRequest.Builder().apply(block).build())

/**
 * Updates an origin request policy configuration.
 *
 * When you update an origin request policy configuration, all the fields are updated with the values provided in the request. You cannot update some fields independent of others. To update an origin request policy configuration:
 * + Use `GetOriginRequestPolicyConfig` to get the current configuration.
 * + Locally modify the fields in the origin request policy configuration that you want to update.
 * + Call `UpdateOriginRequestPolicy` by providing the entire origin request policy configuration, including the fields that you modified and those that you didn't.
 */
public suspend inline fun CloudFrontClient.updateOriginRequestPolicy(crossinline block: UpdateOriginRequestPolicyRequest.Builder.() -> Unit): UpdateOriginRequestPolicyResponse = updateOriginRequestPolicy(UpdateOriginRequestPolicyRequest.Builder().apply(block).build())

/**
 * Update public key information. Note that the only value you can change is the comment.
 */
public suspend inline fun CloudFrontClient.updatePublicKey(crossinline block: UpdatePublicKeyRequest.Builder.() -> Unit): UpdatePublicKeyResponse = updatePublicKey(UpdatePublicKeyRequest.Builder().apply(block).build())

/**
 * Updates a real-time log configuration.
 *
 * When you update a real-time log configuration, all the parameters are updated with the values provided in the request. You cannot update some parameters independent of others. To update a real-time log configuration:
 * + Call `GetRealtimeLogConfig` to get the current real-time log configuration.
 * + Locally modify the parameters in the real-time log configuration that you want to update.
 * + Call this API (`UpdateRealtimeLogConfig`) by providing the entire real-time log configuration, including the parameters that you modified and those that you didn't.
 *
 * You cannot update a real-time log configuration's `Name` or `ARN`.
 */
public suspend inline fun CloudFrontClient.updateRealtimeLogConfig(crossinline block: UpdateRealtimeLogConfigRequest.Builder.() -> Unit): UpdateRealtimeLogConfigResponse = updateRealtimeLogConfig(UpdateRealtimeLogConfigRequest.Builder().apply(block).build())

/**
 * Updates a response headers policy.
 *
 * When you update a response headers policy, the entire policy is replaced. You cannot update some policy fields independent of others. To update a response headers policy configuration:
 * + Use `GetResponseHeadersPolicyConfig` to get the current policy's configuration.
 * + Modify the fields in the response headers policy configuration that you want to update.
 * + Call `UpdateResponseHeadersPolicy`, providing the entire response headers policy configuration, including the fields that you modified and those that you didn't.
 */
public suspend inline fun CloudFrontClient.updateResponseHeadersPolicy(crossinline block: UpdateResponseHeadersPolicyRequest.Builder.() -> Unit): UpdateResponseHeadersPolicyResponse = updateResponseHeadersPolicy(UpdateResponseHeadersPolicyRequest.Builder().apply(block).build())

/**
 * Update a streaming distribution.
 */
public suspend inline fun CloudFrontClient.updateStreamingDistribution(crossinline block: UpdateStreamingDistributionRequest.Builder.() -> Unit): UpdateStreamingDistributionResponse = updateStreamingDistribution(UpdateStreamingDistributionRequest.Builder().apply(block).build())
