// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CachePolicy
import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.UpdateCachePolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateCachePolicyOperationDeserializer: HttpDeserializer.NonStreaming<UpdateCachePolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateCachePolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateCachePolicyError(context, call, payload)
        }
        val builder = UpdateCachePolicyResponse.Builder()

        builder.eTag = response.headers["ETag"]

        if (payload != null) {
            builder.cachePolicy = deserializeCachePolicyPayload(payload)
        }

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateCachePolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedCall, payload)
        "PreconditionFailed" -> PreconditionFailedDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidIfMatchVersion" -> InvalidIfMatchVersionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyCookiesInCachePolicy" -> TooManyCookiesInCachePolicyDeserializer().deserialize(context, wrappedCall, payload)
        "IllegalUpdate" -> IllegalUpdateDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyHeadersInCachePolicy" -> TooManyHeadersInCachePolicyDeserializer().deserialize(context, wrappedCall, payload)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchCachePolicy" -> NoSuchCachePolicyDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyQueryStringsInCachePolicy" -> TooManyQueryStringsInCachePolicyDeserializer().deserialize(context, wrappedCall, payload)
        "CachePolicyAlreadyExists" -> CachePolicyAlreadyExistsDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
