// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.FunctionConfig
import aws.sdk.kotlin.services.cloudfront.model.FunctionRuntime
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeFunctionConfigDocument(reader: XmlTagReader): FunctionConfig {
    val builder = FunctionConfig.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Comment com.amazonaws.cloudfront#FunctionConfig$Comment
            "Comment" -> builder.comment = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // Runtime com.amazonaws.cloudfront#FunctionConfig$Runtime
            "Runtime" -> builder.runtime = curr.tryData()
                .parse { FunctionRuntime.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#FunctionRuntime`)" }
            // KeyValueStoreAssociations com.amazonaws.cloudfront#FunctionConfig$KeyValueStoreAssociations
            "KeyValueStoreAssociations" -> builder.keyValueStoreAssociations = deserializeKeyValueStoreAssociationsDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
