// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.DistributionConfig
import aws.sdk.kotlin.services.cloudfront.model.HttpVersion
import aws.sdk.kotlin.services.cloudfront.model.PriceClass
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeDistributionConfigDocument(reader: XmlTagReader): DistributionConfig {
    val builder = DistributionConfig.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // CallerReference com.amazonaws.cloudfront#DistributionConfig$CallerReference
            "CallerReference" -> builder.callerReference = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // Aliases com.amazonaws.cloudfront#DistributionConfig$Aliases
            "Aliases" -> builder.aliases = deserializeAliasesDocument(curr)
            // DefaultRootObject com.amazonaws.cloudfront#DistributionConfig$DefaultRootObject
            "DefaultRootObject" -> builder.defaultRootObject = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // Origins com.amazonaws.cloudfront#DistributionConfig$Origins
            "Origins" -> builder.origins = deserializeOriginsDocument(curr)
            // OriginGroups com.amazonaws.cloudfront#DistributionConfig$OriginGroups
            "OriginGroups" -> builder.originGroups = deserializeOriginGroupsDocument(curr)
            // DefaultCacheBehavior com.amazonaws.cloudfront#DistributionConfig$DefaultCacheBehavior
            "DefaultCacheBehavior" -> builder.defaultCacheBehavior = deserializeDefaultCacheBehaviorDocument(curr)
            // CacheBehaviors com.amazonaws.cloudfront#DistributionConfig$CacheBehaviors
            "CacheBehaviors" -> builder.cacheBehaviors = deserializeCacheBehaviorsDocument(curr)
            // CustomErrorResponses com.amazonaws.cloudfront#DistributionConfig$CustomErrorResponses
            "CustomErrorResponses" -> builder.customErrorResponses = deserializeCustomErrorResponsesDocument(curr)
            // Comment com.amazonaws.cloudfront#DistributionConfig$Comment
            "Comment" -> builder.comment = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#CommentType`)" }
            // Logging com.amazonaws.cloudfront#DistributionConfig$Logging
            "Logging" -> builder.logging = deserializeLoggingConfigDocument(curr)
            // PriceClass com.amazonaws.cloudfront#DistributionConfig$PriceClass
            "PriceClass" -> builder.priceClass = curr.tryData()
                .parse { PriceClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#PriceClass`)" }
            // Enabled com.amazonaws.cloudfront#DistributionConfig$Enabled
            "Enabled" -> builder.enabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            // ViewerCertificate com.amazonaws.cloudfront#DistributionConfig$ViewerCertificate
            "ViewerCertificate" -> builder.viewerCertificate = deserializeViewerCertificateDocument(curr)
            // Restrictions com.amazonaws.cloudfront#DistributionConfig$Restrictions
            "Restrictions" -> builder.restrictions = deserializeRestrictionsDocument(curr)
            // WebACLId com.amazonaws.cloudfront#DistributionConfig$WebACLId
            "WebACLId" -> builder.webAclId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // HttpVersion com.amazonaws.cloudfront#DistributionConfig$HttpVersion
            "HttpVersion" -> builder.httpVersion = curr.tryData()
                .parse { HttpVersion.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#HttpVersion`)" }
            // IsIPV6Enabled com.amazonaws.cloudfront#DistributionConfig$IsIPV6Enabled
            "IsIPV6Enabled" -> builder.isIpv6Enabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            // ContinuousDeploymentPolicyId com.amazonaws.cloudfront#DistributionConfig$ContinuousDeploymentPolicyId
            "ContinuousDeploymentPolicyId" -> builder.continuousDeploymentPolicyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // Staging com.amazonaws.cloudfront#DistributionConfig$Staging
            "Staging" -> builder.staging = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
