// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteFieldLevelEncryptionConfigOperationDeserializer: HttpDeserializer.NonStreaming<DeleteFieldLevelEncryptionConfigResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteFieldLevelEncryptionConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteFieldLevelEncryptionConfigError(context, call, payload)
        }
        val builder = DeleteFieldLevelEncryptionConfigResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteFieldLevelEncryptionConfigError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedCall, payload)
        "FieldLevelEncryptionConfigInUse" -> FieldLevelEncryptionConfigInUseDeserializer().deserialize(context, wrappedCall, payload)
        "PreconditionFailed" -> PreconditionFailedDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidIfMatchVersion" -> InvalidIfMatchVersionDeserializer().deserialize(context, wrappedCall, payload)
        "NoSuchFieldLevelEncryptionConfig" -> NoSuchFieldLevelEncryptionConfigDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
