// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.CacheBehavior
import aws.sdk.kotlin.services.cloudfront.model.ViewerProtocolPolicy
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeCacheBehaviorDocument(reader: XmlTagReader): CacheBehavior {
    val builder = CacheBehavior.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // PathPattern com.amazonaws.cloudfront#CacheBehavior$PathPattern
            "PathPattern" -> builder.pathPattern = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // TargetOriginId com.amazonaws.cloudfront#CacheBehavior$TargetOriginId
            "TargetOriginId" -> builder.targetOriginId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // TrustedSigners com.amazonaws.cloudfront#CacheBehavior$TrustedSigners
            "TrustedSigners" -> builder.trustedSigners = deserializeTrustedSignersDocument(curr)
            // TrustedKeyGroups com.amazonaws.cloudfront#CacheBehavior$TrustedKeyGroups
            "TrustedKeyGroups" -> builder.trustedKeyGroups = deserializeTrustedKeyGroupsDocument(curr)
            // ViewerProtocolPolicy com.amazonaws.cloudfront#CacheBehavior$ViewerProtocolPolicy
            "ViewerProtocolPolicy" -> builder.viewerProtocolPolicy = curr.tryData()
                .parse { ViewerProtocolPolicy.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#ViewerProtocolPolicy`)" }
            // AllowedMethods com.amazonaws.cloudfront#CacheBehavior$AllowedMethods
            "AllowedMethods" -> builder.allowedMethods = deserializeAllowedMethodsDocument(curr)
            // SmoothStreaming com.amazonaws.cloudfront#CacheBehavior$SmoothStreaming
            "SmoothStreaming" -> builder.smoothStreaming = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            // Compress com.amazonaws.cloudfront#CacheBehavior$Compress
            "Compress" -> builder.compress = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            // LambdaFunctionAssociations com.amazonaws.cloudfront#CacheBehavior$LambdaFunctionAssociations
            "LambdaFunctionAssociations" -> builder.lambdaFunctionAssociations = deserializeLambdaFunctionAssociationsDocument(curr)
            // FunctionAssociations com.amazonaws.cloudfront#CacheBehavior$FunctionAssociations
            "FunctionAssociations" -> builder.functionAssociations = deserializeFunctionAssociationsDocument(curr)
            // FieldLevelEncryptionId com.amazonaws.cloudfront#CacheBehavior$FieldLevelEncryptionId
            "FieldLevelEncryptionId" -> builder.fieldLevelEncryptionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // RealtimeLogConfigArn com.amazonaws.cloudfront#CacheBehavior$RealtimeLogConfigArn
            "RealtimeLogConfigArn" -> builder.realtimeLogConfigArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // CachePolicyId com.amazonaws.cloudfront#CacheBehavior$CachePolicyId
            "CachePolicyId" -> builder.cachePolicyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // OriginRequestPolicyId com.amazonaws.cloudfront#CacheBehavior$OriginRequestPolicyId
            "OriginRequestPolicyId" -> builder.originRequestPolicyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // ResponseHeadersPolicyId com.amazonaws.cloudfront#CacheBehavior$ResponseHeadersPolicyId
            "ResponseHeadersPolicyId" -> builder.responseHeadersPolicyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // ForwardedValues com.amazonaws.cloudfront#CacheBehavior$ForwardedValues
            "ForwardedValues" -> builder.forwardedValues = deserializeForwardedValuesDocument(curr)
            // MinTTL com.amazonaws.cloudfront#CacheBehavior$MinTTL
            "MinTTL" -> builder.minTtl = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.cloudfront#long`)" }
            // DefaultTTL com.amazonaws.cloudfront#CacheBehavior$DefaultTTL
            "DefaultTTL" -> builder.defaultTtl = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.cloudfront#long`)" }
            // MaxTTL com.amazonaws.cloudfront#CacheBehavior$MaxTTL
            "MaxTTL" -> builder.maxTtl = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.cloudfront#long`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
