// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration information about a public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
 */
public class PublicKeyConfig private constructor(builder: Builder) {
    /**
     * A string included in the request to help make sure that the request can't be replayed.
     */
    public val callerReference: kotlin.String = requireNotNull(builder.callerReference) { "A non-null value must be provided for callerReference" }
    /**
     * A comment to describe the public key. The comment cannot be longer than 128 characters.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
     */
    public val encodedKey: kotlin.String = requireNotNull(builder.encodedKey) { "A non-null value must be provided for encodedKey" }
    /**
     * A name to help identify the public key.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.PublicKeyConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PublicKeyConfig(")
        append("callerReference=$callerReference,")
        append("comment=$comment,")
        append("encodedKey=$encodedKey,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = callerReference.hashCode()
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (encodedKey.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PublicKeyConfig

        if (callerReference != other.callerReference) return false
        if (comment != other.comment) return false
        if (encodedKey != other.encodedKey) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.PublicKeyConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string included in the request to help make sure that the request can't be replayed.
         */
        public var callerReference: kotlin.String? = null
        /**
         * A comment to describe the public key. The comment cannot be longer than 128 characters.
         */
        public var comment: kotlin.String? = null
        /**
         * The public key that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
         */
        public var encodedKey: kotlin.String? = null
        /**
         * A name to help identify the public key.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.PublicKeyConfig) : this() {
            this.callerReference = x.callerReference
            this.comment = x.comment
            this.encodedKey = x.encodedKey
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.PublicKeyConfig = PublicKeyConfig(this)

        internal fun correctErrors(): Builder {
            if (callerReference == null) callerReference = ""
            if (encodedKey == null) encodedKey = ""
            if (name == null) name = ""
            return this
        }
    }
}
