// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that determines whether any HTTP headers (and if so, which headers) are included in requests that CloudFront sends to the origin.
 */
public class OriginRequestPolicyHeadersConfig private constructor(builder: Builder) {
    /**
     * Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values are:
     * + `none` – No HTTP headers in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to `none`, any headers that are listed in a `CachePolicy`*are* included in origin requests.
     * + `whitelist` – Only the HTTP headers that are listed in the `Headers` type are included in requests that CloudFront sends to the origin.
     * + `allViewer` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.
     * + `allViewerAndWhitelistCloudFront` – All HTTP headers in viewer requests and the additional CloudFront headers that are listed in the `Headers` type are included in requests that CloudFront sends to the origin. The additional headers are added by CloudFront.
     * + `allExcept` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin, ***except*** for those listed in the `Headers` type, which are not included.
     */
    public val headerBehavior: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeaderBehavior = requireNotNull(builder.headerBehavior) { "A non-null value must be provided for headerBehavior" }
    /**
     * Contains a list of HTTP header names.
     */
    public val headers: aws.sdk.kotlin.services.cloudfront.model.Headers? = builder.headers

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeadersConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OriginRequestPolicyHeadersConfig(")
        append("headerBehavior=$headerBehavior,")
        append("headers=$headers")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = headerBehavior.hashCode()
        result = 31 * result + (headers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OriginRequestPolicyHeadersConfig

        if (headerBehavior != other.headerBehavior) return false
        if (headers != other.headers) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeadersConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values are:
         * + `none` – No HTTP headers in viewer requests are included in requests that CloudFront sends to the origin. Even when this field is set to `none`, any headers that are listed in a `CachePolicy`*are* included in origin requests.
         * + `whitelist` – Only the HTTP headers that are listed in the `Headers` type are included in requests that CloudFront sends to the origin.
         * + `allViewer` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin.
         * + `allViewerAndWhitelistCloudFront` – All HTTP headers in viewer requests and the additional CloudFront headers that are listed in the `Headers` type are included in requests that CloudFront sends to the origin. The additional headers are added by CloudFront.
         * + `allExcept` – All HTTP headers in viewer requests are included in requests that CloudFront sends to the origin, ***except*** for those listed in the `Headers` type, which are not included.
         */
        public var headerBehavior: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeaderBehavior? = null
        /**
         * Contains a list of HTTP header names.
         */
        public var headers: aws.sdk.kotlin.services.cloudfront.model.Headers? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeadersConfig) : this() {
            this.headerBehavior = x.headerBehavior
            this.headers = x.headers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicyHeadersConfig = OriginRequestPolicyHeadersConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Headers] inside the given [block]
         */
        public fun headers(block: aws.sdk.kotlin.services.cloudfront.model.Headers.Builder.() -> kotlin.Unit) {
            this.headers = aws.sdk.kotlin.services.cloudfront.model.Headers.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (headerBehavior == null) headerBehavior = OriginRequestPolicyHeaderBehavior.SdkUnknown("no value provided")
            return this
        }
    }
}
