// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the information about a CloudFront distribution.
 */
public class DistributionSummary private constructor(builder: Builder) {
    /**
     * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions.
     *
     * For more information about ICP recordals, see [ Signup, Accounts, and Credentials](https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html) in *Getting Started with Amazon Web Services services in China*.
     */
    public val aliasIcpRecordals: List<AliasIcpRecordal>? = builder.aliasIcpRecordals
    /**
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
     */
    public val aliases: aws.sdk.kotlin.services.cloudfront.model.Aliases? = builder.aliases
    /**
     * The ARN (Amazon Resource Name) for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your Amazon Web Services account ID.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * A complex type that contains zero or more `CacheBehavior` elements.
     */
    public val cacheBehaviors: aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors? = builder.cacheBehaviors
    /**
     * The comment originally specified when this distribution was created.
     */
    public val comment: kotlin.String = requireNotNull(builder.comment) { "A non-null value must be provided for comment" }
    /**
     * A complex type that contains zero or more `CustomErrorResponses` elements.
     */
    public val customErrorResponses: aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses? = builder.customErrorResponses
    /**
     * A complex type that describes the default cache behavior if you don't specify a `CacheBehavior` element or if files don't match any of the values of `PathPattern` in `CacheBehavior` elements. You must create exactly one default cache behavior.
     */
    public val defaultCacheBehavior: aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior? = builder.defaultCacheBehavior
    /**
     * The domain name that corresponds to the distribution, for example, `d111111abcdef8.cloudfront.net`.
     */
    public val domainName: kotlin.String = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * Whether the distribution is enabled to accept user requests for content.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default value for new web distributions is `http2`. Viewers that don't support `HTTP/2` will automatically use an earlier version.
     */
    public val httpVersion: aws.sdk.kotlin.services.cloudfront.model.HttpVersion = requireNotNull(builder.httpVersion) { "A non-null value must be provided for httpVersion" }
    /**
     * The identifier for the distribution. For example: `EDFDVBD632BHDS5`.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
     */
    public val isIpv6Enabled: kotlin.Boolean = requireNotNull(builder.isIpv6Enabled) { "A non-null value must be provided for isIpv6Enabled" }
    /**
     * The date and time the distribution was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * A complex type that contains information about origin groups for this distribution.
     */
    public val originGroups: aws.sdk.kotlin.services.cloudfront.model.OriginGroups? = builder.originGroups
    /**
     * A complex type that contains information about origins for this distribution.
     */
    public val origins: aws.sdk.kotlin.services.cloudfront.model.Origins? = builder.origins
    /**
     * A complex type that contains information about price class for this streaming distribution.
     */
    public val priceClass: aws.sdk.kotlin.services.cloudfront.model.PriceClass = requireNotNull(builder.priceClass) { "A non-null value must be provided for priceClass" }
    /**
     * A complex type that identifies ways in which you want to restrict distribution of your content.
     */
    public val restrictions: aws.sdk.kotlin.services.cloudfront.model.Restrictions? = builder.restrictions
    /**
     * A Boolean that indicates whether this is a staging distribution. When this value is `true`, this is a staging distribution. When this value is `false`, this is not a staging distribution.
     */
    public val staging: kotlin.Boolean = requireNotNull(builder.staging) { "A non-null value must be provided for staging" }
    /**
     * The current status of the distribution. When the status is `Deployed`, the distribution's information is propagated to all CloudFront edge locations.
     */
    public val status: kotlin.String = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
     */
    public val viewerCertificate: aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate? = builder.viewerCertificate
    /**
     * The Web ACL Id (if any) associated with the distribution.
     */
    public val webAclId: kotlin.String = requireNotNull(builder.webAclId) { "A non-null value must be provided for webAclId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.DistributionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DistributionSummary(")
        append("aliasIcpRecordals=$aliasIcpRecordals,")
        append("aliases=$aliases,")
        append("arn=$arn,")
        append("cacheBehaviors=$cacheBehaviors,")
        append("comment=$comment,")
        append("customErrorResponses=$customErrorResponses,")
        append("defaultCacheBehavior=$defaultCacheBehavior,")
        append("domainName=$domainName,")
        append("enabled=$enabled,")
        append("httpVersion=$httpVersion,")
        append("id=$id,")
        append("isIpv6Enabled=$isIpv6Enabled,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("originGroups=$originGroups,")
        append("origins=$origins,")
        append("priceClass=$priceClass,")
        append("restrictions=$restrictions,")
        append("staging=$staging,")
        append("status=$status,")
        append("viewerCertificate=$viewerCertificate,")
        append("webAclId=$webAclId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliasIcpRecordals?.hashCode() ?: 0
        result = 31 * result + (aliases?.hashCode() ?: 0)
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (cacheBehaviors?.hashCode() ?: 0)
        result = 31 * result + (comment.hashCode())
        result = 31 * result + (customErrorResponses?.hashCode() ?: 0)
        result = 31 * result + (defaultCacheBehavior?.hashCode() ?: 0)
        result = 31 * result + (domainName.hashCode())
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (httpVersion.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (isIpv6Enabled.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (originGroups?.hashCode() ?: 0)
        result = 31 * result + (origins?.hashCode() ?: 0)
        result = 31 * result + (priceClass.hashCode())
        result = 31 * result + (restrictions?.hashCode() ?: 0)
        result = 31 * result + (staging.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (viewerCertificate?.hashCode() ?: 0)
        result = 31 * result + (webAclId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DistributionSummary

        if (aliasIcpRecordals != other.aliasIcpRecordals) return false
        if (aliases != other.aliases) return false
        if (arn != other.arn) return false
        if (cacheBehaviors != other.cacheBehaviors) return false
        if (comment != other.comment) return false
        if (customErrorResponses != other.customErrorResponses) return false
        if (defaultCacheBehavior != other.defaultCacheBehavior) return false
        if (domainName != other.domainName) return false
        if (enabled != other.enabled) return false
        if (httpVersion != other.httpVersion) return false
        if (id != other.id) return false
        if (isIpv6Enabled != other.isIpv6Enabled) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (originGroups != other.originGroups) return false
        if (origins != other.origins) return false
        if (priceClass != other.priceClass) return false
        if (restrictions != other.restrictions) return false
        if (staging != other.staging) return false
        if (status != other.status) return false
        if (viewerCertificate != other.viewerCertificate) return false
        if (webAclId != other.webAclId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.DistributionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Web Services services in China customers must file for an Internet Content Provider (ICP) recordal if they want to serve content publicly on an alternate domain name, also known as a CNAME, that they've added to CloudFront. AliasICPRecordal provides the ICP recordal status for CNAMEs associated with distributions.
         *
         * For more information about ICP recordals, see [ Signup, Accounts, and Credentials](https://docs.amazonaws.cn/en_us/aws/latest/userguide/accounts-and-credentials.html) in *Getting Started with Amazon Web Services services in China*.
         */
        public var aliasIcpRecordals: List<AliasIcpRecordal>? = null
        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
         */
        public var aliases: aws.sdk.kotlin.services.cloudfront.model.Aliases? = null
        /**
         * The ARN (Amazon Resource Name) for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your Amazon Web Services account ID.
         */
        public var arn: kotlin.String? = null
        /**
         * A complex type that contains zero or more `CacheBehavior` elements.
         */
        public var cacheBehaviors: aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors? = null
        /**
         * The comment originally specified when this distribution was created.
         */
        public var comment: kotlin.String? = null
        /**
         * A complex type that contains zero or more `CustomErrorResponses` elements.
         */
        public var customErrorResponses: aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses? = null
        /**
         * A complex type that describes the default cache behavior if you don't specify a `CacheBehavior` element or if files don't match any of the values of `PathPattern` in `CacheBehavior` elements. You must create exactly one default cache behavior.
         */
        public var defaultCacheBehavior: aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior? = null
        /**
         * The domain name that corresponds to the distribution, for example, `d111111abcdef8.cloudfront.net`.
         */
        public var domainName: kotlin.String? = null
        /**
         * Whether the distribution is enabled to accept user requests for content.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default value for new web distributions is `http2`. Viewers that don't support `HTTP/2` will automatically use an earlier version.
         */
        public var httpVersion: aws.sdk.kotlin.services.cloudfront.model.HttpVersion? = null
        /**
         * The identifier for the distribution. For example: `EDFDVBD632BHDS5`.
         */
        public var id: kotlin.String? = null
        /**
         * Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
         */
        public var isIpv6Enabled: kotlin.Boolean? = null
        /**
         * The date and time the distribution was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A complex type that contains information about origin groups for this distribution.
         */
        public var originGroups: aws.sdk.kotlin.services.cloudfront.model.OriginGroups? = null
        /**
         * A complex type that contains information about origins for this distribution.
         */
        public var origins: aws.sdk.kotlin.services.cloudfront.model.Origins? = null
        /**
         * A complex type that contains information about price class for this streaming distribution.
         */
        public var priceClass: aws.sdk.kotlin.services.cloudfront.model.PriceClass? = null
        /**
         * A complex type that identifies ways in which you want to restrict distribution of your content.
         */
        public var restrictions: aws.sdk.kotlin.services.cloudfront.model.Restrictions? = null
        /**
         * A Boolean that indicates whether this is a staging distribution. When this value is `true`, this is a staging distribution. When this value is `false`, this is not a staging distribution.
         */
        public var staging: kotlin.Boolean? = null
        /**
         * The current status of the distribution. When the status is `Deployed`, the distribution's information is propagated to all CloudFront edge locations.
         */
        public var status: kotlin.String? = null
        /**
         * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
         */
        public var viewerCertificate: aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate? = null
        /**
         * The Web ACL Id (if any) associated with the distribution.
         */
        public var webAclId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.DistributionSummary) : this() {
            this.aliasIcpRecordals = x.aliasIcpRecordals
            this.aliases = x.aliases
            this.arn = x.arn
            this.cacheBehaviors = x.cacheBehaviors
            this.comment = x.comment
            this.customErrorResponses = x.customErrorResponses
            this.defaultCacheBehavior = x.defaultCacheBehavior
            this.domainName = x.domainName
            this.enabled = x.enabled
            this.httpVersion = x.httpVersion
            this.id = x.id
            this.isIpv6Enabled = x.isIpv6Enabled
            this.lastModifiedTime = x.lastModifiedTime
            this.originGroups = x.originGroups
            this.origins = x.origins
            this.priceClass = x.priceClass
            this.restrictions = x.restrictions
            this.staging = x.staging
            this.status = x.status
            this.viewerCertificate = x.viewerCertificate
            this.webAclId = x.webAclId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.DistributionSummary = DistributionSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Aliases] inside the given [block]
         */
        public fun aliases(block: aws.sdk.kotlin.services.cloudfront.model.Aliases.Builder.() -> kotlin.Unit) {
            this.aliases = aws.sdk.kotlin.services.cloudfront.model.Aliases.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors] inside the given [block]
         */
        public fun cacheBehaviors(block: aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors.Builder.() -> kotlin.Unit) {
            this.cacheBehaviors = aws.sdk.kotlin.services.cloudfront.model.CacheBehaviors.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses] inside the given [block]
         */
        public fun customErrorResponses(block: aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses.Builder.() -> kotlin.Unit) {
            this.customErrorResponses = aws.sdk.kotlin.services.cloudfront.model.CustomErrorResponses.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior] inside the given [block]
         */
        public fun defaultCacheBehavior(block: aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior.Builder.() -> kotlin.Unit) {
            this.defaultCacheBehavior = aws.sdk.kotlin.services.cloudfront.model.DefaultCacheBehavior.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.OriginGroups] inside the given [block]
         */
        public fun originGroups(block: aws.sdk.kotlin.services.cloudfront.model.OriginGroups.Builder.() -> kotlin.Unit) {
            this.originGroups = aws.sdk.kotlin.services.cloudfront.model.OriginGroups.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Origins] inside the given [block]
         */
        public fun origins(block: aws.sdk.kotlin.services.cloudfront.model.Origins.Builder.() -> kotlin.Unit) {
            this.origins = aws.sdk.kotlin.services.cloudfront.model.Origins.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.Restrictions] inside the given [block]
         */
        public fun restrictions(block: aws.sdk.kotlin.services.cloudfront.model.Restrictions.Builder.() -> kotlin.Unit) {
            this.restrictions = aws.sdk.kotlin.services.cloudfront.model.Restrictions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate] inside the given [block]
         */
        public fun viewerCertificate(block: aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate.Builder.() -> kotlin.Unit) {
            this.viewerCertificate = aws.sdk.kotlin.services.cloudfront.model.ViewerCertificate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (comment == null) comment = ""
            if (domainName == null) domainName = ""
            if (enabled == null) enabled = false
            if (httpVersion == null) httpVersion = HttpVersion.SdkUnknown("no value provided")
            if (id == null) id = ""
            if (isIpv6Enabled == null) isIpv6Enabled = false
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (priceClass == null) priceClass = PriceClass.SdkUnknown("no value provided")
            if (staging == null) staging = false
            if (status == null) status = ""
            if (webAclId == null) webAclId = ""
            return this
        }
    }
}
