// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the configuration for a continuous deployment policy.
 */
public class ContinuousDeploymentPolicyConfig private constructor(builder: Builder) {
    /**
     * A Boolean that indicates whether this continuous deployment policy is enabled (in effect). When this value is `true`, this policy is enabled and in effect. When this value is `false`, this policy is not enabled and has no effect.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * The CloudFront domain name of the staging distribution. For example: `d111111abcdef8.cloudfront.net`.
     */
    public val stagingDistributionDnsNames: aws.sdk.kotlin.services.cloudfront.model.StagingDistributionDnsNames? = builder.stagingDistributionDnsNames
    /**
     * Contains the parameters for routing production traffic from your primary to staging distributions.
     */
    public val trafficConfig: aws.sdk.kotlin.services.cloudfront.model.TrafficConfig? = builder.trafficConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ContinuousDeploymentPolicyConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContinuousDeploymentPolicyConfig(")
        append("enabled=$enabled,")
        append("stagingDistributionDnsNames=$stagingDistributionDnsNames,")
        append("trafficConfig=$trafficConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (stagingDistributionDnsNames?.hashCode() ?: 0)
        result = 31 * result + (trafficConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContinuousDeploymentPolicyConfig

        if (enabled != other.enabled) return false
        if (stagingDistributionDnsNames != other.stagingDistributionDnsNames) return false
        if (trafficConfig != other.trafficConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ContinuousDeploymentPolicyConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A Boolean that indicates whether this continuous deployment policy is enabled (in effect). When this value is `true`, this policy is enabled and in effect. When this value is `false`, this policy is not enabled and has no effect.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The CloudFront domain name of the staging distribution. For example: `d111111abcdef8.cloudfront.net`.
         */
        public var stagingDistributionDnsNames: aws.sdk.kotlin.services.cloudfront.model.StagingDistributionDnsNames? = null
        /**
         * Contains the parameters for routing production traffic from your primary to staging distributions.
         */
        public var trafficConfig: aws.sdk.kotlin.services.cloudfront.model.TrafficConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ContinuousDeploymentPolicyConfig) : this() {
            this.enabled = x.enabled
            this.stagingDistributionDnsNames = x.stagingDistributionDnsNames
            this.trafficConfig = x.trafficConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ContinuousDeploymentPolicyConfig = ContinuousDeploymentPolicyConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.StagingDistributionDnsNames] inside the given [block]
         */
        public fun stagingDistributionDnsNames(block: aws.sdk.kotlin.services.cloudfront.model.StagingDistributionDnsNames.Builder.() -> kotlin.Unit) {
            this.stagingDistributionDnsNames = aws.sdk.kotlin.services.cloudfront.model.StagingDistributionDnsNames.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.TrafficConfig] inside the given [block]
         */
        public fun trafficConfig(block: aws.sdk.kotlin.services.cloudfront.model.TrafficConfig.Builder.() -> kotlin.Unit) {
            this.trafficConfig = aws.sdk.kotlin.services.cloudfront.model.TrafficConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            return this
        }
    }
}
