// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex type that describes how CloudFront processes requests.
 *
 * You must create at least as many cache behaviors (including the default cache behavior) as you have origins if you want CloudFront to serve objects from all of the origins. Each cache behavior specifies the one origin from which you want CloudFront to get objects. If you have two origins and only the default cache behavior, the default cache behavior will cause CloudFront to get objects from one of the origins, but the other origin is never used.
 *
 * For the current quota (formerly known as limit) on the number of cache behaviors that you can add to a distribution, see [Quotas](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html) in the *Amazon CloudFront Developer Guide*.
 *
 * If you don't want to specify any cache behaviors, include only an empty `CacheBehaviors` element. Don't specify an empty individual `CacheBehavior` element, because this is invalid. For more information, see [CacheBehaviors](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CacheBehaviors.html).
 *
 * To delete all cache behaviors in an existing distribution, update the distribution configuration and include only an empty `CacheBehaviors` element.
 *
 * To add, change, or remove one or more cache behaviors, update the distribution configuration and specify all of the cache behaviors that you want to include in the updated distribution.
 *
 * For more information about cache behaviors, see [Cache Behavior Settings](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior) in the *Amazon CloudFront Developer Guide*.
 */
public class CacheBehavior private constructor(builder: Builder) {
    /**
     * A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
     * + CloudFront forwards only `GET` and `HEAD` requests.
     * + CloudFront forwards only `GET`, `HEAD`, and `OPTIONS` requests.
     * + CloudFront forwards `GET, HEAD, OPTIONS, PUT, PATCH, POST`, and `DELETE` requests.
     *
     * If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
     */
    public val allowedMethods: aws.sdk.kotlin.services.cloudfront.model.AllowedMethods? = builder.allowedMethods
    /**
     * The unique identifier of the cache policy that is attached to this cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
     *
     * A `CacheBehavior` must include either a `CachePolicyId` or `ForwardedValues`. We recommend that you use a `CachePolicyId`.
     */
    public val cachePolicyId: kotlin.String? = builder.cachePolicyId
    /**
     * Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify true; if not, specify false. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val compress: kotlin.Boolean? = builder.compress
    /**
     * This field is deprecated. We recommend that you use the `DefaultTTL` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
     *
     * The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val defaultTtl: kotlin.Long? = builder.defaultTtl
    /**
     * The value of `ID` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.
     */
    public val fieldLevelEncryptionId: kotlin.String? = builder.fieldLevelEncryptionId
    /**
     * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
     *
     * If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
     *
     * If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
     *
     * A `CacheBehavior` must include either a `CachePolicyId` or `ForwardedValues`. We recommend that you use a `CachePolicyId`.
     *
     * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val forwardedValues: aws.sdk.kotlin.services.cloudfront.model.ForwardedValues? = builder.forwardedValues
    /**
     * A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the `LIVE` stage to associate them with a cache behavior.
     */
    public val functionAssociations: aws.sdk.kotlin.services.cloudfront.model.FunctionAssociations? = builder.functionAssociations
    /**
     * A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
     */
    public val lambdaFunctionAssociations: aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociations? = builder.lambdaFunctionAssociations
    /**
     * This field is deprecated. We recommend that you use the `MaxTTL` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
     *
     * The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val maxTtl: kotlin.Long? = builder.maxTtl
    /**
     * This field is deprecated. We recommend that you use the `MinTTL` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
     *
     * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [ Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the * Amazon CloudFront Developer Guide*.
     *
     * You must specify `0` for `MinTTL` if you configure CloudFront to forward all headers to your origin (under `Headers`, if you specify `1` for `Quantity` and `*` for `Name`).
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val minTtl: kotlin.Long? = builder.minTtl
    /**
     * The unique identifier of the origin request policy that is attached to this cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val originRequestPolicyId: kotlin.String? = builder.originRequestPolicyId
    /**
     * The pattern (for example, `images&#47;*.jpg`) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution.
     *
     * You can optionally include a slash (`/`) at the beginning of the path pattern. For example, `/images&#47;*.jpg`. CloudFront behavior is the same with or without the leading `/`.
     *
     * The path pattern for the default cache behavior is `*` and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.
     *
     * For more information, see [Path Pattern](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern) in the * Amazon CloudFront Developer Guide*.
     */
    public val pathPattern: kotlin.String = requireNotNull(builder.pathPattern) { "A non-null value must be provided for pathPattern" }
    /**
     * The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val realtimeLogConfigArn: kotlin.String? = builder.realtimeLogConfigArn
    /**
     * The identifier for a response headers policy.
     */
    public val responseHeadersPolicyId: kotlin.String? = builder.responseHeadersPolicyId
    /**
     * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify `true`; if not, specify `false`. If you specify `true` for `SmoothStreaming`, you can still distribute other content using this cache behavior if the content matches the value of `PathPattern`.
     */
    public val smoothStreaming: kotlin.Boolean? = builder.smoothStreaming
    /**
     * The value of `ID` for the origin that you want CloudFront to route requests to when they match this cache behavior.
     */
    public val targetOriginId: kotlin.String = requireNotNull(builder.targetOriginId) { "A non-null value must be provided for targetOriginId" }
    /**
     * A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
     *
     * When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val trustedKeyGroups: aws.sdk.kotlin.services.cloudfront.model.TrustedKeyGroups? = builder.trustedKeyGroups
    /**
     * We recommend using `TrustedKeyGroups` instead of `TrustedSigners`.
     *
     * A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
     *
     * When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer's Amazon Web Services account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val trustedSigners: aws.sdk.kotlin.services.cloudfront.model.TrustedSigners? = builder.trustedSigners
    /**
     * The protocol that viewers can use to access the files in the origin specified by `TargetOriginId` when a request matches the path pattern in `PathPattern`. You can specify the following options:
     * + `allow-all`: Viewers can use HTTP or HTTPS.
     * + `redirect-to-https`: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
     * + `https-only`: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
     *
     * For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
     *
     * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
     */
    public val viewerProtocolPolicy: aws.sdk.kotlin.services.cloudfront.model.ViewerProtocolPolicy = requireNotNull(builder.viewerProtocolPolicy) { "A non-null value must be provided for viewerProtocolPolicy" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CacheBehavior = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CacheBehavior(")
        append("allowedMethods=$allowedMethods,")
        append("cachePolicyId=$cachePolicyId,")
        append("compress=$compress,")
        append("defaultTtl=$defaultTtl,")
        append("fieldLevelEncryptionId=$fieldLevelEncryptionId,")
        append("forwardedValues=$forwardedValues,")
        append("functionAssociations=$functionAssociations,")
        append("lambdaFunctionAssociations=$lambdaFunctionAssociations,")
        append("maxTtl=$maxTtl,")
        append("minTtl=$minTtl,")
        append("originRequestPolicyId=$originRequestPolicyId,")
        append("pathPattern=$pathPattern,")
        append("realtimeLogConfigArn=$realtimeLogConfigArn,")
        append("responseHeadersPolicyId=$responseHeadersPolicyId,")
        append("smoothStreaming=$smoothStreaming,")
        append("targetOriginId=$targetOriginId,")
        append("trustedKeyGroups=$trustedKeyGroups,")
        append("trustedSigners=$trustedSigners,")
        append("viewerProtocolPolicy=$viewerProtocolPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedMethods?.hashCode() ?: 0
        result = 31 * result + (cachePolicyId?.hashCode() ?: 0)
        result = 31 * result + (compress?.hashCode() ?: 0)
        result = 31 * result + (defaultTtl?.hashCode() ?: 0)
        result = 31 * result + (fieldLevelEncryptionId?.hashCode() ?: 0)
        result = 31 * result + (forwardedValues?.hashCode() ?: 0)
        result = 31 * result + (functionAssociations?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionAssociations?.hashCode() ?: 0)
        result = 31 * result + (maxTtl?.hashCode() ?: 0)
        result = 31 * result + (minTtl?.hashCode() ?: 0)
        result = 31 * result + (originRequestPolicyId?.hashCode() ?: 0)
        result = 31 * result + (pathPattern.hashCode())
        result = 31 * result + (realtimeLogConfigArn?.hashCode() ?: 0)
        result = 31 * result + (responseHeadersPolicyId?.hashCode() ?: 0)
        result = 31 * result + (smoothStreaming?.hashCode() ?: 0)
        result = 31 * result + (targetOriginId.hashCode())
        result = 31 * result + (trustedKeyGroups?.hashCode() ?: 0)
        result = 31 * result + (trustedSigners?.hashCode() ?: 0)
        result = 31 * result + (viewerProtocolPolicy.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CacheBehavior

        if (allowedMethods != other.allowedMethods) return false
        if (cachePolicyId != other.cachePolicyId) return false
        if (compress != other.compress) return false
        if (defaultTtl != other.defaultTtl) return false
        if (fieldLevelEncryptionId != other.fieldLevelEncryptionId) return false
        if (forwardedValues != other.forwardedValues) return false
        if (functionAssociations != other.functionAssociations) return false
        if (lambdaFunctionAssociations != other.lambdaFunctionAssociations) return false
        if (maxTtl != other.maxTtl) return false
        if (minTtl != other.minTtl) return false
        if (originRequestPolicyId != other.originRequestPolicyId) return false
        if (pathPattern != other.pathPattern) return false
        if (realtimeLogConfigArn != other.realtimeLogConfigArn) return false
        if (responseHeadersPolicyId != other.responseHeadersPolicyId) return false
        if (smoothStreaming != other.smoothStreaming) return false
        if (targetOriginId != other.targetOriginId) return false
        if (trustedKeyGroups != other.trustedKeyGroups) return false
        if (trustedSigners != other.trustedSigners) return false
        if (viewerProtocolPolicy != other.viewerProtocolPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CacheBehavior = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin. There are three choices:
         * + CloudFront forwards only `GET` and `HEAD` requests.
         * + CloudFront forwards only `GET`, `HEAD`, and `OPTIONS` requests.
         * + CloudFront forwards `GET, HEAD, OPTIONS, PUT, PATCH, POST`, and `DELETE` requests.
         *
         * If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
         */
        public var allowedMethods: aws.sdk.kotlin.services.cloudfront.model.AllowedMethods? = null
        /**
         * The unique identifier of the cache policy that is attached to this cache behavior. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         *
         * A `CacheBehavior` must include either a `CachePolicyId` or `ForwardedValues`. We recommend that you use a `CachePolicyId`.
         */
        public var cachePolicyId: kotlin.String? = null
        /**
         * Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify true; if not, specify false. For more information, see [Serving Compressed Files](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var compress: kotlin.Boolean? = null
        /**
         * This field is deprecated. We recommend that you use the `DefaultTTL` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         *
         * The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var defaultTtl: kotlin.Long? = null
        /**
         * The value of `ID` for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.
         */
        public var fieldLevelEncryptionId: kotlin.String? = null
        /**
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see [Working with policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html) in the *Amazon CloudFront Developer Guide*.
         *
         * If you want to include values in the cache key, use a cache policy. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         *
         * If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
         *
         * A `CacheBehavior` must include either a `CachePolicyId` or `ForwardedValues`. We recommend that you use a `CachePolicyId`.
         *
         * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var forwardedValues: aws.sdk.kotlin.services.cloudfront.model.ForwardedValues? = null
        /**
         * A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be published to the `LIVE` stage to associate them with a cache behavior.
         */
        public var functionAssociations: aws.sdk.kotlin.services.cloudfront.model.FunctionAssociations? = null
        /**
         * A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
         */
        public var lambdaFunctionAssociations: aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociations? = null
        /**
         * This field is deprecated. We recommend that you use the `MaxTTL` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         *
         * The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as `Cache-Control max-age`, `Cache-Control s-maxage`, and `Expires` to objects. For more information, see [Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var maxTtl: kotlin.Long? = null
        /**
         * This field is deprecated. We recommend that you use the `MinTTL` field in a cache policy instead of this field. For more information, see [Creating cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy) or [Using the managed cache policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html) in the *Amazon CloudFront Developer Guide*.
         *
         * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see [ Managing How Long Content Stays in an Edge Cache (Expiration)](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the * Amazon CloudFront Developer Guide*.
         *
         * You must specify `0` for `MinTTL` if you configure CloudFront to forward all headers to your origin (under `Headers`, if you specify `1` for `Quantity` and `*` for `Name`).
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var minTtl: kotlin.Long? = null
        /**
         * The unique identifier of the origin request policy that is attached to this cache behavior. For more information, see [Creating origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy) or [Using the managed origin request policies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var originRequestPolicyId: kotlin.String? = null
        /**
         * The pattern (for example, `images&#47;*.jpg`) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution.
         *
         * You can optionally include a slash (`/`) at the beginning of the path pattern. For example, `/images&#47;*.jpg`. CloudFront behavior is the same with or without the leading `/`.
         *
         * The path pattern for the default cache behavior is `*` and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.
         *
         * For more information, see [Path Pattern](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern) in the * Amazon CloudFront Developer Guide*.
         */
        public var pathPattern: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For more information, see [Real-time logs](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var realtimeLogConfigArn: kotlin.String? = null
        /**
         * The identifier for a response headers policy.
         */
        public var responseHeadersPolicyId: kotlin.String? = null
        /**
         * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior. If so, specify `true`; if not, specify `false`. If you specify `true` for `SmoothStreaming`, you can still distribute other content using this cache behavior if the content matches the value of `PathPattern`.
         */
        public var smoothStreaming: kotlin.Boolean? = null
        /**
         * The value of `ID` for the origin that you want CloudFront to route requests to when they match this cache behavior.
         */
        public var targetOriginId: kotlin.String? = null
        /**
         * A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         *
         * When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var trustedKeyGroups: aws.sdk.kotlin.services.cloudfront.model.TrustedKeyGroups? = null
        /**
         * We recommend using `TrustedKeyGroups` instead of `TrustedSigners`.
         *
         * A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
         *
         * When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer's Amazon Web Services account. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see [Serving private content](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var trustedSigners: aws.sdk.kotlin.services.cloudfront.model.TrustedSigners? = null
        /**
         * The protocol that viewers can use to access the files in the origin specified by `TargetOriginId` when a request matches the path pattern in `PathPattern`. You can specify the following options:
         * + `allow-all`: Viewers can use HTTP or HTTPS.
         * + `redirect-to-https`: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.
         * + `https-only`: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).
         *
         * For more information about requiring the HTTPS protocol, see [Requiring HTTPS Between Viewers and CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html) in the *Amazon CloudFront Developer Guide*.
         *
         * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see [Managing Cache Expiration](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html) in the *Amazon CloudFront Developer Guide*.
         */
        public var viewerProtocolPolicy: aws.sdk.kotlin.services.cloudfront.model.ViewerProtocolPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CacheBehavior) : this() {
            this.allowedMethods = x.allowedMethods
            this.cachePolicyId = x.cachePolicyId
            this.compress = x.compress
            this.defaultTtl = x.defaultTtl
            this.fieldLevelEncryptionId = x.fieldLevelEncryptionId
            this.forwardedValues = x.forwardedValues
            this.functionAssociations = x.functionAssociations
            this.lambdaFunctionAssociations = x.lambdaFunctionAssociations
            this.maxTtl = x.maxTtl
            this.minTtl = x.minTtl
            this.originRequestPolicyId = x.originRequestPolicyId
            this.pathPattern = x.pathPattern
            this.realtimeLogConfigArn = x.realtimeLogConfigArn
            this.responseHeadersPolicyId = x.responseHeadersPolicyId
            this.smoothStreaming = x.smoothStreaming
            this.targetOriginId = x.targetOriginId
            this.trustedKeyGroups = x.trustedKeyGroups
            this.trustedSigners = x.trustedSigners
            this.viewerProtocolPolicy = x.viewerProtocolPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CacheBehavior = CacheBehavior(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.AllowedMethods] inside the given [block]
         */
        public fun allowedMethods(block: aws.sdk.kotlin.services.cloudfront.model.AllowedMethods.Builder.() -> kotlin.Unit) {
            this.allowedMethods = aws.sdk.kotlin.services.cloudfront.model.AllowedMethods.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ForwardedValues] inside the given [block]
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public fun forwardedValues(block: aws.sdk.kotlin.services.cloudfront.model.ForwardedValues.Builder.() -> kotlin.Unit) {
            this.forwardedValues = aws.sdk.kotlin.services.cloudfront.model.ForwardedValues.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.FunctionAssociations] inside the given [block]
         */
        public fun functionAssociations(block: aws.sdk.kotlin.services.cloudfront.model.FunctionAssociations.Builder.() -> kotlin.Unit) {
            this.functionAssociations = aws.sdk.kotlin.services.cloudfront.model.FunctionAssociations.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociations] inside the given [block]
         */
        public fun lambdaFunctionAssociations(block: aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociations.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionAssociations = aws.sdk.kotlin.services.cloudfront.model.LambdaFunctionAssociations.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.TrustedKeyGroups] inside the given [block]
         */
        public fun trustedKeyGroups(block: aws.sdk.kotlin.services.cloudfront.model.TrustedKeyGroups.Builder.() -> kotlin.Unit) {
            this.trustedKeyGroups = aws.sdk.kotlin.services.cloudfront.model.TrustedKeyGroups.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.TrustedSigners] inside the given [block]
         */
        public fun trustedSigners(block: aws.sdk.kotlin.services.cloudfront.model.TrustedSigners.Builder.() -> kotlin.Unit) {
            this.trustedSigners = aws.sdk.kotlin.services.cloudfront.model.TrustedSigners.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (pathPattern == null) pathPattern = ""
            if (targetOriginId == null) targetOriginId = ""
            if (viewerProtocolPolicy == null) viewerProtocolPolicy = ViewerProtocolPolicy.SdkUnknown("no value provided")
            return this
        }
    }
}
