// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of Amazon Web Services accounts and the active CloudFront key pairs in each account that CloudFront can use to verify the signatures of signed URLs and signed cookies.
 */
public class ActiveTrustedSigners private constructor(builder: Builder) {
    /**
     * This field is `true` if any of the Amazon Web Services accounts in the list are configured as trusted signers. If not, this field is `false`.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * A list of Amazon Web Services accounts and the identifiers of active CloudFront key pairs in each account that CloudFront can use to verify the signatures of signed URLs and signed cookies.
     */
    public val items: List<Signer>? = builder.items
    /**
     * The number of Amazon Web Services accounts in the list.
     */
    public val quantity: kotlin.Int = requireNotNull(builder.quantity) { "A non-null value must be provided for quantity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActiveTrustedSigners(")
        append("enabled=$enabled,")
        append("items=$items,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (quantity)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActiveTrustedSigners

        if (enabled != other.enabled) return false
        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This field is `true` if any of the Amazon Web Services accounts in the list are configured as trusted signers. If not, this field is `false`.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * A list of Amazon Web Services accounts and the identifiers of active CloudFront key pairs in each account that CloudFront can use to verify the signatures of signed URLs and signed cookies.
         */
        public var items: List<Signer>? = null
        /**
         * The number of Amazon Web Services accounts in the list.
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners) : this() {
            this.enabled = x.enabled
            this.items = x.items
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedSigners = ActiveTrustedSigners(this)

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            if (quantity == null) quantity = 0
            return this
        }
    }
}
