// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of key groups, and the public keys in each key group, that CloudFront can use to verify the signatures of signed URLs and signed cookies.
 */
public class ActiveTrustedKeyGroups private constructor(builder: Builder) {
    /**
     * This field is `true` if any of the key groups have public keys that CloudFront can use to verify the signatures of signed URLs and signed cookies. If not, this field is `false`.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * A list of key groups, including the identifiers of the public keys in each key group that CloudFront can use to verify the signatures of signed URLs and signed cookies.
     */
    public val items: List<KgKeyPairIds>? = builder.items
    /**
     * The number of key groups in the list.
     */
    public val quantity: kotlin.Int = requireNotNull(builder.quantity) { "A non-null value must be provided for quantity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedKeyGroups = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActiveTrustedKeyGroups(")
        append("enabled=$enabled,")
        append("items=$items,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (quantity)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActiveTrustedKeyGroups

        if (enabled != other.enabled) return false
        if (items != other.items) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedKeyGroups = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This field is `true` if any of the key groups have public keys that CloudFront can use to verify the signatures of signed URLs and signed cookies. If not, this field is `false`.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * A list of key groups, including the identifiers of the public keys in each key group that CloudFront can use to verify the signatures of signed URLs and signed cookies.
         */
        public var items: List<KgKeyPairIds>? = null
        /**
         * The number of key groups in the list.
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedKeyGroups) : this() {
            this.enabled = x.enabled
            this.items = x.items
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ActiveTrustedKeyGroups = ActiveTrustedKeyGroups(this)

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            if (quantity == null) quantity = 0
            return this
        }
    }
}
