// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.OriginAccessControlConfig
import aws.sdk.kotlin.services.cloudfront.model.UpdateOriginAccessControlRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateOriginAccessControlOperationSerializer: HttpSerializer.NonStreaming<UpdateOriginAccessControlRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateOriginAccessControlRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.id) { "id is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2020-05-31"))
                add(PercentEncoding.Path.encode("origin-access-control"))
                add(PercentEncoding.SmithyLabel.encode("${input.id}"))
                add(PercentEncoding.Path.encode("config"))
            }
        }

        builder.headers {
            if (input.ifMatch?.isNotEmpty() == true) append("If-Match", input.ifMatch)
        }

        if (input.originAccessControlConfig != null) {
            val payload = serializeOriginAccessControlConfigPayloadWithXmlNameOriginAccessControlConfig(input.originAccessControlConfig)
            builder.body = HttpBody.fromBytes(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}
