// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.serde

import aws.sdk.kotlin.services.cloudfront.model.PriceClass
import aws.sdk.kotlin.services.cloudfront.model.StreamingDistributionConfig
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeStreamingDistributionConfigDocument(reader: XmlTagReader): StreamingDistributionConfig {
    val builder = StreamingDistributionConfig.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // CallerReference com.amazonaws.cloudfront#StreamingDistributionConfig$CallerReference
            "CallerReference" -> builder.callerReference = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // S3Origin com.amazonaws.cloudfront#StreamingDistributionConfig$S3Origin
            "S3Origin" -> builder.s3Origin = deserializeS3OriginDocument(curr)
            // Aliases com.amazonaws.cloudfront#StreamingDistributionConfig$Aliases
            "Aliases" -> builder.aliases = deserializeAliasesDocument(curr)
            // Comment com.amazonaws.cloudfront#StreamingDistributionConfig$Comment
            "Comment" -> builder.comment = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudfront#string`)" }
            // Logging com.amazonaws.cloudfront#StreamingDistributionConfig$Logging
            "Logging" -> builder.logging = deserializeStreamingLoggingConfigDocument(curr)
            // TrustedSigners com.amazonaws.cloudfront#StreamingDistributionConfig$TrustedSigners
            "TrustedSigners" -> builder.trustedSigners = deserializeTrustedSignersDocument(curr)
            // PriceClass com.amazonaws.cloudfront#StreamingDistributionConfig$PriceClass
            "PriceClass" -> builder.priceClass = curr.tryData()
                .parse { PriceClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudfront#PriceClass`)" }
            // Enabled com.amazonaws.cloudfront#StreamingDistributionConfig$Enabled
            "Enabled" -> builder.enabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudfront#boolean`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
