// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS). CloudFront adds these headers to HTTP responses that it sends for CORS requests that match a cache behavior associated with this response headers policy.
 *
 * For more information about CORS, see [Cross-Origin Resource Sharing (CORS)](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS) in the MDN Web Docs.
 */
public class ResponseHeadersPolicyCorsConfig private constructor(builder: Builder) {
    /**
     * A Boolean that CloudFront uses as the value for the `Access-Control-Allow-Credentials` HTTP response header.
     *
     * For more information about the `Access-Control-Allow-Credentials` HTTP response header, see [Access-Control-Allow-Credentials](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials) in the MDN Web Docs.
     */
    public val accessControlAllowCredentials: kotlin.Boolean = requireNotNull(builder.accessControlAllowCredentials) { "A non-null value must be provided for accessControlAllowCredentials" }
    /**
     * A list of HTTP header names that CloudFront includes as values for the `Access-Control-Allow-Headers` HTTP response header.
     *
     * For more information about the `Access-Control-Allow-Headers` HTTP response header, see [Access-Control-Allow-Headers](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
     */
    public val accessControlAllowHeaders: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders? = builder.accessControlAllowHeaders
    /**
     * A list of HTTP methods that CloudFront includes as values for the `Access-Control-Allow-Methods` HTTP response header.
     *
     * For more information about the `Access-Control-Allow-Methods` HTTP response header, see [Access-Control-Allow-Methods](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods) in the MDN Web Docs.
     */
    public val accessControlAllowMethods: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods? = builder.accessControlAllowMethods
    /**
     * A list of origins (domain names) that CloudFront can use as the value for the `Access-Control-Allow-Origin` HTTP response header.
     *
     * For more information about the `Access-Control-Allow-Origin` HTTP response header, see [Access-Control-Allow-Origin](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin) in the MDN Web Docs.
     */
    public val accessControlAllowOrigins: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins? = builder.accessControlAllowOrigins
    /**
     * A list of HTTP headers that CloudFront includes as values for the `Access-Control-Expose-Headers` HTTP response header.
     *
     * For more information about the `Access-Control-Expose-Headers` HTTP response header, see [Access-Control-Expose-Headers](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers) in the MDN Web Docs.
     */
    public val accessControlExposeHeaders: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders? = builder.accessControlExposeHeaders
    /**
     * A number that CloudFront uses as the value for the `Access-Control-Max-Age` HTTP response header.
     *
     * For more information about the `Access-Control-Max-Age` HTTP response header, see [Access-Control-Max-Age](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age) in the MDN Web Docs.
     */
    public val accessControlMaxAgeSec: kotlin.Int? = builder.accessControlMaxAgeSec
    /**
     * A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy.
     */
    public val originOverride: kotlin.Boolean = requireNotNull(builder.originOverride) { "A non-null value must be provided for originOverride" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCorsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResponseHeadersPolicyCorsConfig(")
        append("accessControlAllowCredentials=$accessControlAllowCredentials,")
        append("accessControlAllowHeaders=$accessControlAllowHeaders,")
        append("accessControlAllowMethods=$accessControlAllowMethods,")
        append("accessControlAllowOrigins=$accessControlAllowOrigins,")
        append("accessControlExposeHeaders=$accessControlExposeHeaders,")
        append("accessControlMaxAgeSec=$accessControlMaxAgeSec,")
        append("originOverride=$originOverride")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlAllowCredentials.hashCode()
        result = 31 * result + (accessControlAllowHeaders?.hashCode() ?: 0)
        result = 31 * result + (accessControlAllowMethods?.hashCode() ?: 0)
        result = 31 * result + (accessControlAllowOrigins?.hashCode() ?: 0)
        result = 31 * result + (accessControlExposeHeaders?.hashCode() ?: 0)
        result = 31 * result + (accessControlMaxAgeSec ?: 0)
        result = 31 * result + (originOverride.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResponseHeadersPolicyCorsConfig

        if (accessControlAllowCredentials != other.accessControlAllowCredentials) return false
        if (accessControlAllowHeaders != other.accessControlAllowHeaders) return false
        if (accessControlAllowMethods != other.accessControlAllowMethods) return false
        if (accessControlAllowOrigins != other.accessControlAllowOrigins) return false
        if (accessControlExposeHeaders != other.accessControlExposeHeaders) return false
        if (accessControlMaxAgeSec != other.accessControlMaxAgeSec) return false
        if (originOverride != other.originOverride) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCorsConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A Boolean that CloudFront uses as the value for the `Access-Control-Allow-Credentials` HTTP response header.
         *
         * For more information about the `Access-Control-Allow-Credentials` HTTP response header, see [Access-Control-Allow-Credentials](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials) in the MDN Web Docs.
         */
        public var accessControlAllowCredentials: kotlin.Boolean? = null
        /**
         * A list of HTTP header names that CloudFront includes as values for the `Access-Control-Allow-Headers` HTTP response header.
         *
         * For more information about the `Access-Control-Allow-Headers` HTTP response header, see [Access-Control-Allow-Headers](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Headers) in the MDN Web Docs.
         */
        public var accessControlAllowHeaders: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders? = null
        /**
         * A list of HTTP methods that CloudFront includes as values for the `Access-Control-Allow-Methods` HTTP response header.
         *
         * For more information about the `Access-Control-Allow-Methods` HTTP response header, see [Access-Control-Allow-Methods](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Methods) in the MDN Web Docs.
         */
        public var accessControlAllowMethods: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods? = null
        /**
         * A list of origins (domain names) that CloudFront can use as the value for the `Access-Control-Allow-Origin` HTTP response header.
         *
         * For more information about the `Access-Control-Allow-Origin` HTTP response header, see [Access-Control-Allow-Origin](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin) in the MDN Web Docs.
         */
        public var accessControlAllowOrigins: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins? = null
        /**
         * A list of HTTP headers that CloudFront includes as values for the `Access-Control-Expose-Headers` HTTP response header.
         *
         * For more information about the `Access-Control-Expose-Headers` HTTP response header, see [Access-Control-Expose-Headers](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Expose-Headers) in the MDN Web Docs.
         */
        public var accessControlExposeHeaders: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders? = null
        /**
         * A number that CloudFront uses as the value for the `Access-Control-Max-Age` HTTP response header.
         *
         * For more information about the `Access-Control-Max-Age` HTTP response header, see [Access-Control-Max-Age](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Max-Age) in the MDN Web Docs.
         */
        public var accessControlMaxAgeSec: kotlin.Int? = null
        /**
         * A Boolean that determines whether CloudFront overrides HTTP response headers received from the origin with the ones specified in this response headers policy.
         */
        public var originOverride: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCorsConfig) : this() {
            this.accessControlAllowCredentials = x.accessControlAllowCredentials
            this.accessControlAllowHeaders = x.accessControlAllowHeaders
            this.accessControlAllowMethods = x.accessControlAllowMethods
            this.accessControlAllowOrigins = x.accessControlAllowOrigins
            this.accessControlExposeHeaders = x.accessControlExposeHeaders
            this.accessControlMaxAgeSec = x.accessControlMaxAgeSec
            this.originOverride = x.originOverride
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyCorsConfig = ResponseHeadersPolicyCorsConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders] inside the given [block]
         */
        public fun accessControlAllowHeaders(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders.Builder.() -> kotlin.Unit) {
            this.accessControlAllowHeaders = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowHeaders.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods] inside the given [block]
         */
        public fun accessControlAllowMethods(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods.Builder.() -> kotlin.Unit) {
            this.accessControlAllowMethods = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethods.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins] inside the given [block]
         */
        public fun accessControlAllowOrigins(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins.Builder.() -> kotlin.Unit) {
            this.accessControlAllowOrigins = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders] inside the given [block]
         */
        public fun accessControlExposeHeaders(block: aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders.Builder.() -> kotlin.Unit) {
            this.accessControlExposeHeaders = aws.sdk.kotlin.services.cloudfront.model.ResponseHeadersPolicyAccessControlExposeHeaders.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (accessControlAllowCredentials == null) accessControlAllowCredentials = false
            if (originOverride == null) originOverride = false
            return this
        }
    }
}
