// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A real-time log configuration.
 */
public class RealtimeLogConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of this real-time log configuration.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration.
     */
    public val endPoints: List<EndPoint> = requireNotNull(builder.endPoints) { "A non-null value must be provided for endPoints" }
    /**
     * A list of fields that are included in each real-time log record. In an API response, the fields are provided in the same order in which they are sent to the Amazon Kinesis data stream.
     *
     * For more information about fields, see [Real-time log configuration fields](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) in the *Amazon CloudFront Developer Guide*.
     */
    public val fields: List<String> = requireNotNull(builder.fields) { "A non-null value must be provided for fields" }
    /**
     * The unique name of this real-time log configuration.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. The sampling rate is an integer between 1 and 100, inclusive.
     */
    public val samplingRate: kotlin.Long = requireNotNull(builder.samplingRate) { "A non-null value must be provided for samplingRate" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.RealtimeLogConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RealtimeLogConfig(")
        append("arn=$arn,")
        append("endPoints=$endPoints,")
        append("fields=$fields,")
        append("name=$name,")
        append("samplingRate=$samplingRate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (endPoints.hashCode())
        result = 31 * result + (fields.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (samplingRate.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RealtimeLogConfig

        if (arn != other.arn) return false
        if (endPoints != other.endPoints) return false
        if (fields != other.fields) return false
        if (name != other.name) return false
        if (samplingRate != other.samplingRate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.RealtimeLogConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of this real-time log configuration.
         */
        public var arn: kotlin.String? = null
        /**
         * Contains information about the Amazon Kinesis data stream where you are sending real-time log data for this real-time log configuration.
         */
        public var endPoints: List<EndPoint>? = null
        /**
         * A list of fields that are included in each real-time log record. In an API response, the fields are provided in the same order in which they are sent to the Amazon Kinesis data stream.
         *
         * For more information about fields, see [Real-time log configuration fields](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields) in the *Amazon CloudFront Developer Guide*.
         */
        public var fields: List<String>? = null
        /**
         * The unique name of this real-time log configuration.
         */
        public var name: kotlin.String? = null
        /**
         * The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. The sampling rate is an integer between 1 and 100, inclusive.
         */
        public var samplingRate: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.RealtimeLogConfig) : this() {
            this.arn = x.arn
            this.endPoints = x.endPoints
            this.fields = x.fields
            this.name = x.name
            this.samplingRate = x.samplingRate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.RealtimeLogConfig = RealtimeLogConfig(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (endPoints == null) endPoints = emptyList()
            if (fields == null) fields = emptyList()
            if (name == null) name = ""
            if (samplingRate == null) samplingRate = 0L
            return this
        }
    }
}
