// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * CloudFront Origin Shield.
 *
 * Using Origin Shield can help reduce the load on your origin. For more information, see [Using Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html) in the *Amazon CloudFront Developer Guide*.
 */
public class OriginShield private constructor(builder: Builder) {
    /**
     * A flag that specifies whether Origin Shield is enabled.
     *
     * When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * The Amazon Web Services Region for Origin Shield.
     *
     * Specify the Amazon Web Services Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as `us-east-2`.
     *
     * When you enable CloudFront Origin Shield, you must specify the Amazon Web Services Region for Origin Shield. For the list of Amazon Web Services Regions that you can specify, and for help choosing the best Region for your origin, see [Choosing the Amazon Web Services Region for Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region) in the *Amazon CloudFront Developer Guide*.
     */
    public val originShieldRegion: kotlin.String? = builder.originShieldRegion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.OriginShield = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OriginShield(")
        append("enabled=$enabled,")
        append("originShieldRegion=$originShieldRegion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (originShieldRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OriginShield

        if (enabled != other.enabled) return false
        if (originShieldRegion != other.originShieldRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.OriginShield = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A flag that specifies whether Origin Shield is enabled.
         *
         * When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The Amazon Web Services Region for Origin Shield.
         *
         * Specify the Amazon Web Services Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as `us-east-2`.
         *
         * When you enable CloudFront Origin Shield, you must specify the Amazon Web Services Region for Origin Shield. For the list of Amazon Web Services Regions that you can specify, and for help choosing the best Region for your origin, see [Choosing the Amazon Web Services Region for Origin Shield](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region) in the *Amazon CloudFront Developer Guide*.
         */
        public var originShieldRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.OriginShield) : this() {
            this.enabled = x.enabled
            this.originShieldRegion = x.originShieldRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.OriginShield = OriginShield(this)

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            return this
        }
    }
}
