// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request to list distributions that are associated with a specified WAF web ACL.
 */
public class ListDistributionsByWebAclIdRequest private constructor(builder: Builder) {
    /**
     * Use `Marker` and `MaxItems` to control pagination of results. If you have more than `MaxItems` distributions that satisfy the request, the response includes a `NextMarker` element. To get the next page of results, submit another request. For the value of `Marker`, specify the value of `NextMarker` from the last response. (For the first request, omit `Marker`.)
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of distributions that you want CloudFront to return in the response body. The maximum and default values are both 100.
     */
    public val maxItems: kotlin.Int? = builder.maxItems
    /**
     * The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID, the request returns a list of the distributions that aren't associated with a web ACL.
     *
     * For WAFV2, this is the ARN of the web ACL, such as `arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`.
     *
     * For WAF Classic, this is the ID of the web ACL, such as `a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`.
     */
    public val webAclId: kotlin.String? = builder.webAclId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByWebAclIdRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDistributionsByWebAclIdRequest(")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("webAclId=$webAclId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (webAclId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDistributionsByWebAclIdRequest

        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (webAclId != other.webAclId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByWebAclIdRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Use `Marker` and `MaxItems` to control pagination of results. If you have more than `MaxItems` distributions that satisfy the request, the response includes a `NextMarker` element. To get the next page of results, submit another request. For the value of `Marker`, specify the value of `NextMarker` from the last response. (For the first request, omit `Marker`.)
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of distributions that you want CloudFront to return in the response body. The maximum and default values are both 100.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID, the request returns a list of the distributions that aren't associated with a web ACL.
         *
         * For WAFV2, this is the ARN of the web ACL, such as `arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`.
         *
         * For WAF Classic, this is the ID of the web ACL, such as `a1b2c3d4-5678-90ab-cdef-EXAMPLE11111`.
         */
        public var webAclId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByWebAclIdRequest) : this() {
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.webAclId = x.webAclId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ListDistributionsByWebAclIdRequest = ListDistributionsByWebAclIdRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
