// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The key value store. Use this to separate data from function code, allowing you to update data without having to publish a new version of a function. The key value store holds keys and their corresponding values.
 */
public class KeyValueStore private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the key value store.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * A comment for the key value store.
     */
    public val comment: kotlin.String = requireNotNull(builder.comment) { "A non-null value must be provided for comment" }
    /**
     * The unique Id for the key value store.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The last-modified time of the key value store.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastModifiedTime) { "A non-null value must be provided for lastModifiedTime" }
    /**
     * The name of the key value store.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the key value store.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.KeyValueStore = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KeyValueStore(")
        append("arn=$arn,")
        append("comment=$comment,")
        append("id=$id,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (comment.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastModifiedTime.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KeyValueStore

        if (arn != other.arn) return false
        if (comment != other.comment) return false
        if (id != other.id) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.KeyValueStore = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the key value store.
         */
        public var arn: kotlin.String? = null
        /**
         * A comment for the key value store.
         */
        public var comment: kotlin.String? = null
        /**
         * The unique Id for the key value store.
         */
        public var id: kotlin.String? = null
        /**
         * The last-modified time of the key value store.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the key value store.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the key value store.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.KeyValueStore) : this() {
            this.arn = x.arn
            this.comment = x.comment
            this.id = x.id
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.KeyValueStore = KeyValueStore(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (comment == null) comment = ""
            if (id == null) id = ""
            if (lastModifiedTime == null) lastModifiedTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
