// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This configuration determines which HTTP requests are sent to the staging distribution. If the HTTP request contains a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the request is sent to the primary distribution.
 */
public class ContinuousDeploymentSingleHeaderConfig private constructor(builder: Builder) {
    /**
     * The request header name that you want CloudFront to send to your staging distribution. The header must contain the prefix `aws-cf-cd-`.
     */
    public val header: kotlin.String = requireNotNull(builder.header) { "A non-null value must be provided for header" }
    /**
     * The request header value.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.ContinuousDeploymentSingleHeaderConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContinuousDeploymentSingleHeaderConfig(")
        append("header=$header,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = header.hashCode()
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContinuousDeploymentSingleHeaderConfig

        if (header != other.header) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.ContinuousDeploymentSingleHeaderConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The request header name that you want CloudFront to send to your staging distribution. The header must contain the prefix `aws-cf-cd-`.
         */
        public var header: kotlin.String? = null
        /**
         * The request header value.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.ContinuousDeploymentSingleHeaderConfig) : this() {
            this.header = x.header
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.ContinuousDeploymentSingleHeaderConfig = ContinuousDeploymentSingleHeaderConfig(this)

        internal fun correctErrors(): Builder {
            if (header == null) header = ""
            if (value == null) value = ""
            return this
        }
    }
}
