// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * CloudFront origin access identity.
 */
public class CloudFrontOriginAccessIdentity private constructor(builder: Builder) {
    /**
     * The current configuration information for the identity.
     */
    public val cloudFrontOriginAccessIdentityConfig: aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig? = builder.cloudFrontOriginAccessIdentityConfig
    /**
     * The ID for the origin access identity, for example, `E74FTE3AJFJ256A`.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The Amazon S3 canonical user ID for the origin access identity, used when giving the origin access identity read permission to an object in Amazon S3.
     */
    public val s3CanonicalUserId: kotlin.String = requireNotNull(builder.s3CanonicalUserId) { "A non-null value must be provided for s3CanonicalUserId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudFrontOriginAccessIdentity(")
        append("cloudFrontOriginAccessIdentityConfig=$cloudFrontOriginAccessIdentityConfig,")
        append("id=$id,")
        append("s3CanonicalUserId=$s3CanonicalUserId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudFrontOriginAccessIdentityConfig?.hashCode() ?: 0
        result = 31 * result + (id.hashCode())
        result = 31 * result + (s3CanonicalUserId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudFrontOriginAccessIdentity

        if (cloudFrontOriginAccessIdentityConfig != other.cloudFrontOriginAccessIdentityConfig) return false
        if (id != other.id) return false
        if (s3CanonicalUserId != other.s3CanonicalUserId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The current configuration information for the identity.
         */
        public var cloudFrontOriginAccessIdentityConfig: aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig? = null
        /**
         * The ID for the origin access identity, for example, `E74FTE3AJFJ256A`.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon S3 canonical user ID for the origin access identity, used when giving the origin access identity read permission to an object in Amazon S3.
         */
        public var s3CanonicalUserId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentity) : this() {
            this.cloudFrontOriginAccessIdentityConfig = x.cloudFrontOriginAccessIdentityConfig
            this.id = x.id
            this.s3CanonicalUserId = x.s3CanonicalUserId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentity = CloudFrontOriginAccessIdentity(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig] inside the given [block]
         */
        public fun cloudFrontOriginAccessIdentityConfig(block: aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig.Builder.() -> kotlin.Unit) {
            this.cloudFrontOriginAccessIdentityConfig = aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (s3CanonicalUserId == null) s3CanonicalUserId = ""
            return this
        }
    }
}
