// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of cache policies.
 */
public class CachePolicyList private constructor(builder: Builder) {
    /**
     * Contains the cache policies in the list.
     */
    public val items: List<CachePolicySummary>? = builder.items
    /**
     * The maximum number of cache policies requested.
     */
    public val maxItems: kotlin.Int = requireNotNull(builder.maxItems) { "A non-null value must be provided for maxItems" }
    /**
     * If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the `Marker` field of a subsequent request to continue listing cache policies where you left off.
     */
    public val nextMarker: kotlin.String? = builder.nextMarker
    /**
     * The total number of cache policies returned in the response.
     */
    public val quantity: kotlin.Int = requireNotNull(builder.quantity) { "A non-null value must be provided for quantity" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudfront.model.CachePolicyList = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CachePolicyList(")
        append("items=$items,")
        append("maxItems=$maxItems,")
        append("nextMarker=$nextMarker,")
        append("quantity=$quantity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = items?.hashCode() ?: 0
        result = 31 * result + (maxItems)
        result = 31 * result + (nextMarker?.hashCode() ?: 0)
        result = 31 * result + (quantity)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CachePolicyList

        if (items != other.items) return false
        if (maxItems != other.maxItems) return false
        if (nextMarker != other.nextMarker) return false
        if (quantity != other.quantity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudfront.model.CachePolicyList = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains the cache policies in the list.
         */
        public var items: List<CachePolicySummary>? = null
        /**
         * The maximum number of cache policies requested.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * If there are more items in the list than are in this response, this element is present. It contains the value that you should use in the `Marker` field of a subsequent request to continue listing cache policies where you left off.
         */
        public var nextMarker: kotlin.String? = null
        /**
         * The total number of cache policies returned in the response.
         */
        public var quantity: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudfront.model.CachePolicyList) : this() {
            this.items = x.items
            this.maxItems = x.maxItems
            this.nextMarker = x.nextMarker
            this.quantity = x.quantity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudfront.model.CachePolicyList = CachePolicyList(this)

        internal fun correctErrors(): Builder {
            if (maxItems == null) maxItems = 0
            if (quantity == null) quantity = 0
            return this
        }
    }
}
