/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.cloudfront.endpoints;

import aws.sdk.kotlin.runtime.endpoint.functions.PartitionConfig;
import aws.sdk.kotlin.services.cloudfront.endpoints.CloudFrontEndpointParameters;
import aws.sdk.kotlin.services.cloudfront.endpoints.CloudFrontEndpointProvider;
import aws.sdk.kotlin.services.cloudfront.endpoints.internal.PartitionsKt;
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint;
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException;
import aws.smithy.kotlin.runtime.client.endpoints.SigningContextKt;
import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.collections.AttributesBuilder;
import aws.smithy.kotlin.runtime.collections.ValuesMap;
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthSchemeKt;
import aws.smithy.kotlin.runtime.net.url.Url;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Laws/sdk/kotlin/services/cloudfront/endpoints/DefaultCloudFrontEndpointProvider;", "Laws/sdk/kotlin/services/cloudfront/endpoints/CloudFrontEndpointProvider;", "()V", "resolveEndpoint", "Laws/smithy/kotlin/runtime/client/endpoints/Endpoint;", "params", "Laws/sdk/kotlin/services/cloudfront/endpoints/CloudFrontEndpointParameters;", "(Laws/sdk/kotlin/services/cloudfront/endpoints/CloudFrontEndpointParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cloudfront"})
@SourceDebugExtension(value={"SMAP\nDefaultCloudFrontEndpointProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCloudFrontEndpointProvider.kt\naws/sdk/kotlin/services/cloudfront/endpoints/DefaultCloudFrontEndpointProvider\n+ 2 Attributes.kt\naws/smithy/kotlin/runtime/collections/AttributesKt\n*L\n1#1,146:1\n231#2:147\n214#2:148\n231#2:149\n214#2:150\n231#2:151\n214#2:152\n*S KotlinDebug\n*F\n+ 1 DefaultCloudFrontEndpointProvider.kt\naws/sdk/kotlin/services/cloudfront/endpoints/DefaultCloudFrontEndpointProvider\n*L\n50#1:147\n50#1:148\n68#1:149\n68#1:150\n86#1:151\n86#1:152\n*E\n"})
public final class DefaultCloudFrontEndpointProvider
implements CloudFrontEndpointProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object resolveEndpoint(@NotNull CloudFrontEndpointParameters params, @NotNull Continuation<? super Endpoint> $completion) {
        if (params.getEndpoint() != null) {
            if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                throw new EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                throw new EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)params.getEndpoint(), null, (int)2, null), null, 2, null);
        }
        if (params.getRegion() != null) {
            DefaultCloudFrontEndpointProvider $this$resolveEndpoint_u24lambda_u243 = this;
            boolean bl = false;
            PartitionConfig partitionResult = PartitionsKt.partition(params.getRegion());
            if (partitionResult != null) {
                if (Intrinsics.areEqual((Object)partitionResult.getName(), (Object)"aws") && Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)false)) && Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)false))) {
                    void $this$resolveEndpoint_u24lambda_u243_u24lambda_u240;
                    AttributesBuilder attributesBuilder;
                    boolean $i$f$attributesOf = false;
                    boolean $i$f$mutableAttributesOf = false;
                    AttributesBuilder attributesBuilder2 = attributesBuilder = new AttributesBuilder();
                    ValuesMap valuesMap = null;
                    Url url = Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"https://cloudfront.amazonaws.com", null, (int)2, null);
                    boolean bl2 = false;
                    $this$resolveEndpoint_u24lambda_u243_u24lambda_u240.to(SigningContextKt.getSigningContextAttributeKey(), (Object)CollectionsKt.listOf((Object)SigV4AuthSchemeKt.sigV4$default((boolean)false, (String)"cloudfront", (String)"us-east-1", (Boolean)Boxing.boxBoolean((boolean)false), null, (int)17, null)));
                    Unit unit = Unit.INSTANCE;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 2;
                    Attributes attributes = (Attributes)attributesBuilder.getAttributes();
                    ValuesMap valuesMap2 = valuesMap;
                    Url url2 = url;
                    return new Endpoint(url2, valuesMap2, attributes, n, defaultConstructorMarker);
                }
                if (Intrinsics.areEqual((Object)partitionResult.getName(), (Object)"aws") && Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true)) && Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)false))) {
                    void $this$resolveEndpoint_u24lambda_u243_u24lambda_u241;
                    AttributesBuilder attributesBuilder;
                    boolean $i$f$attributesOf = false;
                    boolean $i$f$mutableAttributesOf = false;
                    AttributesBuilder $this$resolveEndpoint_u24lambda_u243_u24lambda_u240 = attributesBuilder = new AttributesBuilder();
                    ValuesMap valuesMap = null;
                    Url url = Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"https://cloudfront-fips.amazonaws.com", null, (int)2, null);
                    boolean bl3 = false;
                    $this$resolveEndpoint_u24lambda_u243_u24lambda_u241.to(SigningContextKt.getSigningContextAttributeKey(), (Object)CollectionsKt.listOf((Object)SigV4AuthSchemeKt.sigV4$default((boolean)false, (String)"cloudfront", (String)"us-east-1", (Boolean)Boxing.boxBoolean((boolean)false), null, (int)17, null)));
                    Unit unit = Unit.INSTANCE;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 2;
                    Attributes attributes = (Attributes)attributesBuilder.getAttributes();
                    ValuesMap valuesMap3 = valuesMap;
                    Url url3 = url;
                    return new Endpoint(url3, valuesMap3, attributes, n, defaultConstructorMarker);
                }
                if (Intrinsics.areEqual((Object)partitionResult.getName(), (Object)"aws-cn") && Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)false)) && Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)false))) {
                    void $this$resolveEndpoint_u24lambda_u243_u24lambda_u242;
                    AttributesBuilder attributesBuilder;
                    boolean $i$f$attributesOf = false;
                    boolean $i$f$mutableAttributesOf = false;
                    AttributesBuilder $this$resolveEndpoint_u24lambda_u243_u24lambda_u241 = attributesBuilder = new AttributesBuilder();
                    ValuesMap valuesMap = null;
                    Url url = Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"https://cloudfront.cn-northwest-1.amazonaws.com.cn", null, (int)2, null);
                    boolean bl4 = false;
                    $this$resolveEndpoint_u24lambda_u243_u24lambda_u242.to(SigningContextKt.getSigningContextAttributeKey(), (Object)CollectionsKt.listOf((Object)SigV4AuthSchemeKt.sigV4$default((boolean)false, (String)"cloudfront", (String)"cn-northwest-1", (Boolean)Boxing.boxBoolean((boolean)false), null, (int)17, null)));
                    Unit unit = Unit.INSTANCE;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 2;
                    Attributes attributes = (Attributes)attributesBuilder.getAttributes();
                    ValuesMap valuesMap4 = valuesMap;
                    Url url4 = url;
                    return new Endpoint(url4, valuesMap4, attributes, n, defaultConstructorMarker);
                }
                if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true)) && Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsFIPS()) && Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsDualStack())) {
                        return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://cloudfront-fips." + params.getRegion() + '.' + partitionResult.getDualStackDnsSuffix()), null, (int)2, null), null, 2, null);
                    }
                    throw new EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both");
                }
                if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)partitionResult.getSupportsFIPS(), (Object)Boxing.boxBoolean((boolean)true))) {
                        return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://cloudfront-fips." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, (int)2, null), null, 2, null);
                    }
                    throw new EndpointProviderException("FIPS is enabled but this partition does not support FIPS");
                }
                if (Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsDualStack())) {
                        return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://cloudfront." + params.getRegion() + '.' + partitionResult.getDualStackDnsSuffix()), null, (int)2, null), null, 2, null);
                    }
                    throw new EndpointProviderException("DualStack is enabled but this partition does not support DualStack");
                }
                return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://cloudfront." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, (int)2, null), null, 2, null);
            }
        }
        throw new EndpointProviderException("Invalid Configuration: Missing Region");
    }
}

