// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.StreamingDistribution
import aws.sdk.kotlin.services.cloudfront.model.UpdateStreamingDistributionResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateStreamingDistributionOperationDeserializer: HttpDeserialize<UpdateStreamingDistributionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateStreamingDistributionResponse {
        if (!response.status.isSuccess()) {
            throwUpdateStreamingDistributionError(context, response)
        }
        val builder = UpdateStreamingDistributionResponse.Builder()

        builder.eTag = response.headers["ETag"]

        val payload = response.body.readAll()
        if (payload != null) {
            builder.streamingDistribution = deserializeStreamingDistributionPayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwUpdateStreamingDistributionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedResponse)
        "CNAMEAlreadyExists" -> CnameAlreadyExistsDeserializer().deserialize(context, wrappedResponse)
        "IllegalUpdate" -> IllegalUpdateDeserializer().deserialize(context, wrappedResponse)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedResponse)
        "InvalidIfMatchVersion" -> InvalidIfMatchVersionDeserializer().deserialize(context, wrappedResponse)
        "InvalidOriginAccessControl" -> InvalidOriginAccessControlDeserializer().deserialize(context, wrappedResponse)
        "InvalidOriginAccessIdentity" -> InvalidOriginAccessIdentityDeserializer().deserialize(context, wrappedResponse)
        "MissingBody" -> MissingBodyDeserializer().deserialize(context, wrappedResponse)
        "NoSuchStreamingDistribution" -> NoSuchStreamingDistributionDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailed" -> PreconditionFailedDeserializer().deserialize(context, wrappedResponse)
        "TooManyStreamingDistributionCNAMEs" -> TooManyStreamingDistributionCnamEsDeserializer().deserialize(context, wrappedResponse)
        "TooManyTrustedSigners" -> TooManyTrustedSignersDeserializer().deserialize(context, wrappedResponse)
        "TrustedSignerDoesNotExist" -> TrustedSignerDoesNotExistDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
