// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.OriginRequestPolicy
import aws.sdk.kotlin.services.cloudfront.model.UpdateOriginRequestPolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateOriginRequestPolicyOperationDeserializer: HttpDeserialize<UpdateOriginRequestPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateOriginRequestPolicyResponse {
        if (!response.status.isSuccess()) {
            throwUpdateOriginRequestPolicyError(context, response)
        }
        val builder = UpdateOriginRequestPolicyResponse.Builder()

        builder.eTag = response.headers["ETag"]

        val payload = response.body.readAll()
        if (payload != null) {
            builder.originRequestPolicy = deserializeOriginRequestPolicyPayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwUpdateOriginRequestPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedResponse)
        "IllegalUpdate" -> IllegalUpdateDeserializer().deserialize(context, wrappedResponse)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedResponse)
        "InvalidIfMatchVersion" -> InvalidIfMatchVersionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchOriginRequestPolicy" -> NoSuchOriginRequestPolicyDeserializer().deserialize(context, wrappedResponse)
        "OriginRequestPolicyAlreadyExists" -> OriginRequestPolicyAlreadyExistsDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailed" -> PreconditionFailedDeserializer().deserialize(context, wrappedResponse)
        "TooManyCookiesInOriginRequestPolicy" -> TooManyCookiesInOriginRequestPolicyDeserializer().deserialize(context, wrappedResponse)
        "TooManyHeadersInOriginRequestPolicy" -> TooManyHeadersInOriginRequestPolicyDeserializer().deserialize(context, wrappedResponse)
        "TooManyQueryStringsInOriginRequestPolicy" -> TooManyQueryStringsInOriginRequestPolicyDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
