// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontException
import aws.sdk.kotlin.services.cloudfront.model.Distribution
import aws.sdk.kotlin.services.cloudfront.model.UpdateDistributionWithStagingConfigResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateDistributionWithStagingConfigOperationDeserializer: HttpDeserialize<UpdateDistributionWithStagingConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateDistributionWithStagingConfigResponse {
        if (!response.status.isSuccess()) {
            throwUpdateDistributionWithStagingConfigError(context, response)
        }
        val builder = UpdateDistributionWithStagingConfigResponse.Builder()

        builder.eTag = response.headers["ETag"]

        val payload = response.body.readAll()
        if (payload != null) {
            builder.distribution = deserializeDistributionPayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwUpdateDistributionWithStagingConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFrontException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDenied" -> AccessDeniedDeserializer().deserialize(context, wrappedResponse)
        "CNAMEAlreadyExists" -> CnameAlreadyExistsDeserializer().deserialize(context, wrappedResponse)
        "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior" -> IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorDeserializer().deserialize(context, wrappedResponse)
        "IllegalUpdate" -> IllegalUpdateDeserializer().deserialize(context, wrappedResponse)
        "InconsistentQuantities" -> InconsistentQuantitiesDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgument" -> InvalidArgumentDeserializer().deserialize(context, wrappedResponse)
        "InvalidDefaultRootObject" -> InvalidDefaultRootObjectDeserializer().deserialize(context, wrappedResponse)
        "InvalidErrorCode" -> InvalidErrorCodeDeserializer().deserialize(context, wrappedResponse)
        "InvalidForwardCookies" -> InvalidForwardCookiesDeserializer().deserialize(context, wrappedResponse)
        "InvalidFunctionAssociation" -> InvalidFunctionAssociationDeserializer().deserialize(context, wrappedResponse)
        "InvalidGeoRestrictionParameter" -> InvalidGeoRestrictionParameterDeserializer().deserialize(context, wrappedResponse)
        "InvalidHeadersForS3Origin" -> InvalidHeadersForS3OriginDeserializer().deserialize(context, wrappedResponse)
        "InvalidIfMatchVersion" -> InvalidIfMatchVersionDeserializer().deserialize(context, wrappedResponse)
        "InvalidLambdaFunctionAssociation" -> InvalidLambdaFunctionAssociationDeserializer().deserialize(context, wrappedResponse)
        "InvalidLocationCode" -> InvalidLocationCodeDeserializer().deserialize(context, wrappedResponse)
        "InvalidMinimumProtocolVersion" -> InvalidMinimumProtocolVersionDeserializer().deserialize(context, wrappedResponse)
        "InvalidOriginAccessControl" -> InvalidOriginAccessControlDeserializer().deserialize(context, wrappedResponse)
        "InvalidOriginAccessIdentity" -> InvalidOriginAccessIdentityDeserializer().deserialize(context, wrappedResponse)
        "InvalidOriginKeepaliveTimeout" -> InvalidOriginKeepaliveTimeoutDeserializer().deserialize(context, wrappedResponse)
        "InvalidOriginReadTimeout" -> InvalidOriginReadTimeoutDeserializer().deserialize(context, wrappedResponse)
        "InvalidQueryStringParameters" -> InvalidQueryStringParametersDeserializer().deserialize(context, wrappedResponse)
        "InvalidRelativePath" -> InvalidRelativePathDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequiredProtocol" -> InvalidRequiredProtocolDeserializer().deserialize(context, wrappedResponse)
        "InvalidResponseCode" -> InvalidResponseCodeDeserializer().deserialize(context, wrappedResponse)
        "InvalidTTLOrder" -> InvalidTtlOrderDeserializer().deserialize(context, wrappedResponse)
        "InvalidViewerCertificate" -> InvalidViewerCertificateDeserializer().deserialize(context, wrappedResponse)
        "InvalidWebACLId" -> InvalidWebAclIdDeserializer().deserialize(context, wrappedResponse)
        "MissingBody" -> MissingBodyDeserializer().deserialize(context, wrappedResponse)
        "NoSuchCachePolicy" -> NoSuchCachePolicyDeserializer().deserialize(context, wrappedResponse)
        "NoSuchDistribution" -> NoSuchDistributionDeserializer().deserialize(context, wrappedResponse)
        "NoSuchFieldLevelEncryptionConfig" -> NoSuchFieldLevelEncryptionConfigDeserializer().deserialize(context, wrappedResponse)
        "NoSuchOrigin" -> NoSuchOriginDeserializer().deserialize(context, wrappedResponse)
        "NoSuchOriginRequestPolicy" -> NoSuchOriginRequestPolicyDeserializer().deserialize(context, wrappedResponse)
        "NoSuchRealtimeLogConfig" -> NoSuchRealtimeLogConfigDeserializer().deserialize(context, wrappedResponse)
        "NoSuchResponseHeadersPolicy" -> NoSuchResponseHeadersPolicyDeserializer().deserialize(context, wrappedResponse)
        "PreconditionFailed" -> PreconditionFailedDeserializer().deserialize(context, wrappedResponse)
        "RealtimeLogConfigOwnerMismatch" -> RealtimeLogConfigOwnerMismatchDeserializer().deserialize(context, wrappedResponse)
        "TooManyCacheBehaviors" -> TooManyCacheBehaviorsDeserializer().deserialize(context, wrappedResponse)
        "TooManyCertificates" -> TooManyCertificatesDeserializer().deserialize(context, wrappedResponse)
        "TooManyCookieNamesInWhiteList" -> TooManyCookieNamesInWhiteListDeserializer().deserialize(context, wrappedResponse)
        "TooManyDistributionCNAMEs" -> TooManyDistributionCnamEsDeserializer().deserialize(context, wrappedResponse)
        "TooManyDistributionsAssociatedToCachePolicy" -> TooManyDistributionsAssociatedToCachePolicyDeserializer().deserialize(context, wrappedResponse)
        "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig" -> TooManyDistributionsAssociatedToFieldLevelEncryptionConfigDeserializer().deserialize(context, wrappedResponse)
        "TooManyDistributionsAssociatedToKeyGroup" -> TooManyDistributionsAssociatedToKeyGroupDeserializer().deserialize(context, wrappedResponse)
        "TooManyDistributionsAssociatedToOriginAccessControl" -> TooManyDistributionsAssociatedToOriginAccessControlDeserializer().deserialize(context, wrappedResponse)
        "TooManyDistributionsAssociatedToOriginRequestPolicy" -> TooManyDistributionsAssociatedToOriginRequestPolicyDeserializer().deserialize(context, wrappedResponse)
        "TooManyDistributionsAssociatedToResponseHeadersPolicy" -> TooManyDistributionsAssociatedToResponseHeadersPolicyDeserializer().deserialize(context, wrappedResponse)
        "TooManyDistributionsWithFunctionAssociations" -> TooManyDistributionsWithFunctionAssociationsDeserializer().deserialize(context, wrappedResponse)
        "TooManyDistributionsWithLambdaAssociations" -> TooManyDistributionsWithLambdaAssociationsDeserializer().deserialize(context, wrappedResponse)
        "TooManyDistributionsWithSingleFunctionARN" -> TooManyDistributionsWithSingleFunctionArnDeserializer().deserialize(context, wrappedResponse)
        "TooManyFunctionAssociations" -> TooManyFunctionAssociationsDeserializer().deserialize(context, wrappedResponse)
        "TooManyHeadersInForwardedValues" -> TooManyHeadersInForwardedValuesDeserializer().deserialize(context, wrappedResponse)
        "TooManyKeyGroupsAssociatedToDistribution" -> TooManyKeyGroupsAssociatedToDistributionDeserializer().deserialize(context, wrappedResponse)
        "TooManyLambdaFunctionAssociations" -> TooManyLambdaFunctionAssociationsDeserializer().deserialize(context, wrappedResponse)
        "TooManyOriginCustomHeaders" -> TooManyOriginCustomHeadersDeserializer().deserialize(context, wrappedResponse)
        "TooManyOriginGroupsPerDistribution" -> TooManyOriginGroupsPerDistributionDeserializer().deserialize(context, wrappedResponse)
        "TooManyOrigins" -> TooManyOriginsDeserializer().deserialize(context, wrappedResponse)
        "TooManyQueryStringParameters" -> TooManyQueryStringParametersDeserializer().deserialize(context, wrappedResponse)
        "TooManyTrustedSigners" -> TooManyTrustedSignersDeserializer().deserialize(context, wrappedResponse)
        "TrustedKeyGroupDoesNotExist" -> TrustedKeyGroupDoesNotExistDeserializer().deserialize(context, wrappedResponse)
        "TrustedSignerDoesNotExist" -> TrustedSignerDoesNotExistDeserializer().deserialize(context, wrappedResponse)
        else -> CloudFrontException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
