// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig
import aws.sdk.kotlin.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateCloudFrontOriginAccessIdentityOperationSerializer: HttpSerialize<UpdateCloudFrontOriginAccessIdentityRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateCloudFrontOriginAccessIdentityRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "2020-05-31",
                "origin-access-identity",
                "cloudfront",
                "${input.id}".encodeLabel(),
                "config",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.ifMatch?.isNotEmpty() == true) append("If-Match", input.ifMatch)
        }

        if (input.cloudFrontOriginAccessIdentityConfig != null) {
            val payload = serializeCloudFrontOriginAccessIdentityConfigPayloadWithXmlNameCloudFrontOriginAccessIdentityConfig(input.cloudFrontOriginAccessIdentityConfig)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}
