// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudfront.transform

import aws.sdk.kotlin.services.cloudfront.model.CachePolicyConfig
import aws.sdk.kotlin.services.cloudfront.model.UpdateCachePolicyRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateCachePolicyOperationSerializer: HttpSerialize<UpdateCachePolicyRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateCachePolicyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "2020-05-31",
                "cache-policy",
                "${input.id}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.ifMatch?.isNotEmpty() == true) append("If-Match", input.ifMatch)
        }

        if (input.cachePolicyConfig != null) {
            val payload = serializeCachePolicyConfigPayloadWithXmlNameCachePolicyConfig(input.cachePolicyConfig)
            builder.body = ByteArrayContent(payload)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}
